/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;

class CompilingGroovycRunner
extends JpsGroovycRunner<JavaSourceRootDescriptor, ModuleBuildTarget> {
    CompilingGroovycRunner(boolean forStubs) {
        super(forStubs);
    }

    @Override
    protected Set<ModuleBuildTarget> getTargets(ModuleChunk chunk) {
        return chunk.getTargets();
    }

    @Override
    protected Map<ModuleBuildTarget, String> getCanonicalOutputs(CompileContext context, ModuleChunk chunk, Builder builder) {
        return GroovyBuilder.getCanonicalModuleOutputs(context, chunk, builder);
    }

    @Override
    protected JavaSourceRootDescriptor findRoot(CompileContext context, File srcFile) {
        return context.getProjectDescriptor().getBuildRootIndex().findJavaRootDescriptor(context, srcFile);
    }

    @Override
    protected void stubsGenerated(CompileContext context, Map<ModuleBuildTarget, String> generationOutputs, MultiMap<ModuleBuildTarget, GroovycOutputParser.OutputItem> compiled) {
        CompilingGroovycRunner.addStubRootsToJavacSourcePath(context, generationOutputs);
        CompilingGroovycRunner.rememberStubSources(context, compiled);
    }

    private static void addStubRootsToJavacSourcePath(CompileContext context, Map<ModuleBuildTarget, String> generationOutputs) {
        BuildRootIndex rootsIndex = context.getProjectDescriptor().getBuildRootIndex();
        for (ModuleBuildTarget target : generationOutputs.keySet()) {
            File root = new File(generationOutputs.get(target));
            rootsIndex.associateTempRoot(context, (BuildTarget)target, (BuildRootDescriptor)new JavaSourceRootDescriptor(root, target, true, true, "", Collections.emptySet()));
        }
    }

    private static void rememberStubSources(CompileContext context, MultiMap<ModuleBuildTarget, GroovycOutputParser.OutputItem> compiled) {
        HashMap<String, String> stubToSrc = (HashMap<String, String>)GroovyBuilder.STUB_TO_SRC.get((UserDataHolder)context);
        if (stubToSrc == null) {
            stubToSrc = new HashMap<String, String>();
            GroovyBuilder.STUB_TO_SRC.set((UserDataHolder)context, stubToSrc);
        }
        for (GroovycOutputParser.OutputItem item : compiled.values()) {
            stubToSrc.put(FileUtil.toSystemIndependentName((String)item.outputPath), item.sourcePath);
        }
    }

    @Override
    protected Map<ModuleBuildTarget, String> getGenerationOutputs(CompileContext context, ModuleChunk chunk, Map<ModuleBuildTarget, String> finalOutputs) throws IOException {
        if (!this.myForStubs) {
            return super.getGenerationOutputs(context, chunk, finalOutputs);
        }
        HashMap<ModuleBuildTarget, String> generationOutputs = new HashMap<ModuleBuildTarget, String>();
        File commonRoot = GroovyBuilder.getStubRoot(context);
        for (ModuleBuildTarget target : chunk.getTargets()) {
            File targetRoot = new File(commonRoot, target.getModule().getName() + File.separator + target.getTargetType().getTypeId());
            if (targetRoot.exists() && !FileUtil.deleteWithRenaming((File)targetRoot)) {
                throw new IOException("External build cannot clean " + targetRoot.getPath());
            }
            if (!targetRoot.mkdirs()) {
                throw new IOException("External build cannot create " + targetRoot.getPath());
            }
            generationOutputs.put(target, targetRoot.getPath());
        }
        return generationOutputs;
    }
}

