/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.projectView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.compiler.Utils;
import com.intellij.uiDesigner.projectView.Form;
import com.intellij.uiDesigner.projectView.FormNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UIDesignerFavoriteNodeProvider
extends FavoriteNodeProvider {
    @Nullable
    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context, @NotNull ViewSettings viewSettings) {
        FileType fileType;
        VirtualFile vFile;
        Project project;
        if (viewSettings == null) {
            UIDesignerFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(context)) == null) {
            return null;
        }
        Form[] forms = (Form[])Form.DATA_KEY.getData(context);
        if (forms != null) {
            ArrayList result = new ArrayList();
            HashSet<PsiClass> bindClasses = new HashSet<PsiClass>();
            for (Form form : forms) {
                PsiClass classToBind = form.getClassToBind();
                if (bindClasses.contains(classToBind)) continue;
                bindClasses.add(classToBind);
                result.add(FormNode.constructFormNode(classToBind, project, viewSettings));
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        if ((vFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context)) != null && (fileType = vFile.getFileType()).equals(GuiFormFileType.INSTANCE)) {
            String className;
            PsiFile formFile = PsiManager.getInstance((Project)project).findFile(vFile);
            if (formFile == null) {
                return null;
            }
            String text = formFile.getText();
            try {
                className = Utils.getBoundClassName((String)text);
            }
            catch (Exception e) {
                return null;
            }
            if (className == null) {
                return null;
            }
            PsiClass classToBind = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)project));
            if (classToBind != null) {
                Form form = new Form(classToBind);
                FormNode node = new FormNode(project, form, viewSettings);
                return Collections.singletonList(node);
            }
        }
        return null;
    }

    public boolean elementContainsFile(Object element, VirtualFile vFile) {
        if (element instanceof Form) {
            Form form = (Form)element;
            return form.containsFile(vFile);
        }
        return false;
    }

    public int getElementWeight(Object element, boolean isSortByType) {
        if (element instanceof Form) {
            return 9;
        }
        return -1;
    }

    @Nullable
    public String getElementLocation(Object element) {
        if (element instanceof Form) {
            PsiFile[] psiFiles = ((Form)element).getFormFiles();
            VirtualFile vFile = null;
            if (psiFiles.length > 0) {
                vFile = psiFiles[0].getVirtualFile();
            }
            if (vFile != null) {
                return vFile.getPresentableUrl();
            }
        }
        return null;
    }

    public boolean isInvalidElement(Object element) {
        if (element instanceof Form) {
            return !((Form)element).isValid();
        }
        return false;
    }

    @NotNull
    @NonNls
    public String getFavoriteTypeId() {
        return "form";
    }

    @Nullable
    @NonNls
    public String getElementUrl(Object element) {
        if (element instanceof Form) {
            Form form = (Form)element;
            return form.getClassToBind().getQualifiedName();
        }
        return null;
    }

    public String getElementModuleName(Object element) {
        if (element instanceof Form) {
            Form form = (Form)element;
            Module module = ModuleUtil.findModuleForPsiElement((PsiElement)form.getClassToBind());
            return module != null ? module.getName() : null;
        }
        return null;
    }

    public Object[] createPathFromUrl(Project project, String url, String moduleName) {
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiClass classToBind = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(url, GlobalSearchScope.allScope((Project)project));
        if (classToBind == null) {
            return null;
        }
        return new Object[]{new Form(classToBind)};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewSettings", "com/intellij/uiDesigner/projectView/UIDesignerFavoriteNodeProvider", "getFavoriteNodes"));
    }
}

