/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.quickFixes;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.lw.IComponent;
import com.intellij.uiDesigner.quickFixes.QuickFix;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public final class CreateClassToBindFix
extends QuickFix {
    private static final Logger LOG = Logger.getInstance(CreateClassToBindFix.class);
    private final String myClassName;

    public CreateClassToBindFix(GuiEditor editor, @NotNull String className) {
        if (className == null) {
            CreateClassToBindFix.$$$reportNull$$$0(0);
        }
        super(editor, UIDesignerBundle.message("action.create.class", className), null);
        this.myClassName = className;
    }

    @Override
    public void run() {
        Project project = this.myEditor.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(this.myEditor.getFile());
        if (sourceRoot == null) {
            Messages.showErrorDialog((Component)this.myEditor, (String)UIDesignerBundle.message("error.cannot.create.class.not.in.source.root", new Object[0]), (String)CommonBundle.getErrorTitle());
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(project, () -> {
            PsiDirectory psiDirectory;
            int indexOfLastDot = this.myClassName.lastIndexOf(46);
            String packageName = this.myClassName.substring(0, indexOfLastDot != -1 ? indexOfLastDot : 0);
            if (packageName.length() > 0) {
                PackageWrapper packageWrapper = new PackageWrapper(PsiManager.getInstance((Project)project), packageName);
                try {
                    psiDirectory = RefactoringUtil.createPackageDirectoryInSourceRoot((PackageWrapper)packageWrapper, (VirtualFile)sourceRoot);
                    LOG.assertTrue(psiDirectory != null);
                }
                catch (IncorrectOperationException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myEditor, (String)UIDesignerBundle.message("error.cannot.create.package", packageName, e.getMessage()), (String)CommonBundle.getErrorTitle()));
                    return;
                }
            } else {
                psiDirectory = PsiManager.getInstance((Project)project).findDirectory(sourceRoot);
                LOG.assertTrue(psiDirectory != null);
            }
            try {
                String name = this.myClassName.substring(indexOfLastDot != -1 ? indexOfLastDot + 1 : 0);
                PsiClass aClass = JavaDirectoryService.getInstance().createClass(psiDirectory, name);
                this.createBoundFields(aClass);
            }
            catch (IncorrectOperationException e) {
                ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Component)this.myEditor, (String)UIDesignerBundle.message("error.cannot.create.class", packageName, e.getMessage()), (String)CommonBundle.getErrorTitle()));
            }
        }, this.getName(), null));
    }

    private void createBoundFields(final PsiClass formClass) throws IncorrectOperationException {
        Module module = this.myEditor.getRootContainer().getModule();
        final GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        final PsiManager psiManager = PsiManager.getInstance((Project)this.myEditor.getProject());
        final Ref exception = new Ref();
        FormEditingUtil.iterate(this.myEditor.getRootContainer(), new FormEditingUtil.ComponentVisitor(){

            public boolean visit(IComponent component) {
                PsiClass fieldClass;
                if (component.getBinding() != null && (fieldClass = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(component.getComponentClassName(), scope)) != null) {
                    PsiClassType fieldType = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createType(fieldClass);
                    try {
                        PsiField field = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createField(component.getBinding(), (PsiType)fieldType);
                        formClass.add((PsiElement)field);
                    }
                    catch (IncorrectOperationException e) {
                        exception.set((Object)e);
                        return false;
                    }
                }
                return true;
            }
        });
        if (!exception.isNull()) {
            throw (IncorrectOperationException)((Object)exception.get());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "com/intellij/uiDesigner/quickFixes/CreateClassToBindFix", "<init>"));
    }
}

