/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.enhancer;

import com.intellij.completion.enhancer.CompletionTimeStats;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.performance.IntervalCounter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CompletionTimeStatistics", storages={@Storage(value="completion.time.statistics")})
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0006R*\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/completion/enhancer/ContributorsTimeStatistics;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/completion/enhancer/CompletionTimeStats;", "()V", "completionIntervals", "Ljava/util/HashMap;", "Lcom/intellij/lang/Language;", "Lcom/intellij/performance/IntervalCounter;", "Lkotlin/collections/HashMap;", "secondCompletionIntervals", "getState", "intervals", "languge", "languages", "", "loadState", "", "state", "registerCompletionContributorsTime", "timeTaken", "", "registerSecondCompletionContributorsTime", "Companion", "intellij.statsCollector"})
public final class ContributorsTimeStatistics
implements PersistentStateComponent<CompletionTimeStats> {
    private final HashMap<Language, IntervalCounter> completionIntervals = new HashMap();
    private final HashMap<Language, IntervalCounter> secondCompletionIntervals = new HashMap();
    private static final int MIN_POWER = 7;
    private static final int MAX_POWER = 17;
    private static final double EXPONENT = 2.0;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull CompletionTimeStats state) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapKeysTo$iv$iv;
        IntervalCounter intervalCounter;
        void $this$mapValuesTo$iv$iv2;
        Object object;
        Object object2;
        Object object3;
        Object it;
        Map map;
        Map $this$mapKeysTo$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        this.completionIntervals.clear();
        this.secondCompletionIntervals.clear();
        Map<String, Integer[]> $this$mapKeys$iv = state.completionIntervals;
        boolean $i$f$mapKeys = false;
        Map<String, Integer[]> map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            if (Language.findLanguageByID((String)((String)it.getKey())) == null) {
                Intrinsics.throwNpe();
            }
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = object3;
            object = map;
            boolean bl2 = false;
            it = it$iv$iv.getValue();
            object.put(object2, it);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map bl = destination$iv$iv;
            boolean bl3 = false;
            object2 = it$iv$iv.getKey();
            object = (Map.Entry)element$iv$iv$iv;
            object3 = object2;
            map = bl;
            boolean bl4 = false;
            intervalCounter = new IntervalCounter(7, 17, 2.0, (Integer[])it2.getValue());
            map.put((String)object3, (Integer[])intervalCounter);
        }
        Map intervals = destination$iv$iv;
        Map $this$mapKeys$iv2 = state.secondCompletionIntervals;
        boolean $i$f$mapKeys2 = false;
        destination$iv$iv = $this$mapKeys$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv2.size()));
        boolean $i$f$mapKeysTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            Object it3;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl5 = false;
            if (Language.findLanguageByID((String)((String)it3.getKey())) == null) {
                Intrinsics.throwNpe();
            }
            object2 = (Map.Entry)element$iv$iv$iv;
            object = object3;
            Map bl4 = map;
            boolean bl6 = false;
            it3 = it$iv$iv.getValue();
            bl4.put(object, it3);
        }
        Map $this$mapValues$iv2 = destination$iv$iv2;
        boolean $i$f$mapValues2 = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv2;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it4;
            void it$iv$iv;
            Map.Entry it3 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl = false;
            object = it$iv$iv.getKey();
            Map.Entry bl4 = (Map.Entry)element$iv$iv$iv;
            object3 = object;
            map = map3;
            boolean bl7 = false;
            intervalCounter = new IntervalCounter(7, 17, 2.0, (Integer[])it4.getValue());
            map.put(object3, intervalCounter);
        }
        Map secondIntervals = destination$iv$iv2;
        this.completionIntervals.putAll(intervals);
        this.secondCompletionIntervals.putAll(secondIntervals);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CompletionTimeStats getState() {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapKeysTo$iv$iv;
        Integer[] integerArray;
        void $this$mapValuesTo$iv$iv2;
        Object object;
        Object object2;
        Object object3;
        Object it;
        Map map;
        Map $this$mapKeysTo$iv$iv2;
        Map $this$mapKeys$iv = this.completionIntervals;
        boolean $i$f$mapKeys = false;
        Map map2 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            object3 = ((Language)it.getKey()).getID();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object2 = object3;
            object = map;
            boolean bl2 = false;
            it = it$iv$iv.getValue();
            object.put(object2, it);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv2 = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map bl = destination$iv$iv;
            boolean bl3 = false;
            object2 = it$iv$iv.getKey();
            object = (Map.Entry)element$iv$iv$iv;
            object3 = object2;
            map = bl;
            boolean bl4 = false;
            integerArray = ((IntervalCounter)it2.getValue()).getData();
            map.put(object3, integerArray);
        }
        Map completionIntervalArrays = destination$iv$iv;
        Map $this$mapKeys$iv2 = this.secondCompletionIntervals;
        boolean $i$f$mapKeys2 = false;
        destination$iv$iv = $this$mapKeys$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv2.size()));
        boolean $i$f$mapKeysTo2 = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            Object it3;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv2;
            boolean bl5 = false;
            object3 = ((Language)it3.getKey()).getID();
            object2 = (Map.Entry)element$iv$iv$iv;
            object = object3;
            Map bl4 = map;
            boolean bl6 = false;
            it3 = it$iv$iv.getValue();
            bl4.put(object, it3);
        }
        Map $this$mapValues$iv2 = destination$iv$iv2;
        boolean $i$f$mapValues2 = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv2;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo2 = false;
        $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it4;
            void it$iv$iv;
            Map.Entry it3 = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl = false;
            object = it$iv$iv.getKey();
            Map.Entry bl4 = (Map.Entry)element$iv$iv$iv;
            object3 = object;
            map = map3;
            boolean bl7 = false;
            integerArray = ((IntervalCounter)it4.getValue()).getData();
            map.put(object3, integerArray);
        }
        Map secondIntervalArrays = destination$iv$iv2;
        CompletionTimeStats completionTimeStats = new CompletionTimeStats();
        boolean bl = false;
        boolean bl8 = false;
        CompletionTimeStats $this$apply = completionTimeStats;
        boolean bl9 = false;
        $this$apply.completionIntervals = completionIntervalArrays;
        $this$apply.secondCompletionIntervals = secondIntervalArrays;
        return completionTimeStats;
    }

    @NotNull
    public final List<Language> languages() {
        Set<Language> set = this.completionIntervals.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"completionIntervals.keys");
        Set<Language> set2 = this.secondCompletionIntervals.keySet();
        Intrinsics.checkExpressionValueIsNotNull(set2, (String)"secondCompletionIntervals.keys");
        return CollectionsKt.toList((Iterable)SetsKt.plus(set, (Iterable)set2));
    }

    @Nullable
    public final IntervalCounter intervals(@NotNull Language languge) {
        Intrinsics.checkParameterIsNotNull((Object)languge, (String)"languge");
        return this.completionIntervals.get(languge);
    }

    @Nullable
    public final IntervalCounter secondCompletionIntervals(@NotNull Language languge) {
        Intrinsics.checkParameterIsNotNull((Object)languge, (String)"languge");
        return this.secondCompletionIntervals.get(languge);
    }

    public final void registerCompletionContributorsTime(@NotNull Language languge, long timeTaken) {
        Intrinsics.checkParameterIsNotNull((Object)languge, (String)"languge");
        IntervalCounter intervalCounter = this.completionIntervals.get(languge);
        if (intervalCounter == null) {
            intervalCounter = new IntervalCounter(7, 17, 2.0, null, 8, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)intervalCounter, (String)"completionIntervals[lang\u2026WER, MAX_POWER, EXPONENT)");
        IntervalCounter interval = intervalCounter;
        interval.register(timeTaken);
        ((Map)this.completionIntervals).put(languge, interval);
    }

    public final void registerSecondCompletionContributorsTime(@NotNull Language languge, long timeTaken) {
        Intrinsics.checkParameterIsNotNull((Object)languge, (String)"languge");
        IntervalCounter intervalCounter = this.secondCompletionIntervals.get(languge);
        if (intervalCounter == null) {
            intervalCounter = new IntervalCounter(7, 17, 2.0, null, 8, null);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)intervalCounter, (String)"secondCompletionInterval\u2026WER, MAX_POWER, EXPONENT)");
        IntervalCounter interval = intervalCounter;
        interval.register(timeTaken);
        ((Map)this.secondCompletionIntervals).put(languge, interval);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/completion/enhancer/ContributorsTimeStatistics$Companion;", "", "()V", "EXPONENT", "", "MAX_POWER", "", "MIN_POWER", "getInstance", "Lcom/intellij/completion/enhancer/ContributorsTimeStatistics;", "intellij.statsCollector"})
    public static final class Companion {
        @NotNull
        public final ContributorsTimeStatistics getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(ContributorsTimeStatistics.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (ContributorsTimeStatistics)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

