/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.sorting;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupCellRenderer;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.settings.CompletionMLRankingSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Key;
import com.intellij.stats.completion.LookupTracker;
import com.intellij.stats.storage.factors.LookupStorage;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/sorting/PositionDiffArrowInitializer;", "Lcom/intellij/openapi/project/ProjectManagerListener;", "()V", "projectOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.statsCollector"})
public final class PositionDiffArrowInitializer
implements ProjectManagerListener {
    @NotNull
    private static final Key<AtomicInteger> POSITION_DIFF_KEY;
    @NotNull
    public static final String ARROW_UP = "\u2191";
    @NotNull
    public static final String ARROW_DOWN = "\u2193";
    private static final JBColor ML_RANK_DIFF_GREEN_COLOR;
    public static final Companion Companion;

    public void projectOpened(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        LookupManager.getInstance((Project)project).addPropertyChangeListener((PropertyChangeListener)new LookupTracker(){

            private final boolean shouldShowDiff(LookupStorage lookupStorage) {
                CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
                CompletionMLRankingSettings mlRankingSettings = completionMLRankingSettings;
                return lookupStorage.getModel() != null && mlRankingSettings.isShowDiffEnabled();
            }

            protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
                Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
                Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
                if (!this.shouldShowDiff(storage)) {
                    return;
                }
                lookup.addPresentationCustomizer(new LookupCellRenderer.ItemPresentationCustomizer(){

                    @NotNull
                    public LookupElementPresentation customizePresentation(@NotNull LookupElement item, @NotNull LookupElementPresentation presentation) {
                        Color color;
                        String text;
                        Integer diff;
                        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
                        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
                        AtomicInteger atomicInteger = (AtomicInteger)item.getUserData(PositionDiffArrowInitializer.Companion.getPOSITION_DIFF_KEY());
                        Integer n = diff = atomicInteger != null ? Integer.valueOf(atomicInteger.get()) : null;
                        if (diff == null || diff == 0) {
                            return presentation;
                        }
                        LookupElementPresentation newPresentation = new LookupElementPresentation();
                        newPresentation.copyFrom(presentation);
                        String string = text = diff < 0 ? " \u2191" + -diff.intValue() + ' ' : " \u2193" + diff + ' ';
                        if (diff < 0) {
                            color = (Color)PositionDiffArrowInitializer.access$getML_RANK_DIFF_GREEN_COLOR$cp();
                        } else {
                            JBColor jBColor = JBColor.RED;
                            Intrinsics.checkExpressionValueIsNotNull((Object)jBColor, (String)"JBColor.RED");
                            color = (Color)jBColor;
                        }
                        Color color2 = color;
                        List list = presentation.getTailFragments();
                        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"presentation.tailFragments");
                        List fragments = list;
                        newPresentation.setTailText(text, color2);
                        for (LookupElementPresentation.TextFragment fragment : fragments) {
                            String string2 = fragment.text;
                            LookupElementPresentation.TextFragment textFragment = fragment;
                            Intrinsics.checkExpressionValueIsNotNull((Object)textFragment, (String)"fragment");
                            newPresentation.appendTailText(string2, textFragment.isGrayed());
                        }
                        return newPresentation;
                    }
                });
            }
        }, (Disposable)project);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"PositionChangingArrowsInitializer.POSITION_DIFF_KEY");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<AtomicInteger\u2026lizer.POSITION_DIFF_KEY\")");
        POSITION_DIFF_KEY = key;
        ML_RANK_DIFF_GREEN_COLOR = new JBColor(JBColor.GREEN.darker(), JBColor.GREEN.brighter());
    }

    public static final /* synthetic */ JBColor access$getML_RANK_DIFF_GREEN_COLOR$cp() {
        return ML_RANK_DIFF_GREEN_COLOR;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\t\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/completion/sorting/PositionDiffArrowInitializer$Companion;", "", "()V", "ARROW_DOWN", "", "ARROW_UP", "ML_RANK_DIFF_GREEN_COLOR", "Lcom/intellij/ui/JBColor;", "POSITION_DIFF_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/atomic/AtomicInteger;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getPOSITION_DIFF_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.statsCollector"})
    public static final class Companion {
        @NotNull
        public final Key<AtomicInteger> getPOSITION_DIFF_KEY() {
            return POSITION_DIFF_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

