"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../utils/commons");
var geometry_1 = require("../../../utils/geometry");
var spec_1 = require("../state/utils/spec");
var tooltip_1 = require("../tooltip/tooltip");
var series_1 = require("../utils/series");
var specs_1 = require("../utils/specs");
function getPostfix(spec) {
    if (specs_1.isAreaSeriesSpec(spec) || specs_1.isBarSeriesSpec(spec)) {
        var _a = spec.y0AccessorFormat, y0AccessorFormat = _a === void 0 ? tooltip_1.Y0_ACCESSOR_POSTFIX : _a, _b = spec.y1AccessorFormat, y1AccessorFormat = _b === void 0 ? tooltip_1.Y1_ACCESSOR_POSTFIX : _b;
        return {
            y0AccessorFormat: y0AccessorFormat,
            y1AccessorFormat: y1AccessorFormat,
        };
    }
    return {};
}
function getBandedLegendItemLabel(name, yAccessor, postfixes) {
    return yAccessor === geometry_1.BandedAccessorType.Y1
        ? "" + name + postfixes.y1AccessorFormat
        : "" + name + postfixes.y0AccessorFormat;
}
function computeLegend(seriesCollection, seriesColors, specs, defaultColor, axesSpecs, deselectedDataSeries) {
    if (deselectedDataSeries === void 0) { deselectedDataSeries = []; }
    var legendItems = [];
    var sortedCollection = series_1.getSortedDataSeriesColorsValuesMap(seriesCollection);
    sortedCollection.forEach(function (series, key) {
        var banded = series.banded, lastValue = series.lastValue, seriesIdentifier = series.seriesIdentifier;
        var spec = spec_1.getSpecsById(specs, seriesIdentifier.specId);
        var color = seriesColors.get(key) || defaultColor;
        var hasSingleSeries = seriesCollection.size === 1;
        var name = series_1.getSeriesName(seriesIdentifier, hasSingleSeries, false, spec);
        var isSeriesHidden = deselectedDataSeries ? series_1.getSeriesIndex(deselectedDataSeries, seriesIdentifier) >= 0 : false;
        if (name === '' || !spec) {
            return;
        }
        var postFixes = getPostfix(spec);
        var labelY1 = banded ? getBandedLegendItemLabel(name, geometry_1.BandedAccessorType.Y1, postFixes) : name;
        var yAxis = spec_1.getAxesSpecForSpecId(axesSpecs, spec.groupId).yAxis;
        var formatter = yAxis ? yAxis.tickFormat : commons_1.identity;
        var hideInLegend = spec.hideInLegend;
        legendItems.push({
            color: color,
            label: labelY1,
            seriesIdentifier: seriesIdentifier,
            childId: geometry_1.BandedAccessorType.Y1,
            isSeriesHidden: isSeriesHidden,
            isItemHidden: hideInLegend,
            isToggleable: true,
            defaultExtra: {
                raw: lastValue && lastValue.y1 !== null ? lastValue.y1 : null,
                formatted: lastValue && lastValue.y1 !== null ? formatter(lastValue.y1) : null,
            },
        });
        if (banded) {
            var labelY0 = getBandedLegendItemLabel(name, geometry_1.BandedAccessorType.Y0, postFixes);
            legendItems.push({
                color: color,
                label: labelY0,
                seriesIdentifier: seriesIdentifier,
                childId: geometry_1.BandedAccessorType.Y0,
                isSeriesHidden: isSeriesHidden,
                isItemHidden: hideInLegend,
                isToggleable: true,
                defaultExtra: {
                    raw: lastValue && lastValue.y0 !== null ? lastValue.y0 : null,
                    formatted: lastValue && lastValue.y0 !== null ? formatter(lastValue.y0) : null,
                },
            });
        }
    });
    return legendItems;
}
exports.computeLegend = computeLegend;
//# sourceMappingURL=legend.js.map