"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var chart_types_1 = require("../chart_types");
var chart_state_1 = require("../chart_types/goal_chart/state/chart_state");
var chart_state_2 = require("../chart_types/partition_chart/state/chart_state");
var chart_state_3 = require("../chart_types/xy_chart/state/chart_state");
var constants_1 = require("../specs/constants");
var logger_1 = require("../utils/logger");
var chart_1 = require("./actions/chart");
var chart_settings_1 = require("./actions/chart_settings");
var colors_1 = require("./actions/colors");
var events_1 = require("./actions/events");
var specs_1 = require("./actions/specs");
var interactions_1 = require("./reducers/interactions");
var get_internal_is_intialized_1 = require("./selectors/get_internal_is_intialized");
var get_legend_items_1 = require("./selectors/get_legend_items");
exports.getInitialState = function (chartId) {
    var _a;
    return ({
        chartId: chartId,
        specsInitialized: false,
        specParsing: false,
        chartRendered: false,
        chartRenderedCount: 0,
        specs: (_a = {},
            _a[constants_1.DEFAULT_SETTINGS_SPEC.id] = constants_1.DEFAULT_SETTINGS_SPEC,
            _a),
        colors: {
            temporary: {},
            persisted: {},
        },
        chartType: null,
        internalChartState: null,
        interactions: {
            pointer: {
                dragging: false,
                current: {
                    position: {
                        x: -1,
                        y: -1,
                    },
                    time: 0,
                },
                down: null,
                up: null,
                lastDrag: null,
                lastClick: null,
            },
            legendCollapsed: false,
            highlightedLegendItemKey: null,
            deselectedDataSeries: [],
        },
        externalEvents: {
            pointer: null,
        },
        parentDimensions: {
            height: 0,
            width: 0,
            left: 0,
            top: 0,
        },
    });
};
exports.chartStoreReducer = function (chartId) {
    var initialState = exports.getInitialState(chartId);
    return function (state, action) {
        var _a, _b, _c, _d;
        if (state === void 0) { state = initialState; }
        switch (action.type) {
            case specs_1.SPEC_PARSED:
                var chartType = findMainChartType(state.specs);
                if (isChartTypeChanged(state, chartType)) {
                    var internalChartState = initInternalChartState(chartType);
                    return __assign(__assign({}, state), { specsInitialized: true, specParsing: false, chartType: chartType,
                        internalChartState: internalChartState });
                }
                return __assign(__assign({}, state), { specsInitialized: true, specParsing: false, chartType: chartType });
            case specs_1.SPEC_UNMOUNTED:
                return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false });
            case specs_1.UPSERT_SPEC:
                if (!state.specParsing) {
                    return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false, specParsing: true, specs: (_a = {},
                            _a[constants_1.DEFAULT_SETTINGS_SPEC.id] = constants_1.DEFAULT_SETTINGS_SPEC,
                            _a[action.spec.id] = action.spec,
                            _a) });
                }
                return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false, specs: __assign(__assign({}, state.specs), (_b = {}, _b[action.spec.id] = action.spec, _b)) });
            case specs_1.REMOVE_SPEC:
                var _e = state.specs, _f = action.id, specToRemove = _e[_f], rest = __rest(_e, [typeof _f === "symbol" ? _f : _f + ""]);
                return __assign(__assign({}, state), { specsInitialized: false, chartRendered: false, specParsing: true, specs: __assign({}, rest) });
            case chart_1.CHART_RENDERED:
                var count = state.chartRendered ? state.chartRenderedCount : state.chartRenderedCount + 1;
                return __assign(__assign({}, state), { chartRendered: true, chartRenderedCount: count });
            case chart_settings_1.UPDATE_PARENT_DIMENSION:
                return __assign(__assign({}, state), { parentDimensions: __assign({}, action.dimensions) });
            case events_1.EXTERNAL_POINTER_EVENT:
                if (action.event.chartId === chartId) {
                    return __assign(__assign({}, state), { externalEvents: __assign(__assign({}, state.externalEvents), { pointer: null }) });
                }
                return __assign(__assign({}, state), { externalEvents: __assign(__assign({}, state.externalEvents), { pointer: __assign({}, action.event) }) });
            case colors_1.CLEAR_TEMPORARY_COLORS:
                return __assign(__assign({}, state), { colors: __assign(__assign({}, state.colors), { temporary: {} }) });
            case colors_1.SET_TEMPORARY_COLOR:
                return __assign(__assign({}, state), { colors: __assign(__assign({}, state.colors), { temporary: __assign(__assign({}, state.colors.temporary), (_c = {}, _c[action.key] = action.color, _c)) }) });
            case colors_1.SET_PERSISTED_COLOR:
                return __assign(__assign({}, state), { colors: __assign(__assign({}, state.colors), { persisted: __assign(__assign({}, state.colors.persisted), (_d = {}, _d[action.key] = action.color, _d)) }) });
            default:
                if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
                    return state;
                }
                return __assign(__assign({}, state), { interactions: interactions_1.interactionsReducer(state.interactions, action, get_legend_items_1.getLegendItemsSelector(state)) });
        }
    };
};
function findMainChartType(specs) {
    var types = Object.keys(specs).reduce(function (acc, specId) {
        var chartType = specs[specId].chartType;
        var accumulator = acc[chartType];
        if (accumulator === undefined) {
            accumulator = 0;
        }
        else {
            accumulator += 1;
        }
        acc[chartType] = accumulator;
        return acc;
    }, {});
    var chartTypes = Object.keys(types).filter(function (type) { return type !== chart_types_1.ChartTypes.Global; });
    if (chartTypes.length > 1) {
        logger_1.Logger.warn('Multiple chart type on the same configuration');
        return null;
    }
    return chartTypes[0];
}
function initInternalChartState(chartType) {
    switch (chartType) {
        case chart_types_1.ChartTypes.Goal:
            return new chart_state_1.GoalState();
        case chart_types_1.ChartTypes.Partition:
            return new chart_state_2.PartitionState();
        case chart_types_1.ChartTypes.XYAxis:
            return new chart_state_3.XYAxisChartState();
        default:
            return null;
    }
}
function isChartTypeChanged(state, newChartType) {
    return state.chartType !== newChartType;
}
//# sourceMappingURL=chart_state.js.map