function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, PureComponent } from 'react';
import { i18n } from '@kbn/i18n';
import { EuiSearchBar, EuiFormErrorText } from '@elastic/eui';
import { getCategoryName } from '../../lib';
export var Search = /*#__PURE__*/function (_PureComponent) {
  _inherits(Search, _PureComponent);

  var _super = _createSuper(Search);

  function Search(props) {
    var _this;

    _classCallCheck(this, Search);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "categories", []);

    _defineProperty(_assertThisInitialized(_this), "state", {
      isSearchTextValid: true,
      parseErrorMessage: null
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (_ref) {
      var query = _ref.query,
          error = _ref.error;

      if (error) {
        _this.setState({
          isSearchTextValid: false,
          parseErrorMessage: error.message
        });

        return;
      }

      _this.setState({
        isSearchTextValid: true,
        parseErrorMessage: null
      });

      _this.props.onQueryChange({
        query: query
      });
    });

    var categories = props.categories;
    _this.categories = categories.map(function (category) {
      return {
        value: category,
        name: getCategoryName(category)
      };
    });
    return _this;
  }

  _createClass(Search, [{
    key: "render",
    value: function render() {
      var query = this.props.query;
      var box = {
        incremental: true,
        'data-test-subj': 'settingsSearchBar',
        'aria-label': i18n.translate('advancedSettings.searchBarAriaLabel', {
          defaultMessage: 'Search advanced settings'
        }) // hack until EuiSearchBar is fixed

      };
      var filters = [{
        type: 'field_value_selection',
        field: 'category',
        name: i18n.translate('advancedSettings.categorySearchLabel', {
          defaultMessage: 'Category'
        }),
        multiSelect: 'or',
        options: this.categories
      }];
      var queryParseError;

      if (!this.state.isSearchTextValid) {
        var parseErrorMsg = i18n.translate('advancedSettings.searchBar.unableToParseQueryErrorMessage', {
          defaultMessage: 'Unable to parse query'
        });
        queryParseError = /*#__PURE__*/React.createElement(EuiFormErrorText, null, "".concat(parseErrorMsg, ". ").concat(this.state.parseErrorMessage));
      }

      return /*#__PURE__*/React.createElement(Fragment, null, /*#__PURE__*/React.createElement(EuiSearchBar, {
        box: box,
        filters: filters,
        onChange: this.onChange,
        query: query
      }), queryParseError);
    }
  }]);

  return Search;
}(PureComponent);