function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, memo } from 'react';
import { debounce } from 'lodash';
import { EuiProgress } from '@elastic/eui';
import { EditorContentSpinner } from '../../components';
import { Panel, PanelsContainer } from '../../../../../kibana_react/public';
import { Editor as EditorUI, EditorOutput } from './legacy/console_editor';
import { StorageKeys } from '../../../services';
import { useEditorReadContext, useServicesContext, useRequestReadContext } from '../../contexts';
var INITIAL_PANEL_WIDTH = 50;
var PANEL_MIN_WIDTH = '100px';
export var Editor = /*#__PURE__*/memo(function (_ref) {
  var loading = _ref.loading;

  var _useServicesContext = useServicesContext(),
      storage = _useServicesContext.services.storage;

  var _useEditorReadContext = useEditorReadContext(),
      currentTextObject = _useEditorReadContext.currentTextObject;

  var _useRequestReadContex = useRequestReadContext(),
      requestInFlight = _useRequestReadContex.requestInFlight;

  var _storage$get = storage.get(StorageKeys.WIDTH, [INITIAL_PANEL_WIDTH, INITIAL_PANEL_WIDTH]),
      _storage$get2 = _slicedToArray(_storage$get, 2),
      firstPanelWidth = _storage$get2[0],
      secondPanelWidth = _storage$get2[1];
  /* eslint-disable-next-line react-hooks/exhaustive-deps */


  var onPanelWidthChange = useCallback(debounce(function (widths) {
    storage.set(StorageKeys.WIDTH, widths);
  }, 300), []);
  if (!currentTextObject) return null;
  return /*#__PURE__*/React.createElement(React.Fragment, null, requestInFlight ? /*#__PURE__*/React.createElement("div", {
    className: "conApp__requestProgressBarContainer"
  }, /*#__PURE__*/React.createElement(EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  })) : null, /*#__PURE__*/React.createElement(PanelsContainer, {
    onPanelWidthChange: onPanelWidthChange,
    resizerClassName: "conApp__resizer"
  }, /*#__PURE__*/React.createElement(Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: firstPanelWidth
  }, loading ? /*#__PURE__*/React.createElement(EditorContentSpinner, null) : /*#__PURE__*/React.createElement(EditorUI, {
    initialTextValue: currentTextObject.text
  })), /*#__PURE__*/React.createElement(Panel, {
    style: {
      height: '100%',
      position: 'relative',
      minWidth: PANEL_MIN_WIDTH
    },
    initialWidth: secondPanelWidth
  }, loading ? /*#__PURE__*/React.createElement(EditorContentSpinner, null) : /*#__PURE__*/React.createElement(EditorOutput, null))));
});