/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiToolTip, EuiFlexItem, EuiFlexGroup, EuiTitle, EuiButtonEmpty } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { i18n } from '@kbn/i18n';

/**
 * Component displaying the title of the current selected index pattern
 * and if changeable is true, a link is provided to change the index pattern
 */
export function DiscoverIndexPatternTitle(_ref) {
  var isChangeable = _ref.isChangeable,
      onChange = _ref.onChange,
      title = _ref.title;
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "none",
    responsive: false,
    className: "index-pattern-selection"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: title
  }, /*#__PURE__*/React.createElement(EuiTitle, {
    size: "xxs",
    className: "eui-textTruncate"
  }, /*#__PURE__*/React.createElement("h2", {
    title: title
  }, title)))), isChangeable && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "discover.fieldChooser.indexPattern.changeLinkTooltip",
      defaultMessage: "Change current index pattern"
    })
  }, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    "aria-label": i18n.translate('discover.fieldChooser.indexPattern.changeLinkAriaLabel', {
      defaultMessage: 'Change current index pattern'
    }),
    "data-test-subj": "indexPattern-switch-link",
    size: "xs",
    onClick: function onClick() {
      return onChange();
    },
    iconSide: "right",
    iconType: "arrowDown",
    color: "text"
  }))));
}