function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiPanel, htmlIdGenerator } from '@elastic/eui';
import classNames from 'classnames';
import React from 'react';
import { Subscription } from 'rxjs';
import { buildContextMenuForActions } from '../ui_actions';
import { toMountPoint } from '../../../../kibana_react/public';
import { CONTEXT_MENU_TRIGGER, PANEL_BADGE_TRIGGER, PANEL_NOTIFICATION_TRIGGER } from '../triggers';
import { ViewMode } from '../types';
import { RemovePanelAction } from './panel_header/panel_actions';
import { AddPanelAction } from './panel_header/panel_actions/add_panel/add_panel_action';
import { CustomizePanelTitleAction } from './panel_header/panel_actions/customize_title/customize_panel_action';
import { PanelHeader } from './panel_header/panel_header';
import { InspectPanelAction } from './panel_header/panel_actions/inspect_panel_action';
import { EditPanelAction } from '../actions';
import { CustomizePanelModal } from './panel_header/panel_actions/customize_title/customize_panel_modal';
import { EmbeddableErrorLabel } from './embeddable_error_label';

var sortByOrderField = function sortByOrderField(_ref, _ref2) {
  var orderA = _ref.order;
  var orderB = _ref2.order;
  return (orderB || 0) - (orderA || 0);
};

var removeById = function removeById(disabledActions) {
  return function (_ref3) {
    var id = _ref3.id;
    return disabledActions.indexOf(id) === -1;
  };
};

export var EmbeddablePanel = /*#__PURE__*/function (_React$Component) {
  _inherits(EmbeddablePanel, _React$Component);

  var _super = _createSuper(EmbeddablePanel);

  function EmbeddablePanel(props) {
    var _this;

    _classCallCheck(this, EmbeddablePanel);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "embeddableRoot", void 0);

    _defineProperty(_assertThisInitialized(_this), "parentSubscription", void 0);

    _defineProperty(_assertThisInitialized(_this), "subscription", new Subscription());

    _defineProperty(_assertThisInitialized(_this), "mounted", false);

    _defineProperty(_assertThisInitialized(_this), "generateId", htmlIdGenerator());

    _defineProperty(_assertThisInitialized(_this), "onFocus", function (focusedPanelIndex) {
      _this.setState({
        focusedPanelIndex: focusedPanelIndex
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onBlur", function (blurredPanelIndex) {
      if (_this.state.focusedPanelIndex === blurredPanelIndex) {
        _this.setState({
          focusedPanelIndex: undefined
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "closeMyContextMenuPanel", function () {
      if (_this.mounted) {
        _this.setState({
          closeContextMenu: true
        }, function () {
          if (_this.mounted) {
            _this.setState({
              closeContextMenu: false
            });
          }
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "getActionContextMenuPanel", /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2() {
      var regularActions, _this$props$embeddabl, disabledActions, removeDisabledActions, createGetUserData, extraActions, sortedActions;

      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return _this.props.getActions(CONTEXT_MENU_TRIGGER, {
                embeddable: _this.props.embeddable
              });

            case 2:
              regularActions = _context2.sent;
              _this$props$embeddabl = _this.props.embeddable.getInput(), disabledActions = _this$props$embeddabl.disabledActions;

              if (disabledActions) {
                removeDisabledActions = removeById(disabledActions);
                regularActions = regularActions.filter(removeDisabledActions);
              }

              createGetUserData = function createGetUserData(overlays) {
                return /*#__PURE__*/function () {
                  var _getUserData = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(context) {
                    return regeneratorRuntime.wrap(function _callee$(_context) {
                      while (1) {
                        switch (_context.prev = _context.next) {
                          case 0:
                            return _context.abrupt("return", new Promise(function (resolve) {
                              var session = overlays.openModal(toMountPoint( /*#__PURE__*/React.createElement(CustomizePanelModal, {
                                embeddable: context.embeddable,
                                updateTitle: function updateTitle(title) {
                                  session.close();
                                  resolve({
                                    title: title
                                  });
                                }
                              })), {
                                'data-test-subj': 'customizePanel'
                              });
                            }));

                          case 1:
                          case "end":
                            return _context.stop();
                        }
                      }
                    }, _callee);
                  }));

                  function getUserData(_x) {
                    return _getUserData.apply(this, arguments);
                  }

                  return getUserData;
                }();
              }; // These actions are exposed on the context menu for every embeddable, they bypass the trigger
              // registry.


              extraActions = [new CustomizePanelTitleAction(createGetUserData(_this.props.overlays)), new AddPanelAction(_this.props.getEmbeddableFactory, _this.props.getAllEmbeddableFactories, _this.props.overlays, _this.props.notifications, _this.props.SavedObjectFinder), new InspectPanelAction(_this.props.inspector), new RemovePanelAction(), new EditPanelAction(_this.props.getEmbeddableFactory, _this.props.application, _this.props.stateTransfer)];
              sortedActions = [].concat(_toConsumableArray(regularActions), extraActions).sort(sortByOrderField);
              _context2.next = 10;
              return buildContextMenuForActions({
                actions: sortedActions,
                actionContext: {
                  embeddable: _this.props.embeddable
                },
                closeMenu: _this.closeMyContextMenuPanel
              });

            case 10:
              return _context2.abrupt("return", _context2.sent);

            case 11:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));

    var embeddable = _this.props.embeddable;
    var viewMode = embeddable.getInput().viewMode ? embeddable.getInput().viewMode : ViewMode.EDIT;
    var hidePanelTitles = embeddable.parent ? Boolean(embeddable.parent.getInput().hidePanelTitles) : false;
    _this.state = {
      panels: [],
      viewMode: viewMode,
      hidePanelTitles: hidePanelTitles,
      closeContextMenu: false,
      badges: [],
      notifications: []
    };
    _this.embeddableRoot = /*#__PURE__*/React.createRef();
    return _this;
  }

  _createClass(EmbeddablePanel, [{
    key: "refreshBadges",
    value: function () {
      var _refreshBadges = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        var badges, _this$props$embeddabl2, disabledActions;

        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return this.props.getActions(PANEL_BADGE_TRIGGER, {
                  embeddable: this.props.embeddable
                });

              case 2:
                badges = _context3.sent;

                if (this.mounted) {
                  _context3.next = 5;
                  break;
                }

                return _context3.abrupt("return");

              case 5:
                _this$props$embeddabl2 = this.props.embeddable.getInput(), disabledActions = _this$props$embeddabl2.disabledActions;

                if (disabledActions) {
                  badges = badges.filter(function (badge) {
                    return disabledActions.indexOf(badge.id) === -1;
                  });
                }

                this.setState({
                  badges: badges
                });

              case 8:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function refreshBadges() {
        return _refreshBadges.apply(this, arguments);
      }

      return refreshBadges;
    }()
  }, {
    key: "refreshNotifications",
    value: function () {
      var _refreshNotifications = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4() {
        var notifications, _this$props$embeddabl3, disabledActions;

        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                _context4.next = 2;
                return this.props.getActions(PANEL_NOTIFICATION_TRIGGER, {
                  embeddable: this.props.embeddable
                });

              case 2:
                notifications = _context4.sent;

                if (this.mounted) {
                  _context4.next = 5;
                  break;
                }

                return _context4.abrupt("return");

              case 5:
                _this$props$embeddabl3 = this.props.embeddable.getInput(), disabledActions = _this$props$embeddabl3.disabledActions;

                if (disabledActions) {
                  notifications = notifications.filter(function (badge) {
                    return disabledActions.indexOf(badge.id) === -1;
                  });
                }

                this.setState({
                  notifications: notifications
                });

              case 8:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function refreshNotifications() {
        return _refreshNotifications.apply(this, arguments);
      }

      return refreshNotifications;
    }()
  }, {
    key: "UNSAFE_componentWillMount",
    value: function UNSAFE_componentWillMount() {
      var _this2 = this;

      this.mounted = true;
      var embeddable = this.props.embeddable;
      var parent = embeddable.parent;
      this.subscription.add(embeddable.getInput$().subscribe( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5() {
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                if (_this2.mounted) {
                  _this2.setState({
                    viewMode: embeddable.getInput().viewMode ? embeddable.getInput().viewMode : ViewMode.EDIT
                  });

                  _this2.refreshBadges();

                  _this2.refreshNotifications();
                }

              case 1:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5);
      }))));

      if (parent) {
        this.parentSubscription = parent.getInput$().subscribe( /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee6() {
          return regeneratorRuntime.wrap(function _callee6$(_context6) {
            while (1) {
              switch (_context6.prev = _context6.next) {
                case 0:
                  if (_this2.mounted && parent) {
                    _this2.setState({
                      hidePanelTitles: Boolean(parent.getInput().hidePanelTitles)
                    });

                    _this2.refreshBadges();

                    _this2.refreshNotifications();
                  }

                case 1:
                case "end":
                  return _context6.stop();
              }
            }
          }, _callee6);
        })));
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.mounted = false;
      this.subscription.unsubscribe();

      if (this.parentSubscription) {
        this.parentSubscription.unsubscribe();
      }

      this.props.embeddable.destroy();
    }
  }, {
    key: "render",
    value: function render() {
      var viewOnlyMode = this.state.viewMode === ViewMode.VIEW;
      var classes = classNames('embPanel', {
        'embPanel--editing': !viewOnlyMode,
        'embPanel--loading': this.state.loading
      });
      var contentAttrs = {};
      if (this.state.loading) contentAttrs['data-loading'] = true;
      if (this.state.error) contentAttrs['data-error'] = true;
      var title = this.props.embeddable.getTitle();
      var headerId = this.generateId();
      return /*#__PURE__*/React.createElement(EuiPanel, {
        className: classes,
        "data-test-subj": "embeddablePanel",
        paddingSize: "none",
        role: "figure",
        "aria-labelledby": headerId
      }, !this.props.hideHeader && /*#__PURE__*/React.createElement(PanelHeader, {
        getActionContextMenuPanel: this.getActionContextMenuPanel,
        hidePanelTitles: this.state.hidePanelTitles,
        isViewMode: viewOnlyMode,
        closeContextMenu: this.state.closeContextMenu,
        title: title,
        badges: this.state.badges,
        notifications: this.state.notifications,
        embeddable: this.props.embeddable,
        headerId: headerId
      }), /*#__PURE__*/React.createElement(EmbeddableErrorLabel, {
        error: this.state.error
      }), /*#__PURE__*/React.createElement("div", _extends({
        className: "embPanel__content",
        ref: this.embeddableRoot
      }, contentAttrs)));
    }
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      var _this3 = this;

      if (this.embeddableRoot.current) {
        this.subscription.add(this.props.embeddable.getOutput$().subscribe(function (output) {
          _this3.setState({
            error: output.error,
            loading: output.loading
          });
        }));
        this.props.embeddable.render(this.embeddableRoot.current);
      }
    }
  }]);

  return EmbeddablePanel;
}(React.Component);