function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import { first } from 'rxjs/operators';
import { EnvironmentService, FeatureCatalogueRegistry, TutorialService } from './services';
import { setServices } from './application/kibana_services';
import { AppNavLinkStatus } from '../../../core/public';
export var HomePublicPlugin = /*#__PURE__*/function () {
  function HomePublicPlugin(initializerContext) {
    _classCallCheck(this, HomePublicPlugin);

    this.initializerContext = initializerContext;

    _defineProperty(this, "featuresCatalogueRegistry", new FeatureCatalogueRegistry());

    _defineProperty(this, "environmentService", new EnvironmentService());

    _defineProperty(this, "tutorialService", new TutorialService());
  }

  _createClass(HomePublicPlugin, [{
    key: "setup",
    value: function setup(core, _ref) {
      var _this = this;

      var kibanaLegacy = _ref.kibanaLegacy,
          usageCollection = _ref.usageCollection;
      core.application.register({
        id: 'home',
        title: 'Home',
        navLinkStatus: AppNavLinkStatus.hidden,
        mount: function () {
          var _mount = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(params) {
            var trackUiMetric, _yield$core$getStartS, _yield$core$getStartS2, coreStart, _yield$core$getStartS3, telemetry, data, kibanaLegacyStart, _yield$import, renderApp;

            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    trackUiMetric = usageCollection ? usageCollection.reportUiStats.bind(usageCollection, 'Kibana_home') : function () {};
                    _context.next = 3;
                    return core.getStartServices();

                  case 3:
                    _yield$core$getStartS = _context.sent;
                    _yield$core$getStartS2 = _slicedToArray(_yield$core$getStartS, 2);
                    coreStart = _yield$core$getStartS2[0];
                    _yield$core$getStartS3 = _yield$core$getStartS2[1];
                    telemetry = _yield$core$getStartS3.telemetry;
                    data = _yield$core$getStartS3.data;
                    kibanaLegacyStart = _yield$core$getStartS3.kibanaLegacy;
                    setServices({
                      trackUiMetric: trackUiMetric,
                      kibanaVersion: _this.initializerContext.env.packageInfo.version,
                      http: coreStart.http,
                      toastNotifications: core.notifications.toasts,
                      banners: coreStart.overlays.banners,
                      docLinks: coreStart.docLinks,
                      savedObjectsClient: coreStart.savedObjects.client,
                      chrome: coreStart.chrome,
                      application: coreStart.application,
                      telemetry: telemetry,
                      uiSettings: core.uiSettings,
                      addBasePath: core.http.basePath.prepend,
                      getBasePath: core.http.basePath.get,
                      indexPatternService: data.indexPatterns,
                      environmentService: _this.environmentService,
                      kibanaLegacy: kibanaLegacyStart,
                      homeConfig: _this.initializerContext.config.get(),
                      tutorialService: _this.tutorialService,
                      featureCatalogue: _this.featuresCatalogueRegistry
                    });
                    coreStart.chrome.docTitle.change(i18n.translate('home.pageTitle', {
                      defaultMessage: 'Home'
                    }));
                    _context.next = 14;
                    return import('./application');

                  case 14:
                    _yield$import = _context.sent;
                    renderApp = _yield$import.renderApp;
                    _context.next = 18;
                    return renderApp(params.element, coreStart, params.history);

                  case 18:
                    return _context.abrupt("return", _context.sent);

                  case 19:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          function mount(_x) {
            return _mount.apply(this, arguments);
          }

          return mount;
        }()
      });
      kibanaLegacy.forwardApp('home', 'home');
      return {
        featureCatalogue: _objectSpread({}, this.featuresCatalogueRegistry.setup()),
        environment: _objectSpread({}, this.environmentService.setup()),
        tutorials: _objectSpread({}, this.tutorialService.setup())
      };
    }
  }, {
    key: "start",
    value: function start(_ref2, _ref3) {
      var _ref2$application = _ref2.application,
          capabilities = _ref2$application.capabilities,
          currentAppId$ = _ref2$application.currentAppId$,
          http = _ref2.http;
      var kibanaLegacy = _ref3.kibanaLegacy;
      this.featuresCatalogueRegistry.start({
        capabilities: capabilities
      }); // If the home app is the initial location when loading Kibana...

      if (window.location.pathname === http.basePath.prepend("/app/home") && window.location.hash === '') {
        // ...wait for the app to mount initially and then...
        currentAppId$.pipe(first()).subscribe(function (appId) {
          if (appId === 'home') {
            // ...navigate to default app set by `kibana.defaultAppId`.
            // This doesn't do anything as along as the default settings are kept.
            kibanaLegacy.navigateToDefaultApp({
              overwriteHash: false
            });
          }
        });
      }
    }
  }]);

  return HomePublicPlugin;
}();
/** @public */