/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import { EuiFlexGroup, EuiToolTip, EuiFlexItem, EuiIcon, EuiTitle, EuiButtonIcon } from '@elastic/eui';
var setDefaultAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.setDefaultAria', {
  defaultMessage: 'Set as default index.'
});
var setDefaultTooltip = i18n.translate('indexPatternManagement.editIndexPattern.setDefaultTooltip', {
  defaultMessage: 'Set as default index.'
});
var refreshAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.refreshAria', {
  defaultMessage: 'Reload field list.'
});
var refreshTooltip = i18n.translate('indexPatternManagement.editIndexPattern.refreshTooltip', {
  defaultMessage: 'Refresh field list.'
});
var removeAriaLabel = i18n.translate('indexPatternManagement.editIndexPattern.removeAria', {
  defaultMessage: 'Remove index pattern.'
});
var removeTooltip = i18n.translate('indexPatternManagement.editIndexPattern.removeTooltip', {
  defaultMessage: 'Remove index pattern.'
});
export function IndexHeader(_ref) {
  var defaultIndex = _ref.defaultIndex,
      indexPattern = _ref.indexPattern,
      setDefault = _ref.setDefault,
      refreshFields = _ref.refreshFields,
      deleteIndexPatternClick = _ref.deleteIndexPatternClick;
  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    alignItems: "center"
  }, defaultIndex === indexPattern.id && /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false,
    style: {
      marginRight: 0
    }
  }, /*#__PURE__*/React.createElement(EuiIcon, {
    size: "xl",
    type: "starFilled"
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    style: defaultIndex === indexPattern.id ? {
      marginLeft: 0
    } : {}
  }, /*#__PURE__*/React.createElement(EuiTitle, null, /*#__PURE__*/React.createElement("h1", {
    "data-test-subj": "indexPatternTitle"
  }, indexPattern.title))))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, null, setDefault && /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: setDefaultTooltip
  }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    color: "text",
    onClick: setDefault,
    iconType: "starFilled",
    "aria-label": setDefaultAriaLabel,
    "data-test-subj": "setDefaultIndexPatternButton"
  }))), refreshFields && /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: refreshTooltip
  }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    color: "text",
    onClick: refreshFields,
    iconType: "refresh",
    "aria-label": refreshAriaLabel,
    "data-test-subj": "refreshFieldsIndexPatternButton"
  }))), deleteIndexPatternClick && /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiToolTip, {
    content: removeTooltip
  }, /*#__PURE__*/React.createElement(EuiButtonIcon, {
    color: "danger",
    onClick: deleteIndexPatternClick,
    iconType: "trash",
    "aria-label": removeAriaLabel,
    "data-test-subj": "deleteIndexPatternButton"
  }))))));
}