function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent, Fragment } from 'react';
import { EuiSearchBar, EuiBasicTable, EuiButton, EuiIcon, EuiLink, EuiSpacer, EuiToolTip, EuiFormErrorText, EuiPopover, EuiSwitch, EuiFormRow, EuiText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { getDefaultTitle, getSavedObjectLabel } from '../../../lib';
export var Table = /*#__PURE__*/function (_PureComponent) {
  _inherits(Table, _PureComponent);

  var _super = _createSuper(Table);

  function Table(props) {
    var _this;

    _classCallCheck(this, Table);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "state", {
      isSearchTextValid: true,
      parseErrorMessage: null,
      isExportPopoverOpen: false,
      isIncludeReferencesDeepChecked: true,
      activeAction: undefined
    });

    _defineProperty(_assertThisInitialized(_this), "onChange", function (_ref) {
      var query = _ref.query,
          error = _ref.error;

      if (error) {
        _this.setState({
          isSearchTextValid: false,
          parseErrorMessage: error.message
        });

        return;
      }

      _this.setState({
        isSearchTextValid: true,
        parseErrorMessage: null
      });

      _this.props.onQueryChange({
        query: query
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeExportPopover", function () {
      _this.setState({
        isExportPopoverOpen: false
      });
    });

    _defineProperty(_assertThisInitialized(_this), "toggleExportPopoverVisibility", function () {
      _this.setState(function (state) {
        return {
          isExportPopoverOpen: !state.isExportPopoverOpen
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "toggleIsIncludeReferencesDeepChecked", function () {
      _this.setState(function (state) {
        return {
          isIncludeReferencesDeepChecked: !state.isIncludeReferencesDeepChecked
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onExportClick", function () {
      var onExport = _this.props.onExport;
      var isIncludeReferencesDeepChecked = _this.state.isIncludeReferencesDeepChecked;
      onExport(isIncludeReferencesDeepChecked);

      _this.setState({
        isExportPopoverOpen: false
      });
    });

    return _this;
  }

  _createClass(Table, [{
    key: "render",
    value: function render() {
      var _this2 = this,
          _this$state$activeAct,
          _this$state$activeAct2;

      var _this$props = this.props,
          pageIndex = _this$props.pageIndex,
          pageSize = _this$props.pageSize,
          itemId = _this$props.itemId,
          items = _this$props.items,
          totalItemCount = _this$props.totalItemCount,
          isSearching = _this$props.isSearching,
          filterOptions = _this$props.filterOptions,
          selection = _this$props.selectionConfig,
          onDelete = _this$props.onDelete,
          selectedSavedObjects = _this$props.selectedSavedObjects,
          onTableChange = _this$props.onTableChange,
          goInspectObject = _this$props.goInspectObject,
          onShowRelationships = _this$props.onShowRelationships,
          basePath = _this$props.basePath,
          actionRegistry = _this$props.actionRegistry;
      var pagination = {
        pageIndex: pageIndex,
        pageSize: pageSize,
        totalItemCount: totalItemCount,
        pageSizeOptions: [5, 10, 20, 50]
      };
      var filters = [{
        type: 'field_value_selection',
        field: 'type',
        name: i18n.translate('savedObjectsManagement.objectsTable.table.typeFilterName', {
          defaultMessage: 'Type'
        }),
        multiSelect: 'or',
        options: filterOptions
      } // Add this back in once we have tag support
      // {
      //   type: 'field_value_selection',
      //   field: 'tag',
      //   name: 'Tags',
      //   multiSelect: 'or',
      //   options: [],
      // },
      ];
      var columns = [{
        field: 'type',
        name: i18n.translate('savedObjectsManagement.objectsTable.table.columnTypeName', {
          defaultMessage: 'Type'
        }),
        width: '50px',
        align: 'center',
        description: i18n.translate('savedObjectsManagement.objectsTable.table.columnTypeDescription', {
          defaultMessage: 'Type of the saved object'
        }),
        sortable: false,
        'data-test-subj': 'savedObjectsTableRowType',
        render: function render(type, object) {
          return /*#__PURE__*/React.createElement(EuiToolTip, {
            position: "top",
            content: getSavedObjectLabel(type)
          }, /*#__PURE__*/React.createElement(EuiIcon, {
            "aria-label": getSavedObjectLabel(type),
            type: object.meta.icon || 'apps',
            size: "s",
            "data-test-subj": "objectType"
          }));
        }
      }, {
        field: 'meta.title',
        name: i18n.translate('savedObjectsManagement.objectsTable.table.columnTitleName', {
          defaultMessage: 'Title'
        }),
        description: i18n.translate('savedObjectsManagement.objectsTable.table.columnTitleDescription', {
          defaultMessage: 'Title of the saved object'
        }),
        dataType: 'string',
        sortable: false,
        'data-test-subj': 'savedObjectsTableRowTitle',
        render: function render(title, object) {
          var _ref2 = object.meta.inAppUrl || {},
              _ref2$path = _ref2.path,
              path = _ref2$path === void 0 ? '' : _ref2$path;

          var canGoInApp = _this2.props.canGoInApp(object);

          if (!canGoInApp) {
            return /*#__PURE__*/React.createElement(EuiText, {
              size: "s"
            }, title || getDefaultTitle(object));
          }

          return /*#__PURE__*/React.createElement(EuiLink, {
            href: basePath.prepend(path)
          }, title || getDefaultTitle(object));
        }
      }, {
        name: i18n.translate('savedObjectsManagement.objectsTable.table.columnActionsName', {
          defaultMessage: 'Actions'
        }),
        actions: [{
          name: i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.inspectActionName', {
            defaultMessage: 'Inspect'
          }),
          description: i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.inspectActionDescription', {
            defaultMessage: 'Inspect this saved object'
          }),
          type: 'icon',
          icon: 'inspect',
          onClick: function onClick(object) {
            return goInspectObject(object);
          },
          available: function available(object) {
            return !!object.meta.editUrl;
          },
          'data-test-subj': 'savedObjectsTableAction-inspect'
        }, {
          name: i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.viewRelationshipsActionName', {
            defaultMessage: 'Relationships'
          }),
          description: i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.viewRelationshipsActionDescription', {
            defaultMessage: 'View the relationships this saved object has to other saved objects'
          }),
          type: 'icon',
          icon: 'kqlSelector',
          onClick: function onClick(object) {
            return onShowRelationships(object);
          },
          'data-test-subj': 'savedObjectsTableAction-relationships'
        }].concat(_toConsumableArray(actionRegistry.getAll().map(function (action) {
          return _objectSpread(_objectSpread({}, action.euiAction), {}, {
            'data-test-subj': "savedObjectsTableAction-".concat(action.id),
            onClick: function onClick(object) {
              _this2.setState({
                activeAction: action
              });

              action.registerOnFinishCallback(function () {
                _this2.setState({
                  activeAction: undefined
                });
              });

              if (action.euiAction.onClick) {
                action.euiAction.onClick(object);
              }
            }
          });
        })))
      }];
      var queryParseError;

      if (!this.state.isSearchTextValid) {
        var parseErrorMsg = i18n.translate('savedObjectsManagement.objectsTable.searchBar.unableToParseQueryErrorMessage', {
          defaultMessage: 'Unable to parse query'
        });
        queryParseError = /*#__PURE__*/React.createElement(EuiFormErrorText, null, "".concat(parseErrorMsg, ". ").concat(this.state.parseErrorMessage));
      }

      var button = /*#__PURE__*/React.createElement(EuiButton, {
        iconType: "arrowDown",
        iconSide: "right",
        onClick: this.toggleExportPopoverVisibility,
        isDisabled: selectedSavedObjects.length === 0
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.table.exportPopoverButtonLabel",
        defaultMessage: "Export"
      }));
      var activeActionContents = (_this$state$activeAct = (_this$state$activeAct2 = this.state.activeAction) === null || _this$state$activeAct2 === void 0 ? void 0 : _this$state$activeAct2.render()) !== null && _this$state$activeAct !== void 0 ? _this$state$activeAct : null;
      return /*#__PURE__*/React.createElement(Fragment, null, activeActionContents, /*#__PURE__*/React.createElement(EuiSearchBar, {
        box: {
          'data-test-subj': 'savedObjectSearchBar'
        },
        filters: filters,
        onChange: this.onChange,
        toolsRight: [/*#__PURE__*/React.createElement(EuiButton, {
          key: "deleteSO",
          iconType: "trash",
          color: "danger",
          onClick: onDelete,
          isDisabled: selectedSavedObjects.length === 0 || !this.props.canDelete,
          title: this.props.canDelete ? undefined : i18n.translate('savedObjectsManagement.objectsTable.table.deleteButtonTitle', {
            defaultMessage: 'Unable to delete saved objects'
          }),
          "data-test-subj": "savedObjectsManagementDelete"
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.table.deleteButtonLabel",
          defaultMessage: "Delete"
        })), /*#__PURE__*/React.createElement(EuiPopover, {
          key: "exportSOOptions",
          button: button,
          isOpen: this.state.isExportPopoverOpen,
          closePopover: this.closeExportPopover
        }, /*#__PURE__*/React.createElement(EuiFormRow, {
          label: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.exportOptionsLabel",
            defaultMessage: "Options"
          })
        }, /*#__PURE__*/React.createElement(EuiSwitch, {
          name: "includeReferencesDeep",
          label: /*#__PURE__*/React.createElement(FormattedMessage, {
            id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.includeReferencesDeepLabel",
            defaultMessage: "Include related objects"
          }),
          checked: this.state.isIncludeReferencesDeepChecked,
          onChange: this.toggleIsIncludeReferencesDeepChecked
        })), /*#__PURE__*/React.createElement(EuiFormRow, null, /*#__PURE__*/React.createElement(EuiButton, {
          key: "exportSO",
          iconType: "exportAction",
          onClick: this.onExportClick,
          fill: true
        }, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.table.exportButtonLabel",
          defaultMessage: "Export"
        }))))]
      }), queryParseError, /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement("div", {
        "data-test-subj": "savedObjectsTable"
      }, /*#__PURE__*/React.createElement(EuiBasicTable, {
        loading: isSearching,
        itemId: itemId,
        items: items,
        columns: columns,
        pagination: pagination,
        selection: selection,
        onChange: onTableChange,
        rowProps: function rowProps(item) {
          return {
            'data-test-subj': "savedObjectsTableRow row-".concat(item.id)
          };
        }
      })));
    }
  }]);

  return Table;
}(PureComponent);