function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, useState, useEffect, useMemo, useCallback } from 'react';
import { EuiSpacer, EuiButtonEmpty, EuiFlexItem, EuiFormErrorText } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { NumberRow } from './number_row';
import { parse, EMPTY_STRING, getRange, getNextModel, getInitModelList, getValidatedModels, hasInvalidValues } from './utils';
import { useValidation } from '../../utils';

function NumberList(_ref) {
  var labelledbyId = _ref.labelledbyId,
      numberArray = _ref.numberArray,
      range = _ref.range,
      showValidation = _ref.showValidation,
      unitName = _ref.unitName,
      _ref$validateAscendin = _ref.validateAscendingOrder,
      validateAscendingOrder = _ref$validateAscendin === void 0 ? false : _ref$validateAscendin,
      _ref$disallowDuplicat = _ref.disallowDuplicates,
      disallowDuplicates = _ref$disallowDuplicat === void 0 ? false : _ref$disallowDuplicat,
      onChange = _ref.onChange,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity;
  var numberRange = useMemo(function () {
    return getRange(range);
  }, [range]);

  var _useState = useState(getInitModelList(numberArray)),
      _useState2 = _slicedToArray(_useState, 2),
      models = _useState2[0],
      setModels = _useState2[1]; // set up validity for each model


  useEffect(function () {
    setModels(function (state) {
      return getValidatedModels(numberArray, state, numberRange, validateAscendingOrder, disallowDuplicates);
    });
  }, [numberArray, numberRange, validateAscendingOrder, disallowDuplicates]); // responsible for setting up an initial value ([0]) when there is no default value

  useEffect(function () {
    if (!numberArray.length) {
      onChange([models[0].value]);
    }
  }, [models, numberArray.length, onChange]);
  var isValid = !hasInvalidValues(models);
  useValidation(setValidity, isValid);
  var onUpdate = useCallback(function (modelList) {
    setModels(modelList);
    onChange(modelList.map(function (_ref2) {
      var value = _ref2.value;
      return value === EMPTY_STRING ? undefined : value;
    }));
  }, [onChange]);
  var onChangeValue = useCallback(function (_ref3) {
    var id = _ref3.id,
        value = _ref3.value;
    var parsedValue = parse(value);
    onUpdate(models.map(function (model) {
      if (model.id === id) {
        return {
          id: id,
          value: parsedValue,
          isInvalid: false
        };
      }

      return model;
    }));
  }, [models, onUpdate]); // Add an item to the end of the list

  var onAdd = useCallback(function () {
    var newArray = [].concat(_toConsumableArray(models), [getNextModel(models, numberRange)]);
    onUpdate(newArray);
  }, [models, numberRange, onUpdate]);
  var onDelete = useCallback(function (id) {
    var newArray = models.filter(function (model) {
      return model.id !== id;
    });
    onUpdate(newArray);
  }, [models, onUpdate]);
  return /*#__PURE__*/React.createElement(React.Fragment, null, models.map(function (model, arrayIndex) {
    return /*#__PURE__*/React.createElement(Fragment, {
      key: model.id
    }, /*#__PURE__*/React.createElement(NumberRow, {
      isInvalid: showValidation ? model.isInvalid : false,
      disableDelete: models.length === 1,
      model: model,
      labelledbyId: labelledbyId,
      range: numberRange,
      onDelete: onDelete,
      onChange: onChangeValue,
      onBlur: setTouched,
      autoFocus: models.length !== 1 && arrayIndex === models.length - 1
    }), showValidation && model.isInvalid && model.error && /*#__PURE__*/React.createElement(EuiFormErrorText, null, model.error), models.length - 1 !== arrayIndex && /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "s"
    }));
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiButtonEmpty, {
    iconType: "plusInCircleFilled",
    onClick: onAdd,
    size: "xs"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.numberList.addUnitButtonLabel",
    defaultMessage: "Add {unitName}",
    values: {
      unitName: unitName
    }
  }))));
}

export { NumberList };