function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import { SwitchParamEditor } from './switch';

function IsFilteredByCollarParamEditor(props) {
  return /*#__PURE__*/React.createElement(SwitchParamEditor, _extends({
    displayLabel: i18n.translate('visDefaultEditor.controls.onlyRequestDataAroundMapExtentLabel', {
      defaultMessage: 'Only request data around map extent'
    }),
    displayToolTip: i18n.translate('visDefaultEditor.controls.onlyRequestDataAroundMapExtentTooltip', {
      defaultMessage: 'Apply geo_bounding_box filter aggregation to narrow the subject area to the map view box with collar'
    }),
    dataTestSubj: "isFilteredByCollarCheckbox"
  }, props));
}

export { IsFilteredByCollarParamEditor };