/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo, useCallback } from 'react';
import { EuiFormRow, EuiSelect } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { useAvailableOptions, useFallbackMetric, useValidation } from './utils';
var aggFilter = ['!top_hits', '!percentiles', '!percentile_ranks', '!median', '!std_dev'];
var EMPTY_VALUE = 'EMPTY_VALUE';
var DEFAULT_OPTIONS = [{
  text: '',
  value: EMPTY_VALUE,
  hidden: true
}];

function MetricAggParamEditor(_ref) {
  var agg = _ref.agg,
      value = _ref.value,
      showValidation = _ref.showValidation,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched,
      _ref$metricAggs = _ref.metricAggs,
      metricAggs = _ref$metricAggs === void 0 ? [] : _ref$metricAggs;
  var label = i18n.translate('visDefaultEditor.controls.metricLabel', {
    defaultMessage: 'Metric'
  });
  var isValid = !!value;
  useValidation(setValidity, isValid);
  useFallbackMetric(setValue, aggFilter, metricAggs, value);
  var filteredMetrics = useMemo(function () {
    return metricAggs.filter(function (respAgg) {
      return respAgg.type.name !== agg.type.name;
    });
  }, [metricAggs, agg.type.name]);
  var options = useAvailableOptions(aggFilter, filteredMetrics, DEFAULT_OPTIONS);
  var onChange = useCallback(function (ev) {
    return setValue(ev.target.value);
  }, [setValue]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiSelect, {
    compressed: true,
    fullWidth: true,
    options: options,
    value: value || EMPTY_VALUE,
    onChange: onChange,
    isInvalid: showValidation && !isValid,
    onBlur: setTouched,
    "data-test-subj": "visEditorSubAggMetric".concat(agg.id)
  }));
}

export { DEFAULT_OPTIONS, aggFilter, MetricAggParamEditor };