function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { i18n } from '@kbn/i18n';
import { FieldParamEditor } from './field';
import { getCompatibleAggs } from './top_aggregate';

function TopFieldParamEditor(props) {
  var compatibleAggs = getCompatibleAggs(props.agg);
  var customError;

  if (props.value && !compatibleAggs.length) {
    customError = i18n.translate('visDefaultEditor.controls.aggregateWith.noAggsErrorTooltip', {
      defaultMessage: 'The chosen field has no compatible aggregations.'
    });
  }

  return /*#__PURE__*/React.createElement(FieldParamEditor, _extends({}, props, {
    customError: customError
  }));
}

export { TopFieldParamEditor };