function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { last } from 'lodash';
import { EuiFlexGroup } from '@elastic/eui';
import { MultiValueRow } from './multi_value_row';
export var PercentileRankValues = function PercentileRankValues(props) {
  var model = props.model || [];
  var onChange = props.onChange,
      disableAdd = props.disableAdd,
      disableDelete = props.disableDelete,
      showOnlyLastRow = props.showOnlyLastRow;

  var onChangeValue = function onChangeValue(_ref) {
    var value = _ref.value,
        id = _ref.id;
    model[id] = value;
    onChange(model);
  };

  var onDeleteValue = function onDeleteValue(_ref2) {
    var id = _ref2.id;
    return onChange(model.filter(function (item, currentIndex) {
      return id !== currentIndex;
    }));
  };

  var onAddValue = function onAddValue() {
    return onChange([].concat(_toConsumableArray(model), ['']));
  };

  var renderRow = function renderRow(_ref3) {
    var rowModel = _ref3.rowModel,
        disableDeleteRow = _ref3.disableDeleteRow,
        disableAddRow = _ref3.disableAddRow;
    return /*#__PURE__*/React.createElement(MultiValueRow, {
      key: "percentileRankValue__item".concat(rowModel.id),
      onAdd: onAddValue,
      onChange: onChangeValue,
      onDelete: onDeleteValue,
      disableDelete: disableDeleteRow,
      disableAdd: disableAddRow,
      model: rowModel
    });
  };

  return /*#__PURE__*/React.createElement(EuiFlexGroup, {
    direction: "column",
    responsive: false,
    gutterSize: "xs"
  }, showOnlyLastRow && renderRow({
    rowModel: {
      id: model.length - 1,
      value: last(model) || ''
    },
    disableAddRow: true,
    disableDeleteRow: true
  }), !showOnlyLastRow && model.map(function (value, id, array) {
    return renderRow({
      rowModel: {
        id: id,
        value: value || ''
      },
      disableAddRow: disableAdd,
      disableDeleteRow: disableDelete || array.length < 2
    });
  }));
};