function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import { i18n } from '@kbn/i18n';
// @ts-ignore
import { metricsRequestHandler } from './request_handler';
export var createMetricsFn = function createMetricsFn() {
  return {
    name: 'tsvb',
    type: 'render',
    inputTypes: ['kibana_context', 'null'],
    help: i18n.translate('visTypeTimeseries.function.help', {
      defaultMessage: 'TSVB visualization'
    }),
    args: {
      params: {
        types: ['string'],
        default: '"{}"',
        help: ''
      },
      uiState: {
        types: ['string'],
        default: '"{}"',
        help: ''
      },
      savedObjectId: {
        types: ['null', 'string'],
        default: null,
        help: ''
      }
    },
    fn: function fn(input, args) {
      return _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var params, uiStateParams, savedObjectId, _yield$import, PersistedState, uiState, response;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                params = JSON.parse(args.params);
                uiStateParams = JSON.parse(args.uiState);
                savedObjectId = args.savedObjectId;
                _context.next = 5;
                return import('../../visualizations/public');

              case 5:
                _yield$import = _context.sent;
                PersistedState = _yield$import.PersistedState;
                uiState = new PersistedState(uiStateParams);
                _context.next = 10;
                return metricsRequestHandler({
                  timeRange: get(input, 'timeRange', null),
                  query: get(input, 'query', null),
                  filters: get(input, 'filters', null),
                  visParams: params,
                  uiState: uiState,
                  savedObjectId: savedObjectId
                });

              case 10:
                response = _context.sent;
                response.visType = 'metrics';
                return _context.abrupt("return", {
                  type: 'render',
                  as: 'visualization',
                  value: {
                    uiState: uiState,
                    visType: 'metrics',
                    visConfig: params,
                    visData: response
                  }
                });

              case 13:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }))();
    }
  };
};