/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.options;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Collection;
import javax.swing.UIManager;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.MercurialAnnotator;
import org.netbeans.modules.mercurial.MercurialVCS;
import org.netbeans.modules.versioning.util.OptionsPanelColorProvider;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AnnotationColorProvider
extends OptionsPanelColorProvider {
    private static String name;
    private static AnnotationColorProvider INSTANCE;
    private static final Color ADDED_COLOR;
    private static final Color MODIFIED_COLOR;
    private static final Color DELETED_COLOR;
    private static final Color CONFLICTED_COLOR;
    private static final Color IGNORED_COLOR;
    private static final Color TEXT_ANNOTATION_COLOR;
    public final OptionsPanelColorProvider.AnnotationFormat UP_TO_DATE_FILE = this.createAnnotationFormat("uptodate", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_UpToDate"), null, false);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_LOCALLY_FILE = this.createAnnotationFormat("newLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_NewLocally"), ADDED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat NEW_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("newLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_NewLocally"), ADDED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat ADDED_LOCALLY_FILE = this.createAnnotationFormat("addedLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_AddedLocally"), ADDED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat ADDED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("addedLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_AddedLocally"), ADDED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat COPIED_LOCALLY_FILE = this.createAnnotationFormat("copiedLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_AddedLocallyCopied"), ADDED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat COPIED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("copiedLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_AddedLocallyCopied"), ADDED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat MOVED_LOCALY_FILE = this.createAnnotationFormat("movedLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_AddedLocallyMoved"), ADDED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat MOVED_LOCALY_FILE_TOOLTIP = this.createAnnotationFormat("movedLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_AddedLocallyMoved"), ADDED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_LOCALLY_FILE = this.createAnnotationFormat("modifiedLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_ModifiedLocally"), MODIFIED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat MODIFIED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("modifiedLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_ModifiedLocally"), MODIFIED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_LOCALLY_FILE = this.createAnnotationFormat("removedLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_RemovedLocally"), DELETED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat REMOVED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("removedLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_RemovedLocally"), DELETED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat DELETED_LOCALLY_FILE = this.createAnnotationFormat("deletedLocally", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_DeletedLocally"), DELETED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat DELETED_LOCALLY_FILE_TOOLTIP = this.createAnnotationFormat("deletedLocallyTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_DeletedLocally"), DELETED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat EXCLUDED_FILE = this.createAnnotationFormat("excluded", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_Excluded"), IGNORED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat EXCLUDED_FILE_TOOLTIP = this.createAnnotationFormat("excludedTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_Excluded"), IGNORED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat CONFLICT_FILE = this.createAnnotationFormat("conflict", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_Conflict"), CONFLICTED_COLOR, false);
    public final OptionsPanelColorProvider.AnnotationFormat CONFLICT_FILE_TOOLTIP = this.createAnnotationFormat("conflictTT", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_Conflict"), CONFLICTED_COLOR, true);
    public final OptionsPanelColorProvider.AnnotationFormat TEXT_ANNOTATION = this.createAnnotationFormat("textAnnotation", NbBundle.getMessage(MercurialAnnotator.class, (String)"CTL_FileInfoStatus_TextAnnotation"), TEXT_ANNOTATION_COLOR, true);

    public AnnotationColorProvider() {
        this.initColors();
    }

    public static synchronized AnnotationColorProvider getInstance() {
        if (INSTANCE == null && (INSTANCE = (AnnotationColorProvider)((Object)Lookup.getDefault().lookup(AnnotationColorProvider.class))) == null) {
            INSTANCE = new AnnotationColorProvider();
        }
        return INSTANCE;
    }

    public String getName() {
        if (name == null) {
            name = MercurialVCS.getDisplayName();
        }
        return name;
    }

    protected Color getSavedColor(String key, Color defaultColor) {
        return HgModuleConfig.getDefault().getColor(key, defaultColor);
    }

    protected MessageFormat createFormat(Color color, boolean isTooltip) {
        StringBuilder annotationFormatString = new StringBuilder("{0}");
        if (color != null) {
            annotationFormatString = new StringBuilder("<font color=\"#").append(AnnotationColorProvider.to2Hex((int)color.getRed())).append(AnnotationColorProvider.to2Hex((int)color.getGreen())).append(AnnotationColorProvider.to2Hex((int)color.getBlue())).append("\"").append(">{0}</font>");
        }
        if (!isTooltip) {
            annotationFormatString.append("{1}");
        }
        return new MessageFormat(annotationFormatString.toString());
    }

    protected void saveColors(Collection<OptionsPanelColorProvider.AnnotationFormat> colors) {
        for (OptionsPanelColorProvider.AnnotationFormat af : colors) {
            if (af == null) continue;
            HgModuleConfig.getDefault().setColor(AnnotationColorProvider.getColorKey((String)af.getKey()), af.getActualColor());
        }
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Mercurial.getInstance().refreshAllAnnotations();
            }
        });
    }

    private void initColors() {
        this.putColor(this.ADDED_LOCALLY_FILE);
        this.putColor(this.CONFLICT_FILE);
        this.putColor(this.COPIED_LOCALLY_FILE);
        this.putColor(this.MOVED_LOCALY_FILE);
        this.putColor(this.DELETED_LOCALLY_FILE);
        this.putColor(this.EXCLUDED_FILE);
        this.putColor(this.MODIFIED_LOCALLY_FILE);
        this.putColor(this.NEW_LOCALLY_FILE);
        this.putColor(this.REMOVED_LOCALLY_FILE);
        this.putColor(this.TEXT_ANNOTATION);
    }

    static {
        Color c = UIManager.getColor("nb.versioning.added.color");
        ADDED_COLOR = c == null ? new Color(0, 128, 0) : c;
        c = UIManager.getColor("nb.versioning.modified.color");
        MODIFIED_COLOR = c == null ? new Color(0, 0, 255) : c;
        c = UIManager.getColor("nb.versioning.deleted.color");
        DELETED_COLOR = c == null ? new Color(153, 153, 153) : c;
        c = UIManager.getColor("nb.versioning.conflicted.color");
        CONFLICTED_COLOR = c == null ? new Color(255, 0, 0) : c;
        c = UIManager.getColor("nb.versioning.ignored.color");
        IGNORED_COLOR = c == null ? new Color(153, 153, 153) : c;
        c = UIManager.getColor("nb.versioning.textannotation.color");
        TEXT_ANNOTATION_COLOR = c == null ? new Color(153, 153, 153) : c;
    }
}

