/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.utils.helper.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.net.URL;
import javax.swing.JDialog;
import org.netbeans.installer.utils.helper.swing.NbiFrame;
import org.netbeans.installer.utils.helper.swing.NbiPanel;

public class NbiDialog
extends JDialog {
    protected NbiFrame owner;
    protected int dialogWidth;
    protected int dialogHeight;
    protected URL dialogIcon;
    protected NbiDialogContentPane contentPane;
    public static final int DIALOG_FRAME_WIDTH_DELTA = 100;
    public static final int DIALOG_FRAME_HEIGHT_DELTA = 100;
    public static final int DEFAULT_DIALOG_WIDTH = 550;
    public static final int DEFAULT_DIALOG_HEIGHT = 500;
    public static final URL DEFAULT_DIALOG_ICON = NbiDialog.class.getClassLoader().getResource("org/netbeans/installer/wizard/wizard-icon.png");

    public NbiDialog() {
        this.initComponents();
    }

    public NbiDialog(NbiFrame owner) {
        super(owner);
        this.owner = owner;
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.contentPane = new NbiDialogContentPane();
        this.setContentPane(this.contentPane);
        this.setSize(550, 500);
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.owner == null) {
            GraphicsDevice screen = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
            GraphicsConfiguration config = screen.getDefaultConfiguration();
            int screenWidth = config.getBounds().width;
            int screenHeight = config.getBounds().height;
            this.setLocation((screenWidth - this.getSize().width) / 2, (screenHeight - this.getSize().height) / 2);
        } else {
            this.setLocation(this.owner.getLocation().x + 100, this.owner.getLocation().y + 100);
        }
        super.setVisible(visible);
    }

    public class NbiDialogContentPane
    extends NbiPanel {
        private Image backgroundImage;

        public NbiDialogContentPane() {
            if (NbiDialog.this.owner != null) {
                this.backgroundImage = NbiDialog.this.owner.getBackgroundImage();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2d = (Graphics2D)graphics;
            if (this.backgroundImage != null) {
                graphics2d.drawImage(this.backgroundImage, 0, 0, this);
                Composite oldComposite = graphics2d.getComposite();
                graphics2d.setComposite(AlphaComposite.getInstance(3, 0.85f));
                graphics2d.setColor(Color.WHITE);
                graphics2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2d.setComposite(oldComposite);
            }
        }
    }
}

