/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.custom.hints;

import java.util.Collection;
import java.util.Collections;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.html.custom.conf.Attribute;
import org.netbeans.modules.html.custom.conf.Configuration;
import org.netbeans.modules.html.custom.conf.Tag;
import org.netbeans.modules.html.custom.hints.Bundle;
import org.netbeans.modules.html.custom.hints.Utils;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;

public final class AddAttributeFix
implements HintFix {
    private final Collection<String> attributeNames;
    private final String elementContextName;
    private final Snapshot snapshot;

    public AddAttributeFix(Collection<String> attributeNames, String elementContextName, Snapshot snapshot) {
        this.attributeNames = attributeNames;
        this.elementContextName = elementContextName;
        this.snapshot = snapshot;
    }

    public AddAttributeFix(String attributeName, String elementContextName, Snapshot snapshot) {
        this(Collections.singleton(attributeName), elementContextName, snapshot);
    }

    public String getDescription() {
        String attrNamesList = Utils.attributeNames2String(this.attributeNames);
        if (this.elementContextName == null) {
            return this.attributeNames.size() == 1 ? Bundle.declareGlobalAttr(attrNamesList) : Bundle.declareGlobalAttrs(attrNamesList);
        }
        return this.attributeNames.size() == 1 ? Bundle.declareElementAttr(attrNamesList, this.elementContextName) : Bundle.declareElementAttrs(attrNamesList, this.elementContextName);
    }

    public void implement() throws Exception {
        Configuration conf = Configuration.get(this.snapshot.getSource().getFileObject());
        if (this.elementContextName != null) {
            Tag tag = conf.getTag(this.elementContextName);
            if (tag == null) {
                for (String aName : this.attributeNames) {
                    Attribute attribute = new Attribute(aName);
                    attribute.addContext(this.elementContextName);
                    conf.add(attribute);
                }
            } else {
                for (String aName : this.attributeNames) {
                    tag.add(new Attribute(aName));
                }
            }
        } else {
            for (String aName : this.attributeNames) {
                conf.add(new Attribute(aName));
            }
        }
        conf.store();
        LexerUtils.rebuildTokenHierarchy((Document)this.snapshot.getSource().getDocument(true));
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

