/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;

public enum DependencyType {
    COMPILE("compile", "provided", "system"),
    TEST("test"),
    RUNTIME("runtime"),
    NONCP(new String[0]);

    private final List<String> scopes;

    private DependencyType(String ... artifactScopes) {
        this.scopes = Collections.unmodifiableList(artifactScopes == null || artifactScopes.length == 0 ? Collections.emptyList() : Arrays.asList(artifactScopes));
    }

    public List<String> artifactScopes() {
        return this.scopes;
    }

    static DependencyType forArtifact(Artifact a) {
        String scope = a.getScope();
        for (DependencyType t : DependencyType.values()) {
            for (String s : t.artifactScopes()) {
                if (!s.equals(scope)) continue;
                return t;
            }
        }
        return NONCP;
    }
}

