/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.LibrariesNode;
import org.netbeans.modules.apisupport.project.ui.UnitTestLibrariesNode;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

public class LibrariesNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        NbModuleProject proj = (NbModuleProject)p.getLookup().lookup(NbModuleProject.class);
        assert (proj != null);
        return new LibraryNL(proj);
    }

    private static class LibraryNL
    implements NodeList<String>,
    AntProjectListener {
        private NbModuleProject project;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        LibraryNL(NbModuleProject prj) {
            this.project = prj;
        }

        public List<String> keys() {
            ArrayList<String> toRet = new ArrayList<String>();
            toRet.add("libraries");
            for (String testType : this.project.supportedTestTypes()) {
                toRet.add(testType);
            }
            return toRet;
        }

        public void addChangeListener(ChangeListener l) {
            this.cs.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.cs.removeChangeListener(l);
        }

        public Node node(String key) {
            if (key.equals("libraries")) {
                return new LibrariesNode(this.project);
            }
            return new UnitTestLibrariesNode(key, this.project);
        }

        public void addNotify() {
            this.project.getHelper().addAntProjectListener((AntProjectListener)this);
        }

        public void removeNotify() {
            this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.cs.fireChange();
        }

        public void propertiesChanged(AntProjectEvent ev) {
        }
    }
}

