/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf.windows8;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.UIManager;

public class WindowsDPIWorkaroundIcon
implements Icon {
    private final Icon delegate;
    private final int width;
    private final int height;

    public WindowsDPIWorkaroundIcon(Icon delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
        this.width = delegate.getIconWidth();
        this.height = delegate.getIconHeight();
    }

    public static boolean isWorkaroundRequired() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        String lafName = UIManager.getLookAndFeel().getClass().getName();
        return lafName.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") && Boolean.TRUE.equals(tk.getDesktopProperty("win.xpstyle.themeActive")) && System.getProperty("swing.noxp") == null;
    }

    private static double roundToNearestMultiple(double v, double multiple) {
        return (double)Math.round(v / multiple) * multiple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(Component c, Graphics g0, int x, int y) {
        double thisPaintScale = WindowsDPIWorkaroundIcon.getScaling(((Graphics2D)g0).getTransform());
        double toolkitScale = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
        double currentWidth = this.delegate.getIconWidth();
        double currentHeight = this.delegate.getIconHeight();
        double lowerBound = Math.max((currentWidth - 1.0) / (double)this.width, (currentHeight - 1.0) / (double)this.height);
        double upperBound = Math.min((currentWidth + 1.0) / (double)this.width, (currentHeight + 1.0) / (double)this.height);
        double average = (lowerBound + upperBound) / 2.0;
        ArrayList<Double> candidateScales = new ArrayList<Double>();
        candidateScales.add(WindowsDPIWorkaroundIcon.roundToNearestMultiple(thisPaintScale / toolkitScale, 0.25));
        candidateScales.add(toolkitScale);
        candidateScales.add(1.0 / toolkitScale);
        candidateScales.add(WindowsDPIWorkaroundIcon.roundToNearestMultiple(average, 0.25));
        candidateScales.add(WindowsDPIWorkaroundIcon.roundToNearestMultiple(1.0 / average, 0.25));
        double toIconSizeChangeFactor = average;
        Iterator iterator = candidateScales.iterator();
        while (iterator.hasNext()) {
            double candidate = (Double)iterator.next();
            if (!(candidate > 0.0) || !(candidate >= lowerBound) || !(candidate <= upperBound)) continue;
            toIconSizeChangeFactor = candidate;
            break;
        }
        double iconSizeChangeFactor = toIconSizeChangeFactor;
        double delegatePaintScale = iconSizeChangeFactor * toolkitScale;
        if (thisPaintScale == toolkitScale && iconSizeChangeFactor == 1.0) {
            this.delegate.paintIcon(c, g0, x, y);
            return;
        }
        Image img = this.createDelegatePaintedImage(c);
        Graphics2D g = (Graphics2D)g0.create();
        try {
            g.translate(x, y);
            if (thisPaintScale != 1.0) {
                AffineTransform tx = g.getTransform();
                g.setTransform(new AffineTransform(thisPaintScale, 0.0, 0.0, thisPaintScale, (double)((int)tx.getTranslateX()), (double)((int)tx.getTranslateY())));
            }
            WindowsDPIWorkaroundIcon.addScalingRenderingHints(g);
            g.scale(1.0 / delegatePaintScale, 1.0 / delegatePaintScale);
            g.drawImage(img, 0, 0, null);
        }
        finally {
            g.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createDelegatePaintedImage(Component c) {
        double toolkitScale = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
        int EXTRA_PIXELS = 2;
        BufferedImage img = new BufferedImage(2 + (int)Math.ceil((double)this.delegate.getIconWidth() * toolkitScale), 2 + (int)Math.ceil((double)this.delegate.getIconHeight() * toolkitScale), 2);
        Graphics2D g = img.createGraphics();
        try {
            WindowsDPIWorkaroundIcon.addScalingRenderingHints(g);
            g.scale((double)Math.round((double)this.width * toolkitScale) / (double)this.width, (double)Math.round((double)this.height * toolkitScale) / (double)this.height);
            this.delegate.paintIcon(c, g, 0, 0);
        }
        finally {
            g.dispose();
        }
        return img;
    }

    private static void addScalingRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    private static double getScaling(AffineTransform tx) {
        int txType = tx.getType();
        if (txType == 2 || txType == 3) {
            return tx.getScaleX();
        }
        return 1.0;
    }
}

