/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.platform;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvider;
import org.netbeans.modules.web.clientproject.api.platform.PlatformProvidersListener;
import org.netbeans.modules.web.clientproject.platform.PlatformProviderAccessor;
import org.netbeans.modules.web.clientproject.spi.platform.PlatformProviderImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.PlatformProviderImplementationListener;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;

public final class PlatformProviders {
    public static final String PLATFORM_PATH = "HTML5/Platform";
    private static final Lookup.Result<PlatformProviderImplementation> PLATFORM_PROVIDERS = Lookups.forPath((String)"HTML5/Platform").lookupResult(PlatformProviderImplementation.class);
    private static final PlatformProviders INSTANCE = new PlatformProviders();
    private final List<PlatformProvider> platformProviders = new CopyOnWriteArrayList<PlatformProvider>();
    private final PlatformProvidersListener.Support listenersSupport = new PlatformProvidersListener.Support();
    private final DelegatingPlatformProviderListener delegatingPlatformProvidersListener = new DelegatingPlatformProviderListener();

    private PlatformProviders() {
        this.initProviders();
    }

    public static PlatformProviders getDefault() {
        return INSTANCE;
    }

    public List<PlatformProvider> getPlatformProviders() {
        return new ArrayList<PlatformProvider>(this.platformProviders);
    }

    @CheckForNull
    public PlatformProvider findPlatformProvider(@NonNull String identifier) {
        Parameters.notNull((CharSequence)"identifier", (Object)identifier);
        for (PlatformProvider platformProvider : this.platformProviders) {
            if (!platformProvider.getIdentifier().equals(identifier)) continue;
            return platformProvider;
        }
        return null;
    }

    public void setPlatformProvider(@NonNull Project project, @NonNull PlatformProvider platformProvider) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"platformProvider", (Object)platformProvider);
        platformProvider.notifyPropertyChanged(project, new PropertyChangeEvent(project, "ENABLED", null, true));
    }

    public void projectOpened(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        for (PlatformProvider platformProvider : this.platformProviders) {
            platformProvider.projectOpened(project);
        }
    }

    public void projectClosed(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        for (PlatformProvider platformProvider : this.platformProviders) {
            platformProvider.projectClosed(project);
        }
    }

    public void notifyPropertyChanged(@NonNull Project project, @NonNull PlatformProvider platformProvider, @NonNull PropertyChangeEvent event) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"platformProvider", (Object)platformProvider);
        Parameters.notNull((CharSequence)"event", (Object)event);
        platformProvider.notifyPropertyChanged(project, event);
    }

    public void notifyPropertyChanged(@NonNull Project project, @NonNull PropertyChangeEvent event) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"event", (Object)event);
        for (PlatformProvider platformProvider : this.platformProviders) {
            platformProvider.notifyPropertyChanged(project, event);
        }
    }

    public void addPlatformProvidersListener(@NullAllowed PlatformProvidersListener listener) {
        this.listenersSupport.addPlatformProvidersListener(listener);
    }

    public void removePlatformProvidersListener(@NullAllowed PlatformProvidersListener listener) {
        this.listenersSupport.removePlatformProvidersListener(listener);
    }

    private void initProviders() {
        assert (this.platformProviders.isEmpty()) : "Empty providers expected but: " + this.platformProviders;
        this.platformProviders.addAll(this.map(PLATFORM_PROVIDERS.allInstances()));
        for (PlatformProvider provider : this.platformProviders) {
            provider.getDelegate().addPlatformProviderImplementationListener(this.delegatingPlatformProvidersListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reinitProviders() {
        List<PlatformProvider> list = this.platformProviders;
        synchronized (list) {
            this.clearProviders();
            this.initProviders();
        }
        this.listenersSupport.firePlatformProvidersChanged();
    }

    private void clearProviders() {
        this.platformProviders.clear();
    }

    @CheckForNull
    PlatformProvider findPlatformProvider(PlatformProviderImplementation platformProviderImplementation) {
        assert (platformProviderImplementation != null);
        for (PlatformProvider provider : this.platformProviders) {
            if (provider.getDelegate() != platformProviderImplementation) continue;
            return provider;
        }
        assert (false) : "Cannot find platform provider for implementation: " + platformProviderImplementation.getIdentifier();
        return null;
    }

    private Collection<PlatformProvider> map(Collection<? extends PlatformProviderImplementation> providers) {
        ArrayList<PlatformProvider> result = new ArrayList<PlatformProvider>();
        for (PlatformProviderImplementation platformProviderImplementation : providers) {
            result.add(PlatformProviderAccessor.getDefault().create(platformProviderImplementation));
        }
        return result;
    }

    static {
        PLATFORM_PROVIDERS.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                INSTANCE.reinitProviders();
            }
        });
    }

    private final class DelegatingPlatformProviderListener
    implements PlatformProviderImplementationListener {
        private DelegatingPlatformProviderListener() {
        }

        @Override
        public void propertyChanged(Project project, PlatformProviderImplementation platformProvider, PropertyChangeEvent event) {
            Parameters.notNull((CharSequence)"platformProvider", (Object)platformProvider);
            Parameters.notNull((CharSequence)"event", (Object)event);
            PlatformProvider provider = PlatformProviders.this.findPlatformProvider(platformProvider);
            if (provider != null) {
                PlatformProviders.this.listenersSupport.firePropertyChanged(project, provider, event);
            }
        }
    }
}

