/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.PerformanceBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.JSAttributes;

public final class PerformanceBuiltins
extends JSBuiltinsContainer.Lambda {
    public PerformanceBuiltins() {
        super("performance");
        this.defineFunction("now", 0, JSAttributes.getDefault(), (context, builtin) -> PerformanceBuiltinsFactory.JSPerformanceNowNodeGen.create(context, builtin, PerformanceBuiltins.args().fixedArgs(0).createArgumentNodes(context)));
    }

    public static abstract class JSPerformanceNowNode
    extends JSBuiltinNode {
        public JSPerformanceNowNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected double now() {
            long ns = this.getContext().getRealm().nanoTime();
            return (double)ns / 1000000.0;
        }
    }
}

