/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros.storage.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.core.options.keymap.api.KeyStrokeUtils;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.modules.editor.macros.MacroShortcutsInjector;
import org.netbeans.modules.editor.macros.MacrosKeymapManager;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class MacrosModel {
    private static final Logger LOG = Logger.getLogger(MacrosModel.class.getName());
    public static final int NAME_COLUMN_IDX = 0;
    public static final int SHORTCUTS_COLUMN_IDX = 1;
    public static final int COLUMN_COUNT = 2;
    private Map<MimePath, Map<String, Macro>> mimeType2Macros = new HashMap<MimePath, Map<String, Macro>>();
    private List<Macro> allMacrosList = new ArrayList<Macro>();
    private final MacrosTableModel tableModel = new MacrosTableModel();
    private boolean changed = false;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private boolean loaded = false;
    private static Reference<MacrosModel> ref = null;
    private static final Comparator<Macro> MACRO_COMPARATOR = new Comparator<Macro>(){

        @Override
        public int compare(Macro o1, Macro o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public static synchronized MacrosModel get() {
        MacrosModel model;
        MacrosModel macrosModel = model = ref == null ? null : ref.get();
        if (model == null) {
            model = new MacrosModel();
            ref = new WeakReference<MacrosModel>(model);
        }
        return model;
    }

    public void load() {
        EditorSettingsStorage ess = EditorSettingsStorage.get((String)"Macros");
        this.mimeType2Macros = new HashMap<MimePath, Map<String, Macro>>();
        this.allMacrosList = new ArrayList<Macro>();
        HashSet<String> allMimeTypes = new HashSet<String>();
        allMimeTypes.add("");
        allMimeTypes.addAll(EditorSettings.getDefault().getAllMimeTypes());
        for (String mt : allMimeTypes) {
            Map macros;
            MimePath mimeType = MimePath.parse((String)mt);
            try {
                macros = ess.load(mimeType, null, false);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Can't load macros for '" + mimeType + "'", ioe);
                continue;
            }
            Map<String, Macro> map = this.mimeType2Macros.get(mimeType);
            if (map == null) {
                map = new HashMap<String, Macro>(macros.size());
                this.mimeType2Macros.put(mimeType, map);
            }
            for (String macroName : macros.keySet()) {
                MacroDescription md = (MacroDescription)macros.get(macroName);
                Macro macro = new Macro(this, mimeType, md);
                map.put(macroName, macro);
                this.allMacrosList.add(macro);
            }
        }
        Collections.sort(this.allMacrosList, MACRO_COMPARATOR);
        this.loaded = true;
        this.tableModel.fireTableDataChanged();
        this.setChanged(false);
    }

    public void save() {
        EditorSettingsStorage ess = EditorSettingsStorage.get((String)"Macros");
        for (MimePath mimeType : this.mimeType2Macros.keySet()) {
            Map<String, Macro> map = this.mimeType2Macros.get(mimeType);
            HashMap<String, MacroDescription> macros = new HashMap<String, MacroDescription>(map.size());
            for (String macroName : map.keySet()) {
                Macro macro = map.get(macroName);
                macros.put(macroName, macro.getMacroDescription());
            }
            try {
                ess.save(mimeType, null, false, macros);
            }
            catch (IOException ioe) {
                LOG.log(Level.WARNING, "Can't save macros for '" + mimeType + "'", ioe);
            }
        }
        this.setChanged(false);
        MacroShortcutsInjector.refreshShortcuts();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public String validateMacroName(String macroName) {
        if (macroName == null || macroName.trim().length() == 0) {
            return NbBundle.getMessage(MacrosModel.class, (String)"CTL_Empty_Macro_Name");
        }
        Map<String, Macro> map = this.mimeType2Macros.get(MimePath.EMPTY);
        if (map.containsKey(macroName)) {
            return NbBundle.getMessage(MacrosModel.class, (String)"CTL_Duplicate_Macro_Name");
        }
        return null;
    }

    public Macro getMacroByIndex(int tableRow) {
        return this.allMacrosList.get(tableRow);
    }

    public Macro createMacro(MimePath mimeType, String name) {
        Macro macro = new Macro(this, mimeType, name, "", Collections.emptyList());
        Map<String, Macro> map = this.mimeType2Macros.get(mimeType);
        if (map == null) {
            map = new HashMap<String, Macro>();
            this.mimeType2Macros.put(mimeType, map);
        }
        if (map.containsKey(name)) {
            throw new IllegalArgumentException("Can't create macro, the name is already used: '" + name + "'");
        }
        map.put(name, macro);
        this.allMacrosList.add(macro);
        this.tableModel.fireTableRowsInserted(this.allMacrosList.size() - 1, this.allMacrosList.size() - 1);
        this.fireChanged();
        return macro;
    }

    public void deleteMacro(int tableRow) {
        Macro macro = this.allMacrosList.get(tableRow);
        macro.setShortcuts(Collections.emptySet());
        this.allMacrosList.remove(tableRow);
        Map<String, Macro> map = this.mimeType2Macros.get(macro.getMimeType());
        map.remove(macro.getName());
        this.tableModel.fireTableRowsDeleted(tableRow, tableRow);
        this.fireChanged();
    }

    public List<Macro> getAllMacros() {
        return Collections.unmodifiableList(this.allMacrosList);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private MacrosModel() {
    }

    private void fireTableModelChange(Macro m, int columnIndex) {
        assert (columnIndex >= 0 && columnIndex < 2);
        this.tableModel.fireTableDataChanged();
    }

    private void fireChanged() {
        EditorSettingsStorage ess = EditorSettingsStorage.get((String)"Macros");
        for (MimePath mimeType : this.mimeType2Macros.keySet()) {
            Map<String, Macro> map = this.mimeType2Macros.get(mimeType);
            HashMap<String, MacroDescription> current = new HashMap<String, MacroDescription>(map.size());
            for (String macroName : map.keySet()) {
                current.put(macroName, map.get(macroName).getMacroDescription());
            }
            try {
                if (ess.load(mimeType, null, false).equals(current)) continue;
                this.setChanged(true);
                return;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.setChanged(false);
    }

    private void setChanged(boolean changed) {
        if (this.changed == changed) {
            return;
        }
        this.changed = changed;
        this.pcs.firePropertyChange("changed", !changed, changed);
    }

    private final class MacrosTableModel
    extends AbstractTableModel {
        private MacrosTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return MacrosModel.this.allMacrosList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((Macro)MacrosModel.this.allMacrosList.get(rowIndex)).getName();
                }
                case 1: {
                    StringBuilder sb = new StringBuilder();
                    for (int j = 0; j < ((Macro)MacrosModel.this.allMacrosList.get(rowIndex)).getShortcuts().size(); ++j) {
                        MultiKeyBinding mkb = ((Macro)MacrosModel.this.allMacrosList.get(rowIndex)).getShortcuts().get(j);
                        List list = mkb.getKeyStrokeList();
                        KeyStroke[] arr = list.toArray(new KeyStroke[list.size()]);
                        sb.append(KeyStrokeUtils.getKeyStrokesAsText((KeyStroke[])arr, (String)" "));
                        if (j + 1 >= ((Macro)MacrosModel.this.allMacrosList.get(rowIndex)).getShortcuts().size()) continue;
                        sb.append(", ");
                    }
                    return sb.toString();
                }
            }
            throw new ArrayIndexOutOfBoundsException("Invalid column index: " + columnIndex);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(MacrosModel.class, (String)"MacrosTable_Name_Column_Title");
                }
                case 1: {
                    return NbBundle.getMessage(MacrosModel.class, (String)"MacrosTable_Shortcut_Column_Title");
                }
            }
            throw new ArrayIndexOutOfBoundsException("Invalid column index: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }

    public static final class Macro
    implements ShortcutAction {
        public static final String PROP_CODE = "Macro.PROP_CODE";
        public static final String PROP_SHORTCUTS = "Macro.PROP_SHORTCUTS";
        private final MacrosModel model;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
        private final MimePath mimeType;
        private MacroDescription macroDescription;
        private String name;
        private String code;
        private List<? extends MultiKeyBinding> shortcuts;

        public MimePath getMimeType() {
            return this.mimeType;
        }

        public String getName() {
            return this.macroDescription != null ? this.macroDescription.getName() : this.name;
        }

        public String getCode() {
            return this.macroDescription != null ? this.macroDescription.getCode() : this.code;
        }

        public void setCode(String code) {
            if (Utilities.compareObjects((Object)this.getCode(), (Object)code)) {
                return;
            }
            this.cloneOnModify();
            String oldCode = this.code;
            this.code = code;
            this.pcs.firePropertyChange(PROP_CODE, oldCode, code);
            this.model.fireChanged();
        }

        public List<? extends MultiKeyBinding> getShortcuts() {
            return this.macroDescription != null ? this.macroDescription.getShortcuts() : this.shortcuts;
        }

        public void setShortcut(String shortcut) {
            KeyStroke[] strokes = KeyStrokeUtils.getKeyStrokes((String)shortcut);
            if (strokes == null) {
                LOG.warning("Could not decode keystrokes from: " + shortcut);
                return;
            }
            List<MultiKeyBinding> list = Collections.singletonList(new MultiKeyBinding(strokes, "run-macro"));
            List<? extends MultiKeyBinding> current = this.getShortcuts();
            if (current != null && list != null && current.size() == list.size() && current.containsAll(list)) {
                return;
            }
            this.cloneOnModify();
            List<? extends MultiKeyBinding> oldShortcuts = this.shortcuts;
            this.shortcuts = list;
            this.pcs.firePropertyChange(PROP_SHORTCUTS, oldShortcuts, this.shortcuts);
            this.model.fireTableModelChange(this, 1);
            this.model.fireChanged();
        }

        public void setShortcuts(Set<String> shortcuts) {
            ArrayList<? extends MultiKeyBinding> list = new ArrayList<MultiKeyBinding>(shortcuts.size());
            for (String shortcut : shortcuts) {
                KeyStroke[] keys = Utilities.stringToKeys((String)shortcut);
                if (keys == null) {
                    LOG.warning("Could not decode keystrokes from: " + shortcut);
                    continue;
                }
                list.add(new MultiKeyBinding(keys, "run-macro"));
            }
            if (Utilities.compareObjects(new HashSet<MultiKeyBinding>(this.getShortcuts()), new HashSet(list))) {
                return;
            }
            this.cloneOnModify();
            List<? extends MultiKeyBinding> oldShortcuts = this.shortcuts;
            this.shortcuts = list;
            this.pcs.firePropertyChange(PROP_SHORTCUTS, oldShortcuts, shortcuts);
            this.model.fireTableModelChange(this, 1);
            this.model.fireChanged();
        }

        public String getDisplayName() {
            String languageName = EditorSettings.getDefault().getLanguageName(this.mimeType.getPath()).toLowerCase();
            if (this.mimeType == MimePath.EMPTY) {
                return NbBundle.getMessage(MacrosModel.class, (String)"MacroAction_DisplayName_1", (Object)this.getName(), (Object)languageName);
            }
            return NbBundle.getMessage(MacrosModel.class, (String)"MacroAction_DisplayName_2", (Object)this.getName(), (Object)languageName);
        }

        public String getId() {
            return this.getName() + "@" + this.mimeType.getPath();
        }

        public String getDelegatingActionId() {
            return null;
        }

        public ShortcutAction getKeymapManagerInstance(String keymapManagerName) {
            if (keymapManagerName != null && keymapManagerName.equals(MacrosKeymapManager.class.getName())) {
                return this;
            }
            return null;
        }

        private Macro(MacrosModel model, MimePath mimeType, String name, String code, List<? extends MultiKeyBinding> shortcuts) {
            this.model = model;
            this.mimeType = mimeType;
            this.name = name;
            this.code = code;
            this.shortcuts = shortcuts;
        }

        private Macro(MacrosModel model, MimePath mimeType, MacroDescription macroDescription) {
            this.model = model;
            this.mimeType = mimeType;
            this.macroDescription = macroDescription;
        }

        private void cloneOnModify() {
            if (this.macroDescription != null) {
                this.name = this.macroDescription.getName();
                this.code = this.macroDescription.getCode();
                this.shortcuts = this.macroDescription.getShortcuts();
                this.macroDescription = null;
            }
        }

        private MacroDescription getMacroDescription() {
            return this.macroDescription != null ? this.macroDescription : new MacroDescription(this.name, this.code, null, this.shortcuts);
        }
    }
}

