/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.MpdResultSetRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.common.NumberHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.ProjectReader;

public final class AstaDatabaseReader
implements ProjectReader {
    private AstaReader m_reader;
    private Integer m_projectID;
    private String m_schema = "";
    private DataSource m_dataSource;
    private Connection m_connection;
    private boolean m_allocatedConnection;
    private PreparedStatement m_ps;
    private ResultSet m_rs;
    private Map<String, Integer> m_meta = new HashMap<String, Integer>();
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public Map<Integer, String> listProjects() throws MPXJException {
        try {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            List<Row> list = this.getRows("select projid, short_name from project_summary");
            for (Row row : list) {
                Integer n = row.getInteger("projid");
                String string = row.getString("short_name");
                hashMap.put(n, string);
            }
            return hashMap;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
    }

    public ProjectFile read() throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile projectFile = this.m_reader.getProject();
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.m_reader = null;
            ProjectFile projectFile2 = projectFile;
            return projectFile2;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
        finally {
            if (this.m_allocatedConnection && this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
                this.m_connection = null;
            }
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> list = this.getRows("select * from project_summary where projid=?", this.m_projectID);
        if (!list.isEmpty()) {
            this.m_reader.processProjectProperties(list.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        List<Row> list = this.getRows("select * from exceptionn");
        Map<Integer, DayType> map = this.m_reader.createExceptionTypeMap(list);
        list = this.getRows("select * from work_pattern");
        Map<Integer, Row> map2 = this.m_reader.createWorkPatternMap(list);
        list = this.getRows("select * from work_pattern_assignment");
        Map<Integer, List<Row>> map3 = this.m_reader.createWorkPatternAssignmentMap(list);
        list = this.getRows("select * from exception_assignment order by exception_assignmentid, ordf");
        Map<Integer, List<Row>> map4 = this.m_reader.createExceptionAssignmentMap(list);
        list = this.getRows("select * from time_entry order by time_entryid, ordf");
        Map<Integer, List<Row>> map5 = this.m_reader.createTimeEntryMap(list);
        list = this.getRows("select * from calendar where projid=? order by calendarid", this.m_projectID);
        for (Row row : list) {
            this.m_reader.processCalendar(row, map2, map3, map4, map5, map);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> list = this.getRows("select * from permanent_resource where projid=? order by permanent_resourceid", this.m_projectID);
        List<Row> list2 = this.getRows("select * from consumable_resource where projid=? order by consumable_resourceid", this.m_projectID);
        this.m_reader.processResources(list, list2);
    }

    private void processTasks() throws SQLException {
        List<Row> list = this.getRows("select * from bar where projid=?", this.m_projectID);
        List<Row> list2 = this.getRows("select * from expanded_task where projid=?", this.m_projectID);
        List<Row> list3 = this.getRows("select * from task where projid=?", this.m_projectID);
        List<Row> list4 = this.getRows("select * from milestone where projid=?", this.m_projectID);
        this.m_reader.processTasks(list, list2, list3, list4);
    }

    private void processPredecessors() throws SQLException {
        List<Row> list = this.getRows("select * from link where projid=? order by linkid", this.m_projectID);
        this.m_reader.processPredecessors(list);
    }

    private void processAssignments() throws SQLException {
        List<Row> list = this.getRows("select * from permanent_schedul_allocation inner join perm_resource_skill on permanent_schedul_allocation.allocatiop_of = perm_resource_skill.perm_resource_skillid where permanent_schedul_allocation.projid=? order by permanent_schedul_allocation.permanent_schedul_allocationid", this.m_projectID);
        this.m_reader.processAssignments(list);
    }

    public void setProjectID(int n) {
        this.m_projectID = n;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public void setConnection(Connection connection) {
        this.m_connection = connection;
    }

    @Override
    public ProjectFile read(String string) throws MPXJException {
        try {
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            String string2 = "jdbc:odbc:DRIVER=Microsoft Access Driver (*.mdb);DBQ=" + string;
            this.m_connection = DriverManager.getConnection(string2);
            this.m_projectID = 0;
            ProjectFile projectFile = this.read();
            return projectFile;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MPXJException("Failed to load JDBC driver", classNotFoundException);
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Failed to create connection", sQLException);
        }
        finally {
            if (this.m_connection != null) {
                try {
                    this.m_connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public ProjectFile read(File file) throws MPXJException {
        return this.read(file.getAbsolutePath());
    }

    @Override
    public ProjectFile read(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String string) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> linkedList = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new MpdResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Row> getRows(String string, Integer n) throws SQLException {
        this.allocateConnection();
        try {
            LinkedList<Row> linkedList = new LinkedList<Row>();
            this.m_ps = this.m_connection.prepareStatement(string);
            this.m_ps.setInt(1, NumberHelper.getInt(n));
            this.m_rs = this.m_ps.executeQuery();
            this.populateMetaData();
            while (this.m_rs.next()) {
                linkedList.add(new MpdResultSetRow(this.m_rs, this.m_meta));
            }
            LinkedList<Row> linkedList2 = linkedList;
            return linkedList2;
        }
        finally {
            this.releaseConnection();
        }
    }

    private void allocateConnection() throws SQLException {
        if (this.m_connection == null) {
            this.m_connection = this.m_dataSource.getConnection();
            this.m_allocatedConnection = true;
        }
    }

    private void releaseConnection() {
        if (this.m_rs != null) {
            try {
                this.m_rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_rs = null;
        }
        if (this.m_ps != null) {
            try {
                this.m_ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.m_ps = null;
        }
    }

    private void populateMetaData() throws SQLException {
        this.m_meta.clear();
        ResultSetMetaData resultSetMetaData = this.m_rs.getMetaData();
        int n = resultSetMetaData.getColumnCount() + 1;
        for (int i = 1; i < n; ++i) {
            String string = resultSetMetaData.getColumnName(i);
            Integer n2 = resultSetMetaData.getColumnType(i);
            this.m_meta.put(string, n2);
        }
    }

    public void setSchema(String string) {
        if (string.charAt(string.length() - 1) != '.') {
            string = string + '.';
        }
        this.m_schema = string;
    }

    public String getSchema() {
        return this.m_schema;
    }
}

