/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffController;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRChangesDiffHelperImpl;
import org.jetbrains.plugins.github.pullrequest.ui.changes.MutableDiffRequestChainProcessor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000f\u0010\u0016\u001a\t\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffFileEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "diffChainUpdateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "diffHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRChangesDiffHelperImpl;", "diffProcessor", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/MutableDiffRequestChainProcessor;", "getComponent", "Ljavax/swing/JComponent;", "Lorg/jetbrains/annotations/NotNull;", "getName", "", "getPreferredFocusedComponent", "Lorg/jetbrains/annotations/Nullable;", "isValid", "", "selectNotify", "", "intellij.vcs.github"})
public final class GHPRDiffFileEditor
extends FileEditorBase {
    private final GHPRDataProvider dataProvider;
    private final MutableDiffRequestChainProcessor diffProcessor;
    private final GHPRChangesDiffHelperImpl diffHelper;
    private final MergingUpdateQueue diffChainUpdateQueue;

    public boolean isValid() {
        return !Disposer.isDisposed((Disposable)((Disposable)this.diffProcessor));
    }

    @NotNull
    public String getName() {
        return "Pull Request Diff";
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.diffProcessor.getComponent();
        Intrinsics.checkExpressionValueIsNotNull((Object)jComponent, (String)"diffProcessor.component");
        return jComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.diffProcessor.getPreferredFocusedComponent();
    }

    public void selectNotify() {
        this.diffProcessor.updateRequest();
    }

    public GHPRDiffFileEditor(@NotNull Project project, @NotNull GHPRDataContext dataContext, @NotNull GHPRIdentifier pullRequest) {
        MergingUpdateQueue mergingUpdateQueue;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)pullRequest, (String)"pullRequest");
        this.dataProvider = dataContext.getDataProviderRepository().getDataProvider(pullRequest, (Disposable)this);
        this.diffProcessor = new MutableDiffRequestChainProcessor(project, null);
        this.diffHelper = new GHPRChangesDiffHelperImpl(project, this.dataProvider, dataContext.getAvatarIconsProviderFactory(), dataContext.getSecurityService().getCurrentUser());
        MergingUpdateQueue mergingUpdateQueue2 = new MergingUpdateQueue("updateDiffChainQueue", 100, true, null, (Disposable)this);
        GHPRDiffFileEditor gHPRDiffFileEditor = this;
        boolean bl = false;
        boolean bl2 = false;
        MergingUpdateQueue $this$apply = mergingUpdateQueue2;
        boolean bl3 = false;
        $this$apply.setRestartTimerOnAdd(true);
        gHPRDiffFileEditor.diffChainUpdateQueue = mergingUpdateQueue = mergingUpdateQueue2;
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)this.diffProcessor));
        this.diffProcessor.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                this.getPropertyChangeSupport().firePropertyChange("valid", true, false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        final GHPRDiffController changesSelectionHolder = this.dataProvider.getDiffController();
        changesSelectionHolder.addAndInvokeSelectionListener((Disposable)this.diffChainUpdateQueue, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                final ListSelection<Change> selection2 = changesSelectionHolder.getSelection();
                diffChainUpdateQueue.run(Update.create((Object)changesSelectionHolder, (Runnable)new Runnable(){

                    @Override
                    public final void run() {
                        DiffRequestChain diffRequestChain;
                        MutableDiffRequestChainProcessor mutableDiffRequestChainProcessor = diffProcessor;
                        ListSelection listSelection = selection2;
                        if (listSelection != null) {
                            ListSelection listSelection2 = listSelection;
                            MutableDiffRequestChainProcessor mutableDiffRequestChainProcessor2 = mutableDiffRequestChainProcessor;
                            boolean bl = false;
                            boolean bl2 = false;
                            ListSelection it = listSelection2;
                            boolean bl3 = false;
                            DiffRequestChain diffRequestChain2 = diffHelper.getRequestChain((ListSelection<Change>)it);
                            mutableDiffRequestChainProcessor = mutableDiffRequestChainProcessor2;
                            diffRequestChain = diffRequestChain2;
                        } else {
                            diffRequestChain = null;
                        }
                        mutableDiffRequestChainProcessor.setChain(diffRequestChain);
                    }
                }));
            }
        }));
    }
}

