/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.PySmartEnterProcessor;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFixer;
import com.jetbrains.python.codeInsight.editorActions.smartEnter.fixers.PyFunctionFixer;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import org.jetbrains.annotations.NotNull;

public class PyParameterListFixer
extends PyFixer<PyParameterList> {
    public PyParameterListFixer() {
        super(PyParameterList.class);
    }

    @Override
    public void doApply(@NotNull Editor editor2, @NotNull PySmartEnterProcessor processor2, @NotNull PyParameterList parameters) throws IncorrectOperationException {
        if (editor2 == null) {
            PyParameterListFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            PyParameterListFixer.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            PyParameterListFixer.$$$reportNull$$$0(2);
        }
        PsiElement lBrace = PyPsiUtils.getChildByFilter((PsiElement)parameters, PyTokenTypes.OPEN_BRACES, 0);
        PsiElement rBrace = PyPsiUtils.getChildByFilter((PsiElement)parameters, PyTokenTypes.CLOSE_BRACES, 0);
        PyFunction pyFunction = PyUtil.as(parameters.getParent(), PyFunction.class);
        if (!(pyFunction == null || PyFunctionFixer.isFakeFunction(pyFunction) || lBrace != null && rBrace != null)) {
            Document document = editor2.getDocument();
            if (lBrace == null) {
                String textToInsert = pyFunction.getNameNode() == null ? " (" : "(";
                document.insertString(parameters.getTextOffset(), (CharSequence)textToInsert);
                PyParameterListFixer.insertParametersForMethod(pyFunction, document, parameters.getTextOffset() + textToInsert.length());
            } else if (parameters.getParameters().length == 0) {
                int lBraceOffset = lBrace.getTextRange().getEndOffset();
                int offsetWithParam = PyParameterListFixer.insertParametersForMethod(pyFunction, document, lBraceOffset);
                document.insertString(offsetWithParam, (CharSequence)")");
            } else {
                document.insertString(parameters.getTextRange().getEndOffset(), (CharSequence)")");
            }
        }
    }

    private static int insertParametersForMethod(@NotNull PyFunction pyFunction, @NotNull Document document, int offset) {
        if (pyFunction == null) {
            PyParameterListFixer.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PyParameterListFixer.$$$reportNull$$$0(4);
        }
        if (pyFunction.getContainingClass() != null) {
            PyFunction.Modifier modifier = pyFunction.getModifier();
            String parameterName = null;
            if (modifier == null) {
                parameterName = "self";
            } else if (modifier == PyFunction.Modifier.CLASSMETHOD) {
                parameterName = "cls";
            }
            if (parameterName != null) {
                document.insertString(offset, (CharSequence)parameterName);
                return offset + parameterName.length();
            }
        }
        return offset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/editorActions/smartEnter/fixers/PyParameterListFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doApply";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertParametersForMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

