/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions.convertToFString;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.codeInsight.intentions.convertToFString.BaseConvertToFStringProcessor;
import com.jetbrains.python.codeInsight.intentions.convertToFString.NewStyleConvertToFStringProcessor;
import com.jetbrains.python.codeInsight.intentions.convertToFString.OldStyleConvertToFStringProcessor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyConvertToFStringIntention
extends PyBaseIntentionAction {
    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.convert.to.fstring.literal", new Object[0]);
        if (string == null) {
            PyConvertToFStringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PyConvertToFStringIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor2, PsiFile file) {
        if (project == null) {
            PyConvertToFStringIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile) || LanguageLevel.forElement((PsiElement)file).isOlderThan(LanguageLevel.PYTHON36)) {
            return false;
        }
        BaseConvertToFStringProcessor processor2 = PyConvertToFStringIntention.findSuitableProcessor(editor2, file);
        return processor2 != null && processor2.isRefactoringAvailable();
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyConvertToFStringIntention.$$$reportNull$$$0(3);
        }
        BaseConvertToFStringProcessor processor2 = PyConvertToFStringIntention.findSuitableProcessor(editor2, file);
        assert (processor2 != null);
        processor2.doRefactoring();
    }

    @Nullable
    private static BaseConvertToFStringProcessor findSuitableProcessor(@NotNull Editor editor2, @NotNull PsiFile file) {
        PyStringLiteralExpression pyString;
        PyReferenceExpression callee;
        PyStringLiteralExpression pyString2;
        PsiElement anchor;
        if (editor2 == null) {
            PyConvertToFStringIntention.$$$reportNull$$$0(4);
        }
        if (file == null) {
            PyConvertToFStringIntention.$$$reportNull$$$0(5);
        }
        if ((anchor = file.findElementAt(editor2.getCaretModel().getOffset())) == null) {
            return null;
        }
        PyBinaryExpression binaryExpr = (PyBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyBinaryExpression.class);
        if (binaryExpr != null && binaryExpr.getOperator() == PyTokenTypes.PERC && (pyString2 = PyUtil.as(binaryExpr.getLeftExpression(), PyStringLiteralExpression.class)) != null) {
            return new OldStyleConvertToFStringProcessor(pyString2);
        }
        PyCallExpression callExpr = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyCallExpression.class);
        if (callExpr != null && (callee = PyUtil.as(callExpr.getCallee(), PyReferenceExpression.class)) != null && "format".equals(callee.getName()) && (pyString = PyUtil.as(callee.getQualifier(), PyStringLiteralExpression.class)) != null) {
            return new NewStyleConvertToFStringProcessor(pyString);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/convertToFString/PyConvertToFStringIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/convertToFString/PyConvertToFStringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableProcessor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

