/*
 * Decompiled with CFR 0.152.
 */
package com.github.hypfvieh.classloader;

import com.github.hypfvieh.classloader.ComponentRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ClassLoaderWithRegistry
extends ClassLoader {
    private static final String version = "0.0.3";
    private final Set<String> includePackageNames = new HashSet<String>(Arrays.asList("com.github.hypfvieh.", "classloadertest."));
    private final Set<String> excludeClassNames = new HashSet<String>(Arrays.asList("com.github.hypfvieh.classloader.ComponentRegistry"));

    public ClassLoaderWithRegistry(ClassLoader _parent) {
        super(_parent);
        ComponentRegistry.getInstance().registerComponent(ClassLoaderWithRegistry.class, ClassLoaderWithRegistry.getVersion());
    }

    public ClassLoaderWithRegistry() {
        ComponentRegistry.getInstance().registerComponent(ClassLoaderWithRegistry.class, ClassLoaderWithRegistry.getVersion());
    }

    public void addIncludedPackageNames(String _packageName) {
        if (_packageName.endsWith(".")) {
            this.includePackageNames.add(_packageName);
            ComponentRegistry.getInstance().addPackageToIncludeList(_packageName);
        }
    }

    public void addExcludedClassName(String _excludedClassName) {
        if (!_excludedClassName.endsWith(".")) {
            this.excludeClassNames.add(_excludedClassName);
        }
    }

    private boolean isIncluded(String _fqcn) {
        if (this.includePackageNames.contains(_fqcn)) {
            return true;
        }
        String packageName = _fqcn.substring(0, _fqcn.lastIndexOf(46) + 1);
        for (String str : this.includePackageNames) {
            if (!packageName.startsWith(str)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (!this.excludeClassNames.contains(name) && this.isIncluded(name)) {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                return c;
            }
            InputStream in = null;
            try {
                in = this.getParent().getResourceAsStream(name.replaceAll("\\.", "/") + ".class");
                if (in == null) {
                    throw new ClassNotFoundException("Could not find " + name);
                }
                byte[] cBytes = ClassLoaderWithRegistry.toByteArray(in);
                c = this.defineClass(name, cBytes, 0, cBytes.length);
                if (resolve) {
                    this.resolveClass(c);
                }
                ComponentRegistry.getInstance().registerComponent(c.getName());
                Class<?> clazz = c;
                return clazz;
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Could not load " + name, e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return super.loadClass(name, resolve);
    }

    public static String getVersion() {
        return version;
    }

    private static byte[] toByteArray(InputStream _is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((nRead = _is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

