/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeInspectionBase;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

@ApiStatus.Internal
public abstract class YamlMissingKeysInspectionBase
extends YamlMetaTypeInspectionBase {
    @Override
    @NotNull
    protected PsiElementVisitor doBuildVisitor(@NotNull ProblemsHolder holder, @NotNull YamlMetaTypeProvider metaTypeProvider) {
        if (holder == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(0);
        }
        if (metaTypeProvider == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(1);
        }
        return new StructureChecker(holder, metaTypeProvider);
    }

    @NotNull
    protected PsiElement getElementToHighlight(@NotNull YAMLMapping mapping) {
        PsiElement parent;
        if (mapping == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(2);
        }
        if ((parent = mapping.getParent()) instanceof YAMLDocument) {
            PsiElement psiElement = parent;
            if (psiElement == null) {
                YamlMissingKeysInspectionBase.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        if (parent instanceof YAMLSequenceItem) {
            PsiElement key = parent.getFirstChild();
            Object object = key != null ? key : mapping;
            if (object == null) {
                YamlMissingKeysInspectionBase.$$$reportNull$$$0(4);
            }
            return object;
        }
        if (parent instanceof YAMLKeyValue) {
            PsiElement key = ((YAMLKeyValue)parent).getKey();
            Object object = key != null ? key : mapping;
            if (object == null) {
                YamlMissingKeysInspectionBase.$$$reportNull$$$0(5);
            }
            return object;
        }
        YAMLMapping yAMLMapping = mapping;
        if (yAMLMapping == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(6);
        }
        return yAMLMapping;
    }

    @NotNull
    private static String composeKeyList(@NotNull Collection<String> missingKeys) {
        if (missingKeys == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(7);
        }
        String string = String.join((CharSequence)", ", missingKeys);
        if (string == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    private static Collection<String> getMissingKeys(@NotNull YAMLMapping mapping, @NotNull YamlMetaType metaClass) {
        if (mapping == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(9);
        }
        if (metaClass == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(10);
        }
        Set<String> existingKeys = mapping.getKeyValues().stream().map(it -> it.getKeyText().trim()).collect(Collectors.toSet());
        List<String> list = metaClass.computeMissingFields(existingKeys);
        if (list == null) {
            YamlMissingKeysInspectionBase.$$$reportNull$$$0(11);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaTypeProvider";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "missingKeys";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "composeKeyList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingKeys";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doBuildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "composeKeyList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMissingKeys";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddMissingKeysQuickFix
    implements LocalQuickFix {
        private final Collection<String> myMissingKeys;
        private final SmartPsiElementPointer<YAMLMapping> myMappingHolder;

        AddMissingKeysQuickFix(@NotNull Collection<String> missingKeys, @NotNull YAMLMapping mapping) {
            if (missingKeys == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(0);
            }
            if (mapping == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(1);
            }
            this.myMissingKeys = missingKeys;
            this.myMappingHolder = SmartPointerManager.getInstance((Project)mapping.getProject()).createSmartPsiElementPointer((PsiElement)mapping);
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = YAMLBundle.message("YamlMissingKeysInspectionBase.add.missing.keys.quickfix.name", new Object[0]);
            if (string == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(3);
            }
            if (descriptor == null) {
                AddMissingKeysQuickFix.$$$reportNull$$$0(4);
            }
            YAMLElementGenerator elementGenerator = YAMLElementGenerator.getInstance(project);
            PsiElement mapping = this.myMappingHolder.getElement();
            if (mapping == null) {
                return;
            }
            for (String missingKey : this.myMissingKeys) {
                mapping.add(elementGenerator.createEol());
                mapping.add(elementGenerator.createIndent(YAMLUtil.getIndentToThisElement(mapping)));
                mapping.add((PsiElement)elementGenerator.createYamlKeyValue(missingKey, ""));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "missingKeys";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$AddMissingKeysQuickFix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$AddMissingKeysQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected class StructureChecker
    extends YamlMetaTypeInspectionBase.SimpleYamlPsiVisitor {
        private final YamlMetaTypeProvider myMetaTypeProvider;
        private final ProblemsHolder myProblemsHolder;

        public StructureChecker(@NotNull ProblemsHolder problemsHolder, YamlMetaTypeProvider metaTypeProvider) {
            if (problemsHolder == null) {
                StructureChecker.$$$reportNull$$$0(0);
            }
            if (metaTypeProvider == null) {
                StructureChecker.$$$reportNull$$$0(1);
            }
            this.myProblemsHolder = problemsHolder;
            this.myMetaTypeProvider = metaTypeProvider;
        }

        @Override
        protected void visitYAMLMapping(@NotNull YAMLMapping mapping) {
            YamlMetaTypeProvider.MetaTypeProxy meta;
            if (mapping == null) {
                StructureChecker.$$$reportNull$$$0(2);
            }
            if ((meta = this.myMetaTypeProvider.getMetaTypeProxy((PsiElement)mapping)) == null) {
                return;
            }
            YamlMetaType metaType = meta.getMetaType();
            if (metaType instanceof YamlScalarType) {
                return;
            }
            Collection missingKeys = YamlMissingKeysInspectionBase.getMissingKeys(mapping, metaType);
            if (!missingKeys.isEmpty()) {
                String msg = YAMLBundle.message("YamlMissingKeysInspectionBase.missing.keys", YamlMissingKeysInspectionBase.composeKeyList(missingKeys));
                this.myProblemsHolder.registerProblem(YamlMissingKeysInspectionBase.this.getElementToHighlight(mapping), msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new AddMissingKeysQuickFix(missingKeys, mapping)});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problemsHolder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metaTypeProvider";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mapping";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/yaml/meta/impl/YamlMissingKeysInspectionBase$StructureChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitYAMLMapping";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

