/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.branch.BranchType;
import com.intellij.dvcs.branch.DvcsBranchSettings;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DvcsBranchManager {
    @NotNull
    private final DvcsBranchSettings myBranchSettings;
    @NotNull
    private final Map<BranchType, Collection<String>> myPredefinedFavoriteBranches;
    @NotNull
    private final Project myProject;
    @NotNull
    public static final Topic<DvcsBranchManagerListener> DVCS_BRANCH_SETTINGS_CHANGED = Topic.create((String)"Branch settings changed", DvcsBranchManagerListener.class);

    protected DvcsBranchManager(@NotNull Project project, @NotNull DvcsBranchSettings settings, BranchType @NotNull [] branchTypes) {
        if (project == null) {
            DvcsBranchManager.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DvcsBranchManager.$$$reportNull$$$0(1);
        }
        if (branchTypes == null) {
            DvcsBranchManager.$$$reportNull$$$0(2);
        }
        this.myPredefinedFavoriteBranches = new HashMap<BranchType, Collection<String>>();
        this.myProject = project;
        this.myBranchSettings = settings;
        for (BranchType type : branchTypes) {
            String defaultBranchName = this.getDefaultBranchName(type);
            if (StringUtil.isEmptyOrSpaces((String)defaultBranchName)) continue;
            this.myPredefinedFavoriteBranches.put(type, Collections.singleton(defaultBranchName));
        }
    }

    @Nullable
    protected String getDefaultBranchName(@NotNull BranchType type) {
        if (type == null) {
            DvcsBranchManager.$$$reportNull$$$0(3);
        }
        return null;
    }

    public boolean isFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName) {
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(4);
        }
        if (branchType == null) {
            return false;
        }
        String branchTypeName = branchType.getName();
        if (this.myBranchSettings.getFavorites().contains(branchTypeName, repository, branchName)) {
            return true;
        }
        if (this.myBranchSettings.getExcludedFavorites().contains(branchTypeName, repository, branchName)) {
            return false;
        }
        return this.isPredefinedAsFavorite(branchType, branchName);
    }

    private boolean isPredefinedAsFavorite(@NotNull BranchType type, @NotNull String branchName) {
        Collection<String> predefinedNames;
        if (type == null) {
            DvcsBranchManager.$$$reportNull$$$0(5);
        }
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(6);
        }
        return (predefinedNames = this.myPredefinedFavoriteBranches.get(type)) != null && predefinedNames.contains(branchName);
    }

    public void setFavorite(@Nullable BranchType branchType, @Nullable Repository repository, @NotNull String branchName, boolean shouldBeFavorite) {
        if (branchName == null) {
            DvcsBranchManager.$$$reportNull$$$0(7);
        }
        if (branchType == null) {
            return;
        }
        String branchTypeName = branchType.getName();
        if (shouldBeFavorite) {
            this.myBranchSettings.getExcludedFavorites().remove(branchTypeName, repository, branchName);
            if (!this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getFavorites().add(branchTypeName, repository, branchName);
            }
        } else {
            this.myBranchSettings.getFavorites().remove(branchTypeName, repository, branchName);
            if (this.isPredefinedAsFavorite(branchType, branchName)) {
                this.myBranchSettings.getExcludedFavorites().add(branchTypeName, repository, branchName);
            }
        }
        this.notifySettingsChanged();
    }

    private void notifySettingsChanged() {
        BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myProject, () -> ((DvcsBranchManagerListener)this.myProject.getMessageBus().syncPublisher(DVCS_BRANCH_SETTINGS_CHANGED)).branchSettingsChanged());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchTypes";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultBranchName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isFavorite";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPredefinedAsFavorite";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setFavorite";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface DvcsBranchManagerListener {
        public void branchSettingsChanged();
    }
}

