/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.vcs.log.TimedVcsCommit;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.fetch.GitFetchResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.L;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u001a.\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0000\u001a6\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0001H\u0000\u001a.\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a.\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0012H\u0000\u001a<\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\b2\b\b\u0003\u0010\u0016\u001a\u00020\b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0001\u001a(\u0010\u0018\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bH\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a$\u0010\u001c\u001a\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0000\u001a,\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0000\u00a8\u0006 "}, d2={"checkCommitsBetweenRefAndBranchName", "", "project", "Lcom/intellij/openapi/project/Project;", "repositories", "", "Lgit4idea/repo/GitRepository;", "startRef", "", "branchName", "checkCommitsUnderProgress", "checkout", "", "startPoint", "name", "withRebase", "checkoutOrReset", "newBranchOptions", "Lgit4idea/branch/GitNewBranchOptions;", "createNewBranch", "options", "createOrCheckoutNewBranch", "title", "initialName", "hasCommits", "repository", "endRef", "hasRemotes", "isTrackingInfosExist", "branchNames", "updateBranches", "localBranchNames", "intellij.vcs.git"})
public final class GitBranchActionsUtilKt {
    public static final boolean checkCommitsUnderProgress(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startRef, @NotNull String branchName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Intrinsics.checkParameterIsNotNull((Object)startRef, (String)"startRef");
        Intrinsics.checkParameterIsNotNull((Object)branchName, (String)"branchName");
        Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<Boolean, RuntimeException>(project, repositories, startRef, branchName){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $repositories;
            final /* synthetic */ String $startRef;
            final /* synthetic */ String $branchName;

            public final boolean compute() {
                return GitBranchActionsUtilKt.access$checkCommitsBetweenRefAndBranchName(this.$project, this.$repositories, this.$startRef, this.$branchName);
            }
            {
                this.$project = project;
                this.$repositories = list;
                this.$startRef = string;
                this.$branchName = string2;
            }
        }, GitBundle.message("branches.checking.existing.commits.process", new Object[0]), true, project);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ProgressManager.getInsta\u2026process\"), true, project)");
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkCommitsBetweenRefAndBranchName(Project project, List<? extends GitRepository> repositories, String startRef, String branchName) {
        boolean bl;
        Iterable $this$any$iv = repositories;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            GitRepository it = (GitRepository)element$iv;
            boolean bl2 = false;
            GitLocalBranch existingBranch = it.getBranches().findLocalBranch(branchName);
            if (existingBranch != null) {
                String string = existingBranch.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"existingBranch.name");
                if (GitBranchActionsUtilKt.hasCommits(project, it, startRef, string)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean hasCommits(Project project, GitRepository repository, String startRef, String endRef) {
        try {
            List<? extends TimedVcsCommit> list = GitHistoryUtils.collectTimedCommits(project, repository.getRoot(), startRef + ".." + endRef);
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"GitHistoryUtils.collectT\u2026ot, \"$startRef..$endRef\")");
            Collection collection = list;
            boolean bl = false;
            return !collection.isEmpty();
        }
        catch (VcsException ex) {
            L.INSTANCE.getLOG().warn("Couldn't collect commits in " + repository.getPresentableUrl() + " for " + startRef + ".." + endRef);
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkout(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @NotNull String name, boolean withRebase) {
        void reposWithLocalBranch;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Intrinsics.checkParameterIsNotNull((Object)startPoint, (String)"startPoint");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        GitBrancher brancher = GitBrancher.getInstance(project);
        Iterable $this$partition$iv = repositories;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            GitRepository it = (GitRepository)element$iv;
            boolean bl = false;
            if (it.getBranches().findLocalBranch(name) != null) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Object object = new Pair(first$iv, second$iv);
        List list = (List)object.component1();
        List reposWithoutLocalBranch = (List)object.component2();
        object = (Collection)reposWithLocalBranch;
        boolean bl = false;
        if (!object.isEmpty()) {
            if (withRebase) {
                brancher.rebase((List<? extends GitRepository>)reposWithLocalBranch, startPoint, name);
            } else {
                brancher.checkout(name, false, (List<? extends GitRepository>)reposWithLocalBranch, null);
            }
        }
        object = reposWithoutLocalBranch;
        bl = false;
        if (!object.isEmpty()) {
            brancher.checkoutNewBranchStartingFrom(name, startPoint, reposWithoutLocalBranch, null);
        }
    }

    public static final void checkoutOrReset(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @NotNull GitNewBranchOptions newBranchOptions) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Intrinsics.checkParameterIsNotNull((Object)startPoint, (String)"startPoint");
        Intrinsics.checkParameterIsNotNull((Object)newBranchOptions, (String)"newBranchOptions");
        if (repositories.isEmpty()) {
            return;
        }
        String name = newBranchOptions.getName();
        if (!newBranchOptions.shouldReset()) {
            GitBranchActionsUtilKt.checkout(project, repositories, startPoint, name, false);
        } else {
            boolean hasCommits = GitBranchActionsUtilKt.checkCommitsUnderProgress(project, repositories, startPoint, name);
            if (hasCommits) {
                VcsNotifier.getInstance((Project)project).notifyError(GitBundle.message("branches.checkout.failed.title", new Object[0]), GitBundle.message("branches.checkout.failed.description", name));
                return;
            }
            GitBrancher brancher = GitBrancher.getInstance(project);
            brancher.checkoutNewBranchStartingFrom(name, startPoint, true, repositories, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void createNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @NotNull GitNewBranchOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Intrinsics.checkParameterIsNotNull((Object)startPoint, (String)"startPoint");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        GitBrancher brancher = GitBrancher.getInstance(project);
        String name = options.getName();
        if (options.shouldReset()) {
            void currentBranchOfSameName;
            GitRepository it;
            boolean hasCommits = GitBranchActionsUtilKt.checkCommitsUnderProgress(project, repositories, startPoint, name);
            if (hasCommits) {
                VcsNotifier.getInstance((Project)project).notifyError(GitBundle.message("branches.creation.failed.title", new Object[0]), GitBundle.message("branches.checkout.failed.description", name));
                return;
            }
            Iterable $this$partition$iv22 = repositories;
            boolean $i$f$partition = false;
            ArrayList first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv22) {
                it = (GitRepository)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)it.getCurrentBranchName(), (Object)name)) {
                    first$iv.add(element$iv);
                    continue;
                }
                second$iv.add(element$iv);
            }
            Object object = new Pair(first$iv, second$iv);
            List list = (List)object.component1();
            List currentBranchOfDifferentName = (List)object.component2();
            object = (Collection)currentBranchOfSameName;
            boolean $this$partition$iv22 = false;
            if (!object.isEmpty()) {
                brancher.checkoutNewBranchStartingFrom(name, startPoint, true, (List<? extends GitRepository>)currentBranchOfSameName, null);
            }
            object = currentBranchOfDifferentName;
            $this$partition$iv22 = false;
            if (!object.isEmpty()) {
                Map map2;
                void $this$associateWith$iv;
                object = currentBranchOfDifferentName;
                String string = name;
                GitBrancher gitBrancher = brancher;
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    it = (GitRepository)element$iv$iv;
                    Object t = element$iv$iv;
                    map2 = result$iv;
                    boolean bl = false;
                    String string2 = startPoint;
                    map2.put(t, string2);
                }
                map2 = result$iv;
                gitBrancher.createBranch(string, map2, true);
            }
        } else {
            void $this$associateWith$iv;
            GitRepository it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable hasCommits = repositories;
            String string = name;
            GitBrancher gitBrancher = brancher;
            boolean $i$f$filter = false;
            void currentBranchOfDifferentName = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (GitRepository)element$iv$iv;
                boolean bl = false;
                if (!(it.getBranches().findLocalBranch(name) == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Object object = (List)destination$iv$iv;
            $this$filter$iv = (Iterable)object;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                it = (GitRepository)element$iv$iv;
                Object t = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                String string3 = startPoint;
                object.put(t, string3);
            }
            object = result$iv;
            gitBrancher.createBranch(string, (Map<GitRepository, String>)object);
        }
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title, @Nullable String initialName) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Intrinsics.checkParameterIsNotNull((Object)startPoint, (String)"startPoint");
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        GitNewBranchOptions gitNewBranchOptions = new GitNewBranchDialog(project, repositories, title, initialName, true, true, false, true, null, 256, null).showAndGetOptions();
        if (gitNewBranchOptions == null) {
            return;
        }
        GitNewBranchOptions options = gitNewBranchOptions;
        if (options.shouldCheckout()) {
            GitBranchActionsUtilKt.checkoutOrReset(project, repositories, startPoint, options);
        } else {
            GitBranchActionsUtilKt.createNewBranch(project, repositories, startPoint, options);
        }
    }

    public static /* synthetic */ void createOrCheckoutNewBranch$default(Project project, List list, String string, String string2, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            String string4 = GitBundle.message("branches.create.new.branch.dialog.title", new Object[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"GitBundle.message(\"branc\u2026new.branch.dialog.title\")");
            string2 = string4;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        GitBranchActionsUtilKt.createOrCheckoutNewBranch(project, list, string, string2, string3);
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, title, null, 16, null);
    }

    @JvmOverloads
    public static final void createOrCheckoutNewBranch(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull String startPoint) {
        GitBranchActionsUtilKt.createOrCheckoutNewBranch$default(project, repositories, startPoint, null, null, 24, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateBranches(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull List<String> localBranchNames) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
        Intrinsics.checkParameterIsNotNull(localBranchNames, (String)"localBranchNames");
        Iterable $this$associateWith$iv = repositories;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void it;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            Collection<GitBranchTrackInfo> collection = it.getBranchTrackInfos();
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"it.branchTrackInfos");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                GitBranchTrackInfo info = (GitBranchTrackInfo)element$iv$iv2;
                boolean bl2 = false;
                GitBranchTrackInfo gitBranchTrackInfo = info;
                Intrinsics.checkExpressionValueIsNotNull((Object)gitBranchTrackInfo, (String)"info");
                GitLocalBranch gitLocalBranch = gitBranchTrackInfo.getLocalBranch();
                Intrinsics.checkExpressionValueIsNotNull((Object)gitLocalBranch, (String)"info.localBranch");
                if (!localBranchNames.contains(gitLocalBranch.getName())) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv;
            map2.put(t, list);
        }
        Map repoToTrackingInfos = result$iv;
        if (repoToTrackingInfos.isEmpty()) {
            return;
        }
        GitVcs.runInBackground(new Task.Backgroundable(project, repoToTrackingInfos, localBranchNames, project, GitBundle.message("branches.updating.process", new Object[0]), true){
            private int successFetches;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map $repoToTrackingInfos;
            final /* synthetic */ List $localBranchNames;

            public final int getSuccessFetches() {
                return this.successFetches;
            }

            public final void setSuccessFetches(int n) {
                this.successFetches = n;
            }

            /*
             * WARNING - void declaration
             */
            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                GitFetchSupport gitFetchSupport = GitFetchSupport.fetchSupport(this.$project);
                Intrinsics.checkExpressionValueIsNotNull((Object)gitFetchSupport, (String)"GitFetchSupport.fetchSupport(project)");
                GitFetchSupport fetchSupport = gitFetchSupport;
                Object object = this.$repoToTrackingInfos;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<K, V> entry;
                    Map.Entry<K, V> entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    object = (GitRepository)entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    List trackingInfos = (List)entry2.getValue();
                    Iterator<E> iterator2 = trackingInfos.iterator();
                    while (iterator2.hasNext()) {
                        GitFetchResult fetchResult;
                        String localBranchName;
                        String remoteBranchName;
                        void repo;
                        GitBranchTrackInfo trackingInfo;
                        GitBranchTrackInfo gitBranchTrackInfo = trackingInfo = (GitBranchTrackInfo)iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitBranchTrackInfo, (String)"trackingInfo");
                        GitLocalBranch gitLocalBranch = gitBranchTrackInfo.getLocalBranch();
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitLocalBranch, (String)"trackingInfo.localBranch");
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitLocalBranch.getName(), (String)"trackingInfo.localBranch.name");
                        GitRemoteBranch gitRemoteBranch = trackingInfo.getRemoteBranch();
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitRemoteBranch, (String)"trackingInfo.remoteBranch");
                        Intrinsics.checkExpressionValueIsNotNull((Object)gitRemoteBranch.getNameForRemoteOperations(), (String)"trackingInfo.remoteBranch.nameForRemoteOperations");
                        Intrinsics.checkExpressionValueIsNotNull((Object)fetchSupport.fetch((GitRepository)repo, trackingInfo.getRemote(), remoteBranchName + ':' + localBranchName), (String)"fetchSupport.fetch(repo,\u2026chName:$localBranchName\")");
                        try {
                            fetchResult.throwExceptionIfFailed();
                            ++this.successFetches;
                        }
                        catch (VcsException ignored) {
                            fetchResult.showNotificationIfFailed(GitBundle.message("branches.update.failed", new Object[0]));
                        }
                    }
                }
            }

            public void onSuccess() {
                if (this.successFetches > 0) {
                    VcsNotifier.getInstance((Project)this.myProject).notifySuccess(GitBundle.message("branches.selected.branches.updated.title", this.$localBranchNames.size()));
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$repoToTrackingInfos = $captured_local_variable$1;
                this.$localBranchNames = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isTrackingInfosExist(@NotNull List<String> branchNames, @NotNull List<? extends GitRepository> repositories) {
        boolean bl;
        block8: {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(branchNames, (String)"branchNames");
            Intrinsics.checkParameterIsNotNull(repositories, (String)"repositories");
            Iterable $this$flatMap$iv = repositories;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                GitRepository p1 = (GitRepository)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = p1.getBranchTrackInfos();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$any$iv = (List)destination$iv$iv;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    block7: {
                        GitBranchTrackInfo trackingBranchInfo = (GitBranchTrackInfo)element$iv;
                        boolean bl4 = false;
                        Iterable $this$any$iv2 = branchNames;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String branchName = (String)element$iv2;
                                boolean bl5 = false;
                                GitBranchTrackInfo gitBranchTrackInfo = trackingBranchInfo;
                                Intrinsics.checkExpressionValueIsNotNull((Object)gitBranchTrackInfo, (String)"trackingBranchInfo");
                                GitLocalBranch gitLocalBranch = gitBranchTrackInfo.getLocalBranch();
                                Intrinsics.checkExpressionValueIsNotNull((Object)gitLocalBranch, (String)"trackingBranchInfo.localBranch");
                                if (!Intrinsics.areEqual((Object)branchName, (Object)gitLocalBranch.getName())) continue;
                                bl3 = true;
                                break block7;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean hasRemotes(@NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Collection<GitRepository> collection = GitUtil.getRepositories(project);
            Intrinsics.checkExpressionValueIsNotNull(collection, (String)"GitUtil.getRepositories(project)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository repository = (GitRepository)element$iv;
                    boolean bl2 = false;
                    GitRepository gitRepository = repository;
                    Intrinsics.checkExpressionValueIsNotNull((Object)gitRepository, (String)"repository");
                    if (!(!gitRepository.getRemotes().isEmpty())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$checkCommitsBetweenRefAndBranchName(Project project, List repositories, String startRef, String branchName) {
        return GitBranchActionsUtilKt.checkCommitsBetweenRefAndBranchName(project, repositories, startRef, branchName);
    }
}

