/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesPanel
extends SimpleSchemesPanel<EditorColorsScheme>
implements SkipSelfSearchComponent {
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher;
    private boolean myListLoaded;

    public SchemesPanel(@NotNull ColorAndFontOptions options2) {
        if (options2 == null) {
            SchemesPanel.$$$reportNull$$$0(0);
        }
        this(options2, 8);
    }

    SchemesPanel(@NotNull ColorAndFontOptions options2, int vGap) {
        if (options2 == null) {
            SchemesPanel.$$$reportNull$$$0(1);
        }
        super(vGap);
        this.myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
        this.myOptions = options2;
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    void resetSchemesCombo(Object source) {
        if (this != source) {
            this.setListLoaded(false);
            EditorColorsScheme selectedSchemeBackup = this.myOptions.getSelectedScheme();
            this.resetSchemes(this.myOptions.getOrderedSchemes());
            this.selectScheme(selectedSchemeBackup);
            this.setListLoaded(true);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    public void addListener(@NotNull ColorAndFontSettingsListener listener2) {
        if (listener2 == null) {
            SchemesPanel.$$$reportNull$$$0(2);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    @NotNull
    protected AbstractSchemeActions<EditorColorsScheme> createSchemeActions() {
        return new ColorSchemeActions(this){

            @Override
            @NotNull
            protected ColorAndFontOptions getOptions() {
                ColorAndFontOptions colorAndFontOptions = SchemesPanel.this.myOptions;
                if (colorAndFontOptions == null) {
                    1.$$$reportNull$$$0(0);
                }
                return colorAndFontOptions;
            }

            @Override
            protected void onSchemeChanged(@Nullable EditorColorsScheme scheme) {
                if (scheme != null) {
                    SchemesPanel.this.myOptions.selectScheme(scheme.getName());
                    if (SchemesPanel.this.areSchemesLoaded()) {
                        ((ColorAndFontSettingsListener)SchemesPanel.this.myDispatcher.getMulticaster()).schemeChanged(SchemesPanel.this);
                    }
                }
            }

            @Override
            protected void renameScheme(@NotNull EditorColorsScheme scheme, @NotNull String newName) {
                if (scheme == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (newName == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (SchemesPanel.this.myOptions.saveSchemeAs(scheme, newName)) {
                    SchemesPanel.this.myOptions.removeScheme(scheme);
                    SchemesPanel.this.myOptions.selectScheme(newName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/colors/SchemesPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOptions";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/colors/SchemesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "renameScheme";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<EditorColorsScheme> getModel() {
        ColorAndFontOptions colorAndFontOptions = this.myOptions;
        if (colorAndFontOptions == null) {
            SchemesPanel.$$$reportNull$$$0(3);
        }
        return colorAndFontOptions;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/colors/SchemesPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/colors/SchemesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

