/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferable;
import com.intellij.ide.PasteProvider;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTextInsertHandler;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.actions.PasteAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Producer;
import com.intellij.util.text.CharArrayUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasteHandler
extends EditorActionHandler
implements EditorTextInsertHandler {
    private static final Logger LOG = Logger.getInstance(PasteHandler.class);
    private static final ExtensionPointName<PasteProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.customPasteProvider");
    private static final int LINE_LIMIT_FOR_BULK_CHANGE = 5000;
    private final EditorActionHandler myOriginalHandler;

    public PasteHandler(EditorActionHandler originalAction) {
        this.myOriginalHandler = originalAction;
    }

    public void doExecute(@NotNull Editor editor, Caret caret, DataContext dataContext) {
        if (editor == null) {
            PasteHandler.$$$reportNull$$$0(0);
        }
        assert (caret == null) : "Invocation of 'paste' operation for specific caret is not supported";
        this.execute(editor, dataContext, null);
    }

    public void execute(Editor editor, DataContext dataContext, @Nullable Producer<Transferable> producer) {
        Transferable transferable = EditorModificationUtil.getContentsToPasteToEditor(producer);
        if (transferable == null) {
            return;
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        Document document = editor.getDocument();
        if (!EditorModificationUtil.requestWriting((Editor)editor)) {
            return;
        }
        DataContext context = dataId -> PasteAction.TRANSFERABLE_PROVIDER.is(dataId) ? () -> transferable : dataContext.getData(dataId);
        Project project = editor.getProject();
        if (project == null || editor.isColumnMode() || editor.getCaretModel().getCaretCount() > 1) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, context);
            }
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (file2 == null) {
            if (this.myOriginalHandler != null) {
                this.myOriginalHandler.execute(editor, null, context);
            }
            return;
        }
        DumbService.getInstance((Project)project).runWithAlternativeResolveEnabled(() -> {
            document.startGuardedBlockChecking();
            try {
                for (PasteProvider provider : EP_NAME.getExtensionList()) {
                    if (!provider.isPasteEnabled(context)) continue;
                    provider.performPaste(context);
                    return;
                }
                PasteHandler.doPaste(editor, project, file2, document, transferable);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
            }
            finally {
                document.stopGuardedBlockChecking();
            }
        });
    }

    private static void doPaste(Editor editor, Project project, PsiFile file2, Document document, @NotNull Transferable content2) {
        if (content2 == null) {
            PasteHandler.$$$reportNull$$$0(1);
        }
        CopyPasteManager.getInstance().stopKillRings();
        String text = null;
        try {
            text = (String)content2.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception e) {
            editor.getComponent().getToolkit().beep();
        }
        if (text == null) {
            return;
        }
        int textLength = text.length();
        if (BasePasteHandler.isContentTooLarge(textLength)) {
            BasePasteHandler.contentLengthLimitExceededMessage(textLength);
            return;
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        HashMap extraData = new HashMap();
        ArrayList allValues = new ArrayList();
        for (CopyPastePostProcessor processor2 : CopyPastePostProcessor.EP_NAME.getExtensionList()) {
            List data2 = processor2.extractTransferableData(content2);
            if (data2.isEmpty()) continue;
            extraData.put(processor2, data2);
            allValues.addAll(data2);
        }
        text = TextBlockTransferable.convertLineSeparators(editor, text, allValues);
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        int col = caretModel.getLogicalPosition().column;
        int caretOffset = caretModel.getOffset();
        int blockIndentAnchorColumn = selectionModel.hasSelection() && caretOffset >= selectionModel.getSelectionStart() ? editor.offsetToLogicalPosition((int)selectionModel.getSelectionStart()).column : col;
        RawText rawText = RawText.fromTransferable((Transferable)content2);
        String newText = text;
        for (CopyPastePreProcessor preProcessor : CopyPastePreProcessor.EP_NAME.getExtensionList()) {
            newText = preProcessor.preprocessOnPaste(project, file2, editor, newText, rawText);
        }
        int indentOptions = text.equals(newText) ? settings.REFORMAT_ON_PASTE : 4;
        text = newText;
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) == null && indentOptions != 1) {
            indentOptions = 2;
        }
        String _text = text;
        ApplicationManager.getApplication().runWriteAction(() -> {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)_text, (boolean)false, (boolean)true);
            if (!project.isDisposed()) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)project)).addDocumentAsAffected(editor.getDocument());
            }
        });
        int length = text.length();
        int offset = caretModel.getOffset() - length;
        if (offset < 0) {
            length += offset;
            offset = 0;
        }
        RangeMarker bounds2 = document.createRangeMarker(offset, offset + length);
        caretModel.moveToOffset(bounds2.getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        selectionModel.removeSelection();
        Ref indented = new Ref((Object)Boolean.FALSE);
        for (Map.Entry e : extraData.entrySet()) {
            ((CopyPastePostProcessor)e.getKey()).processTransferableData(project, editor, bounds2, caretOffset, (Ref<Boolean>)indented, (List)e.getValue());
        }
        boolean pastedTextContainsWhiteSpacesOnly = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)bounds2.getStartOffset(), (String)" \n\t") >= bounds2.getEndOffset();
        VirtualFile virtualFile = file2.getVirtualFile();
        if (!(pastedTextContainsWhiteSpacesOnly || virtualFile != null && SingleRootFileViewProvider.isTooLargeForIntelligence(virtualFile))) {
            int indentOptions1 = indentOptions;
            ApplicationManager.getApplication().runWriteAction(() -> {
                PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
                switch (indentOptions1) {
                    case 2: {
                        if (((Boolean)indented.get()).booleanValue()) break;
                        PasteHandler.indentBlock(project, editor, bounds2.getStartOffset(), bounds2.getEndOffset(), blockIndentAnchorColumn);
                        break;
                    }
                    case 3: {
                        if (((Boolean)indented.get()).booleanValue()) break;
                        PasteHandler.indentEachLine(project, editor, bounds2.getStartOffset(), bounds2.getEndOffset());
                        break;
                    }
                    case 4: {
                        PasteHandler.indentEachLine(project, editor, bounds2.getStartOffset(), bounds2.getEndOffset());
                        PasteHandler.reformatBlock(project, editor, bounds2.getStartOffset(), bounds2.getEndOffset());
                    }
                }
            });
        }
        if (bounds2.isValid()) {
            caretModel.moveToOffset(bounds2.getEndOffset());
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            selectionModel.removeSelection();
            editor.putUserData(EditorEx.LAST_PASTED_REGION, (Object)TextRange.create((Segment)bounds2));
        }
    }

    @VisibleForTesting
    public static void indentBlock(Project project, Editor editor, int startOffset, int endOffset, int originalCaretCol) {
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitAllDocuments();
        Document document = editor.getDocument();
        PsiFile file2 = documentManager.getPsiFile(document);
        if (file2 == null) {
            return;
        }
        if (LanguageFormatting.INSTANCE.forContext((PsiElement)file2) != null) {
            PasteHandler.indentBlockWithFormatter(project, document, startOffset, endOffset, file2);
        } else {
            PasteHandler.indentPlainTextBlock(document, startOffset, endOffset, originalCaretCol);
        }
    }

    private static void indentEachLine(Project project, Editor editor, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        CharSequence text = editor.getDocument().getCharsSequence();
        if (startOffset > 0 && endOffset > startOffset + 1 && text.charAt(endOffset - 1) == '\n' && text.charAt(startOffset - 1) == '\n') {
            --endOffset;
        }
        try {
            codeStyleManager.adjustLineIndent(file2, new TextRange(startOffset, endOffset));
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void reformatBlock(Project project, Editor editor, int startOffset, int endOffset) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        try {
            CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file2, startOffset, endOffset, true);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void indentPlainTextBlock(Document document, int startOffset, int endOffset, int indentLevel) {
        int endLine;
        CharSequence chars = document.getCharsSequence();
        int spaceEnd = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t");
        int startLine = document.getLineNumber(startOffset);
        if (spaceEnd > endOffset || indentLevel <= 0 || startLine >= document.getLineCount() - 1 || chars.charAt(spaceEnd) == '\n') {
            return;
        }
        for (endLine = startLine + 1; endLine < document.getLineCount() && document.getLineStartOffset(endLine) < endOffset; ++endLine) {
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indentLevel);
        PasteHandler.indentLines(document, startLine + 1, endLine - 1, indentString);
    }

    private static void indentBlockWithFormatter(Project project, Document document, int startOffset, int endOffset, PsiFile file2) {
        int lastLine;
        CharSequence chars = document.getCharsSequence();
        int firstLine = document.getLineNumber(startOffset);
        int firstLineStart = document.getLineStartOffset(firstLine);
        boolean saveLastLineIndent = false;
        for (int i2 = endOffset - 1; i2 >= startOffset; --i2) {
            char c = chars.charAt(i2);
            if (c == '\n') {
                saveLastLineIndent = true;
                break;
            }
            if (c != ' ' && c != '\t') break;
        }
        if (saveLastLineIndent) {
            int indentToKeepEndOffset;
            int i3;
            lastLine = document.getLineNumber(endOffset) - 1;
            int start2 = document.getLineStartOffset(lastLine + 1);
            if (start2 < endOffset && (i3 = CharArrayUtil.shiftForward((CharSequence)chars, (int)start2, (String)" \t")) > start2) {
                i3 = Math.min(i3, endOffset);
                document.deleteString(start2, i3);
            }
            if ((indentToKeepEndOffset = Math.min(startOffset, CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t"))) > firstLineStart) {
                document.insertString(start2, chars.subSequence(firstLineStart, indentToKeepEndOffset));
            }
        } else {
            lastLine = document.getLineNumber(endOffset);
        }
        int i4 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(startOffset - 1), (String)" \t");
        if (chars.charAt(startOffset) != '\n' && i4 > 0 && chars.charAt(i4) != '\n') {
            int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (firstNonWsOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, firstNonWsOffset);
                PasteHandler.indentLines(document, firstLine + 1, lastLine, toInsert);
            }
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (file2 == null) {
            return;
        }
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        int j = CharArrayUtil.shiftForward((CharSequence)chars, (int)startOffset, (String)" \t\n");
        if (j >= endOffset) {
            return;
        }
        int anchorLine = document.getLineNumber(j);
        int anchorLineStart = document.getLineStartOffset(anchorLine);
        codeStyleManager.adjustLineIndent(file2, j);
        if (anchorLine == firstLine && j == startOffset) {
            int indentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)firstLineStart, (String)" \t");
            if (indentOffset > firstLineStart) {
                CharSequence toInsert = chars.subSequence(firstLineStart, indentOffset);
                PasteHandler.indentLines(document, firstLine + 1, lastLine, toInsert);
            }
            return;
        }
        int firstNonWsOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)anchorLineStart, (String)" \t");
        int diff = firstNonWsOffset - j;
        if (diff == 0) {
            return;
        }
        if (diff > 0) {
            CharSequence toInsert = chars.subSequence(anchorLineStart, anchorLineStart + diff);
            PasteHandler.indentLines(document, anchorLine + 1, lastLine, toInsert);
            return;
        }
        if (anchorLine == firstLine && -diff == startOffset - firstLineStart) {
            return;
        }
        if (anchorLine != firstLine || -diff > startOffset - firstLineStart) {
            int desiredSymbolsToRemove = anchorLine == firstLine ? -diff - (startOffset - firstLineStart) : -diff;
            Runnable unindentTask = () -> {
                for (int line = anchorLine + 1; line <= lastLine; ++line) {
                    int currentLineStart = document.getLineStartOffset(line);
                    int currentLineIndentOffset = CharArrayUtil.shiftForward((CharSequence)chars, (int)currentLineStart, (String)" \t");
                    int symbolsToRemove = Math.min(currentLineIndentOffset - currentLineStart, desiredSymbolsToRemove);
                    if (symbolsToRemove <= 0) continue;
                    document.deleteString(currentLineStart, currentLineStart + symbolsToRemove);
                }
            };
            DocumentUtil.executeInBulk(document, lastLine - anchorLine > 5000, unindentTask);
        } else {
            CharSequence toInsert = chars.subSequence(anchorLineStart, diff + startOffset);
            PasteHandler.indentLines(document, anchorLine + 1, lastLine, toInsert);
        }
    }

    private static void indentLines(@NotNull Document document, int startLine, int endLine, @NotNull CharSequence indentString) {
        if (document == null) {
            PasteHandler.$$$reportNull$$$0(2);
        }
        if (indentString == null) {
            PasteHandler.$$$reportNull$$$0(3);
        }
        Runnable indentTask = () -> {
            for (int line = startLine; line <= endLine; ++line) {
                int lineStartOffset = document.getLineStartOffset(line);
                document.insertString(lineStartOffset, indentString);
            }
        };
        DocumentUtil.executeInBulk(document, endLine - startLine > 5000, indentTask);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentString";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/PasteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doExecute";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doPaste";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "indentLines";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

