/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic.logging;

import com.intellij.DynamicBundle;
import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.diagnostic.logging.EditLogPatternDialog;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.SmartList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import gnu.trove.THashMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;

public class LogConfigurationPanel<T extends RunConfigurationBase>
extends SettingsEditor<T> {
    private final TableView<LogFileOptions> myFilesTable;
    private final ListTableModel<LogFileOptions> myModel;
    private JPanel myWholePanel;
    private JPanel myScrollPanel;
    private JBCheckBox myRedirectOutputCb;
    private TextFieldWithBrowseButton myOutputFile;
    private JCheckBox myShowConsoleOnStdOutCb;
    private JCheckBox myShowConsoleOnStdErrCb;
    private final Map<LogFileOptions, PredefinedLogFile> myLog2Predefined;
    private final List<PredefinedLogFile> myUnresolvedPredefined;

    public LogConfigurationPanel() {
        this.$$$setupUI$$$();
        this.myLog2Predefined = new THashMap();
        this.myUnresolvedPredefined = new SmartList();
        MyIsActiveColumnInfo IS_SHOW = new MyIsActiveColumnInfo();
        MyLogFileColumnInfo FILE = new MyLogFileColumnInfo();
        MyIsSkipColumnInfo IS_SKIP_CONTENT = new MyIsSkipColumnInfo();
        this.myModel = new ListTableModel(new ColumnInfo[]{IS_SHOW, FILE, IS_SKIP_CONTENT});
        this.myFilesTable = new TableView(this.myModel);
        this.myFilesTable.getEmptyText().setText(DiagnosticBundle.message("log.monitor.no.files", new Object[0]));
        JTableHeader tableHeader = this.myFilesTable.getTableHeader();
        FontMetrics fontMetrics = tableHeader.getFontMetrics(tableHeader.getFont());
        int preferredWidth = fontMetrics.stringWidth(IS_SHOW.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 0);
        preferredWidth = fontMetrics.stringWidth(IS_SKIP_CONTENT.getName()) + 20;
        this.setUpColumnWidth(tableHeader, preferredWidth, 2);
        this.myFilesTable.setColumnSelectionAllowed(false);
        this.myFilesTable.setShowGrid(false);
        this.myFilesTable.setDragEnabled(false);
        this.myFilesTable.setShowHorizontalLines(false);
        this.myFilesTable.setShowVerticalLines(false);
        this.myFilesTable.setIntercellSpacing(new Dimension(0, 0));
        this.myScrollPanel.add((Component)ToolbarDecorator.createDecorator(this.myFilesTable).setAddAction(button2 -> {
            ArrayList<LogFileOptions> newList = new ArrayList<LogFileOptions>(this.myModel.getItems());
            LogFileOptions newOptions = new LogFileOptions("", "", true);
            if (LogConfigurationPanel.showEditorDialog(newOptions)) {
                newList.add(newOptions);
                this.myModel.setItems(newList);
                int index = this.myModel.getRowCount() - 1;
                this.myModel.fireTableRowsInserted(index, index);
                this.myFilesTable.setRowSelectionInterval(index, index);
            }
        }).setRemoveAction(button2 -> {
            int i2;
            TableUtil.stopEditing(this.myFilesTable);
            int[] selected2 = this.myFilesTable.getSelectedRows();
            if (selected2.length == 0) {
                return;
            }
            for (i2 = selected2.length - 1; i2 >= 0; --i2) {
                this.myModel.removeRow(selected2[i2]);
            }
            for (i2 = selected2.length - 1; i2 >= 0; --i2) {
                int idx = selected2[i2];
                this.myModel.fireTableRowsDeleted(idx, idx);
            }
            int selection = selected2[0];
            if (selection >= this.myModel.getRowCount()) {
                selection = this.myModel.getRowCount() - 1;
            }
            if (selection >= 0) {
                this.myFilesTable.setRowSelectionInterval(selection, selection);
            }
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.myFilesTable, true));
        }).setEditAction(button2 -> {
            int selectedRow = this.myFilesTable.getSelectedRow();
            LogConfigurationPanel.showEditorDialog((LogFileOptions)this.myFilesTable.getSelectedObject());
            this.myModel.fireTableDataChanged();
            this.myFilesTable.setRowSelectionInterval(selectedRow, selectedRow);
        }).setRemoveActionUpdater(e -> this.myFilesTable.getSelectedRowCount() >= 1 && !this.myLog2Predefined.containsKey(this.myFilesTable.getSelectedObject())).setEditActionUpdater(e -> this.myFilesTable.getSelectedRowCount() >= 1 && !this.myLog2Predefined.containsKey(this.myFilesTable.getSelectedObject()) && this.myFilesTable.getSelectedObject() != null).disableUpDownActions().createPanel(), "Center");
        this.myWholePanel.setPreferredSize(new Dimension(-1, 150));
        this.myOutputFile.addBrowseFolderListener(ExecutionBundle.message((String)"choose.file.to.save.console.output", (Object[])new Object[0]), ExecutionBundle.message((String)"console.output.would.be.saved.to.the.specified.file", (Object[])new Object[0]), null, FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myRedirectOutputCb.addActionListener(e -> this.myOutputFile.setEnabled(this.myRedirectOutputCb.isSelected()));
    }

    private void setUpColumnWidth(JTableHeader tableHeader, int preferredWidth, int columnIdx) {
        this.myFilesTable.getColumnModel().getColumn(columnIdx).setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        TableColumn tableColumn = tableHeader.getColumnModel().getColumn(columnIdx);
        tableColumn.setWidth(preferredWidth);
        tableColumn.setPreferredWidth(preferredWidth);
        tableColumn.setMinWidth(preferredWidth);
        tableColumn.setMaxWidth(preferredWidth);
    }

    public void refreshPredefinedLogFiles(RunConfigurationBase configurationBase) {
        PredefinedLogFile[] unresolved;
        List items = this.myModel.getItems();
        ArrayList<LogFileOptions> newItems = new ArrayList<LogFileOptions>();
        boolean changed2 = false;
        for (LogFileOptions item : items) {
            PredefinedLogFile predefined = this.myLog2Predefined.get(item);
            if (predefined != null) {
                LogFileOptions options2 = configurationBase.getOptionsForPredefinedLogFile(predefined);
                if (LogFileOptions.areEqual((LogFileOptions)item, (LogFileOptions)options2)) {
                    newItems.add(item);
                    continue;
                }
                changed2 = true;
                this.myLog2Predefined.remove(item);
                if (options2 == null) {
                    this.myUnresolvedPredefined.add(predefined);
                    continue;
                }
                newItems.add(options2);
                this.myLog2Predefined.put(options2, predefined);
                continue;
            }
            newItems.add(item);
        }
        for (PredefinedLogFile logFile : unresolved = this.myUnresolvedPredefined.toArray(new PredefinedLogFile[0])) {
            LogFileOptions options3 = configurationBase.getOptionsForPredefinedLogFile(logFile);
            if (options3 == null) continue;
            changed2 = true;
            this.myUnresolvedPredefined.remove(logFile);
            this.myLog2Predefined.put(options3, logFile);
            newItems.add(options3);
        }
        if (changed2) {
            this.myModel.setItems(newItems);
        }
    }

    protected void resetEditorFrom(@NotNull RunConfigurationBase configuration) {
        if (configuration == null) {
            LogConfigurationPanel.$$$reportNull$$$0(0);
        }
        ArrayList<LogFileOptions> list2 = new ArrayList<LogFileOptions>();
        List logFiles = configuration.getLogFiles();
        for (Object setting : logFiles) {
            list2.add(new LogFileOptions(setting.getName(), setting.getPathPattern(), setting.isEnabled(), setting.isSkipContent(), setting.isShowAll()));
        }
        this.myLog2Predefined.clear();
        this.myUnresolvedPredefined.clear();
        List predefinedLogFiles = configuration.getPredefinedLogFiles();
        for (PredefinedLogFile predefinedLogFile : predefinedLogFiles) {
            PredefinedLogFile logFile = new PredefinedLogFile();
            logFile.copyFrom((BaseState)predefinedLogFile);
            LogFileOptions options2 = configuration.getOptionsForPredefinedLogFile(logFile);
            if (options2 != null) {
                this.myLog2Predefined.put(options2, logFile);
                list2.add(options2);
                continue;
            }
            this.myUnresolvedPredefined.add(logFile);
        }
        this.myModel.setItems(list2);
        boolean redirectOutputToFile = configuration.isSaveOutputToFile();
        this.myRedirectOutputCb.setSelected(redirectOutputToFile);
        String fileOutputPath = configuration.getOutputFilePath();
        this.myOutputFile.setText(fileOutputPath != null ? FileUtil.toSystemDependentName((String)fileOutputPath) : "");
        this.myOutputFile.setEnabled(redirectOutputToFile);
        this.myShowConsoleOnStdOutCb.setSelected(configuration.isShowConsoleOnStdOut());
        this.myShowConsoleOnStdErrCb.setSelected(configuration.isShowConsoleOnStdErr());
    }

    protected void applyEditorTo(@NotNull RunConfigurationBase configuration) throws ConfigurationException {
        if (configuration == null) {
            LogConfigurationPanel.$$$reportNull$$$0(1);
        }
        this.myFilesTable.stopEditing();
        configuration.removeAllLogFiles();
        configuration.removeAllPredefinedLogFiles();
        for (int i2 = 0; i2 < this.myModel.getRowCount(); ++i2) {
            LogFileOptions options2 = (LogFileOptions)this.myModel.getValueAt(i2, 1);
            if (Objects.equals(options2.getPathPattern(), "")) continue;
            Boolean checked = (Boolean)this.myModel.getValueAt(i2, 0);
            Boolean skipped = (Boolean)this.myModel.getValueAt(i2, 2);
            PredefinedLogFile predefined = this.myLog2Predefined.get(options2);
            if (predefined != null) {
                PredefinedLogFile file2 = new PredefinedLogFile();
                file2.setId(predefined.getId());
                file2.setEnabled(options2.isEnabled());
                configuration.addPredefinedLogFile(file2);
                continue;
            }
            configuration.addLogFile(options2.getPathPattern(), options2.getName(), checked.booleanValue(), skipped.booleanValue(), options2.isShowAll());
        }
        for (PredefinedLogFile logFile : this.myUnresolvedPredefined) {
            configuration.addPredefinedLogFile(logFile);
        }
        String text = this.myOutputFile.getText();
        configuration.setFileOutputPath(StringUtil.isEmpty((String)text) ? null : FileUtil.toSystemIndependentName((String)text));
        configuration.setSaveOutputToFile(this.myRedirectOutputCb.isSelected());
        configuration.setShowConsoleOnStdOut(this.myShowConsoleOnStdOutCb.isSelected());
        configuration.setShowConsoleOnStdErr(this.myShowConsoleOnStdErrCb.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel2 = this.myWholePanel;
        if (jPanel2 == null) {
            LogConfigurationPanel.$$$reportNull$$$0(2);
        }
        return jPanel2;
    }

    private static boolean showEditorDialog(@NotNull LogFileOptions options2) {
        if (options2 == null) {
            LogConfigurationPanel.$$$reportNull$$$0(3);
        }
        EditLogPatternDialog dialog2 = new EditLogPatternDialog();
        dialog2.init(options2.getName(), options2.getPathPattern(), options2.isShowAll());
        if (dialog2.showAndGet()) {
            options2.setName(dialog2.getName());
            options2.setPathPattern(dialog2.getLogPattern());
            options2.setShowAll(dialog2.isShowAllFiles());
            return true;
        }
        return false;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JBCheckBox jBCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myWholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, 10, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/DiagnosticBundle", LogConfigurationPanel.class).getString("log.monitor.group"), (int)0, (int)0, null, null));
        this.myScrollPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, new Dimension(-1, 150), null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myRedirectOutputCb = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", LogConfigurationPanel.class).getString("save.output.console.to.file"));
        jPanel4.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myOutputFile = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myShowConsoleOnStdOutCb = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/ExecutionBundle", LogConfigurationPanel.class).getString("logs.show.console.on.stdout"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShowConsoleOnStdErrCb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", LogConfigurationPanel.class).getString("logs.show.console.on.stderr"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagnostic/logging/LogConfigurationPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagnostic/logging/LogConfigurationPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showEditorDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LogFileCellEditor
    extends AbstractTableCellEditor {
        private final CellEditorComponentWithBrowseButton<JTextField> myComponent;
        private final LogFileOptions myLogFileOptions;

        LogFileCellEditor(LogFileOptions options2) {
            this.myLogFileOptions = options2;
            this.myComponent = new CellEditorComponentWithBrowseButton(new TextFieldWithBrowseButton(), (TableCellEditor)((Object)this));
            this.getChildComponent().setEditable(false);
            this.getChildComponent().setBorder(null);
            this.myComponent.getComponentWithButton().getButton().addActionListener(e -> {
                LogConfigurationPanel.showEditorDialog(this.myLogFileOptions);
                JTextField textField2 = this.getChildComponent();
                textField2.setText(this.myLogFileOptions.getName());
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)textField2, true));
                LogConfigurationPanel.this.myModel.fireTableDataChanged();
            });
        }

        public Object getCellEditorValue() {
            return this.myLogFileOptions;
        }

        private JTextField getChildComponent() {
            return this.myComponent.getChildComponent();
        }

        public Component getTableCellEditorComponent(JTable table, Object value2, boolean isSelected, int row, int column) {
            this.getChildComponent().setText(((LogFileOptions)value2).getName());
            return this.myComponent;
        }
    }

    private class MyIsSkipColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsSkipColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.skipped.column", new Object[0]));
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions element2) {
            return element2.isSkipContent();
        }

        public boolean isCellEditable(LogFileOptions element2) {
            return !LogConfigurationPanel.this.myLog2Predefined.containsKey(element2);
        }

        public void setValue(LogFileOptions element2, Boolean skipped) {
            element2.setSkipContent(skipped.booleanValue());
        }
    }

    private class MyIsActiveColumnInfo
    extends ColumnInfo<LogFileOptions, Boolean> {
        protected MyIsActiveColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.is.active.column", new Object[0]));
        }

        public Class getColumnClass() {
            return Boolean.class;
        }

        public Boolean valueOf(LogFileOptions object) {
            return object.isEnabled();
        }

        public boolean isCellEditable(LogFileOptions element2) {
            return true;
        }

        public void setValue(LogFileOptions element2, Boolean checked) {
            PredefinedLogFile predefinedLogFile = (PredefinedLogFile)LogConfigurationPanel.this.myLog2Predefined.get(element2);
            if (predefinedLogFile != null) {
                predefinedLogFile.setEnabled(checked.booleanValue());
            }
            element2.setEnabled(checked.booleanValue());
        }
    }

    private class MyLogFileColumnInfo
    extends ColumnInfo<LogFileOptions, LogFileOptions> {
        MyLogFileColumnInfo() {
            super(DiagnosticBundle.message("log.monitor.log.file.column", new Object[0]));
        }

        public TableCellRenderer getRenderer(LogFileOptions p0) {
            return new DefaultTableCellRenderer(){

                @Override
                @NotNull
                public Component getTableCellRendererComponent(@NotNull JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (table == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Component renderer = super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                    this.setText(((LogFileOptions)value2).getName());
                    this.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                    this.setBorder(null);
                    Component component2 = renderer;
                    if (component2 == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return component2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "table";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/diagnostic/logging/LogConfigurationPanel$MyLogFileColumnInfo$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/diagnostic/logging/LogConfigurationPanel$MyLogFileColumnInfo$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getTableCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getTableCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }

        public LogFileOptions valueOf(LogFileOptions object) {
            return object;
        }

        public TableCellEditor getEditor(LogFileOptions item) {
            return new LogFileCellEditor(item);
        }

        public void setValue(LogFileOptions o, LogFileOptions aValue) {
            if (aValue != null) {
                if (!o.getName().equals(aValue.getName()) || !o.getPathPattern().equals(aValue.getPathPattern()) || o.isShowAll() != aValue.isShowAll()) {
                    LogConfigurationPanel.this.myLog2Predefined.remove(o);
                }
                o.setName(aValue.getName());
                o.setShowAll(aValue.isShowAll());
                o.setPathPattern(aValue.getPathPattern());
            }
        }

        public boolean isCellEditable(LogFileOptions o) {
            return !LogConfigurationPanel.this.myLog2Predefined.containsKey(o);
        }
    }
}

