/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.ui.components.panels.Wrapper;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;

public class InvisibleWrapper
extends Wrapper {
    private final ComponentListener myListener = new MyVisibilityListener();

    public void setContent(JComponent wrapped) {
        if (this.getTargetComponent() != this) {
            this.getTargetComponent().removeComponentListener(this.myListener);
        }
        super.setContent(wrapped);
        if (this.getTargetComponent() != this) {
            this.getTargetComponent().addComponentListener(this.myListener);
        }
        this.syncVisibility();
    }

    private void syncVisibility() {
        boolean isVisible;
        JComponent target2 = this.getTargetComponent();
        boolean bl = isVisible = target2 != this && target2.isVisible();
        if (this.isVisible() != isVisible) {
            this.setVisible(isVisible);
            this.validate();
        }
    }

    private class MyVisibilityListener
    extends ComponentAdapter {
        private MyVisibilityListener() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            InvisibleWrapper.this.syncVisibility();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            InvisibleWrapper.this.syncVisibility();
        }
    }
}

