/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindUsagesHandlerBase {
    @NotNull
    protected final PsiElement myPsiElement;

    public FindUsagesHandlerBase(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(0);
        }
        this.myPsiElement = psiElement;
    }

    @NotNull
    public final PsiElement getPsiElement() {
        PsiElement psiElement = this.myPsiElement;
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(1);
        }
        return psiElement;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.myPsiElement.getProject();
        if (project == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(2);
        }
        return project;
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        PsiElement[] psiElementArray = new PsiElement[]{this.myPsiElement};
        if (psiElementArray == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(3);
        }
        return psiElementArray;
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        if (PsiElement.EMPTY_ARRAY == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(4);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions() {
        FindUsagesOptions findUsagesOptions = this.getFindUsagesOptions(null);
        if (findUsagesOptions == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(5);
        }
        return findUsagesOptions;
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        FindUsagesOptions options2 = FindUsagesHandlerBase.createFindUsagesOptions(this.getProject(), dataContext);
        options2.isSearchForTextOccurrences &= this.isSearchForTextOccurrencesAvailable(this.getPsiElement(), false);
        FindUsagesOptions findUsagesOptions = options2;
        if (findUsagesOptions == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(6);
        }
        return findUsagesOptions;
    }

    public boolean processElementUsages(@NotNull PsiElement element2, final @NotNull Processor<? super UsageInfo> processor2, @NotNull FindUsagesOptions options2) {
        boolean success;
        boolean searchText;
        if (element2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(8);
        }
        if (options2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(9);
        }
        ReadActionProcessor<PsiReference> refProcessor = new ReadActionProcessor<PsiReference>(){

            public boolean processInReadAction(PsiReference ref) {
                return processor2.process((Object)new UsageInfo(ref));
            }
        };
        SearchScope scope = options2.searchScope;
        boolean bl = searchText = options2.isSearchForTextOccurrences && scope instanceof GlobalSearchScope;
        if (options2.isUsages && !(success = ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters(element2, scope, options2)).forEach((Processor)refProcessor))) {
            return false;
        }
        if (searchText) {
            if (options2.fastTrack != null) {
                options2.fastTrack.searchCustom(consumer -> this.processUsagesInText(element2, processor2, (GlobalSearchScope)scope));
            } else {
                return this.processUsagesInText(element2, processor2, (GlobalSearchScope)scope);
            }
        }
        return true;
    }

    public boolean processUsagesInText(@NotNull PsiElement element2, @NotNull Processor<? super UsageInfo> processor2, @NotNull GlobalSearchScope searchScope) {
        Collection stringToSearch;
        if (element2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(10);
        }
        if (processor2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(12);
        }
        if ((stringToSearch = (Collection)ReadAction.compute(() -> this.getStringsToSearch(element2))) == null) {
            return true;
        }
        return FindUsagesHelper.processUsagesInText(element2, stringToSearch, false, searchScope, processor2);
    }

    @Nullable
    protected Collection<String> getStringsToSearch(@NotNull PsiElement element2) {
        if (element2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(13);
        }
        if (element2 instanceof PsiNamedElement) {
            return ContainerUtil.createMaybeSingletonList((Object)((PsiNamedElement)element2).getName());
        }
        return Collections.singleton(element2.getText());
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(14);
        }
        return this.isSearchForTextOccurencesAvailable(psiElement, isSingleFile);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected boolean isSearchForTextOccurencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(15);
        }
        return false;
    }

    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target2, @NotNull SearchScope searchScope) {
        if (target2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(17);
        }
        Collection collection = ReferencesSearch.search((ReferencesSearch.SearchParameters)this.createSearchParameters(target2, searchScope, null)).findAll();
        if (collection == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(18);
        }
        return collection;
    }

    @NotNull
    protected ReferencesSearch.SearchParameters createSearchParameters(@NotNull PsiElement target2, @NotNull SearchScope searchScope, @Nullable FindUsagesOptions findUsagesOptions) {
        if (target2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(20);
        }
        return new ReferencesSearch.SearchParameters(target2, searchScope, false, findUsagesOptions == null ? null : findUsagesOptions.fastTrack);
    }

    @NotNull
    public static FindUsagesOptions createFindUsagesOptions(@NotNull Project project, @Nullable DataContext dataContext) {
        if (project == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(21);
        }
        FindUsagesOptions findUsagesOptions = new FindUsagesOptions(project, dataContext);
        findUsagesOptions.isUsages = true;
        findUsagesOptions.isSearchForTextOccurrences = true;
        FindUsagesOptions findUsagesOptions2 = findUsagesOptions;
        if (findUsagesOptions2 == null) {
            FindUsagesHandlerBase.$$$reportNull$$$0(22);
        }
        return findUsagesOptions2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/findUsages/FindUsagesHandlerBase";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 12: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/findUsages/FindUsagesHandlerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencesToHighlight";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 22: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStringsToSearch";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurencesAvailable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findReferencesToHighlight";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createSearchParameters";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

