/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.actions.RecentLocationsAction;
import com.intellij.ide.actions.SwitcherToolWindowsListRenderer;
import com.intellij.ide.actions.ToolWindowsGroup;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditFeatureUsagesUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsState;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.IdeDocumentHistoryImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.SpeedSearchObjectWithWeight;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Switcher
extends AnAction
implements DumbAware {
    public static final Key<SwitcherPanel> SWITCHER_KEY;
    private static volatile SwitcherPanel SWITCHER;
    private static final Color SEPARATOR_COLOR;
    private static final String TOGGLE_CHECK_BOX_ACTION_ID = "SwitcherRecentEditedChangedToggleCheckBox";
    private static final int MINIMUM_HEIGHT;
    private static final int MINIMUM_WIDTH;
    @NonNls
    private static final String SWITCHER_FEATURE_ID = "switcher";
    private static final Color ON_MOUSE_OVER_BG_COLOR;
    private static int CTRL_KEY;
    @Nullable
    public static final Runnable CHECKER;
    @NotNull
    private static final CustomShortcutSet TW_SHORTCUT;
    @NonNls
    private static final String SWITCHER_TITLE = "Switcher";
    @NonNls
    private static InputEvent INIT_EVENT;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            Switcher.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            Switcher.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        boolean isNewSwitcher = false;
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            INIT_EVENT = e.getInputEvent();
            if (SWITCHER != null && SWITCHER.isPinnedMode()) {
                Switcher.SWITCHER.cancel();
                SWITCHER = null;
            }
            if (SWITCHER == null) {
                isNewSwitcher = true;
                boolean moveBack = e.getInputEvent() != null && e.getInputEvent().isShiftDown();
                Switcher.createAndShowSwitcher(project, SWITCHER_TITLE, SWITCHER_TITLE, false, false, !moveBack);
                FeatureUsageTracker.getInstance().triggerFeatureUsed(SWITCHER_FEATURE_ID);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            assert (SWITCHER != null);
            if (!SWITCHER.isPinnedMode()) {
                if (isNewSwitcher && !FileEditorManagerEx.getInstanceEx(project).hasOpenedFile()) {
                    Switcher.SWITCHER.files.setSelectedIndex(0);
                }
                if (!isNewSwitcher) {
                    if (e.getInputEvent() != null && e.getInputEvent().isShiftDown()) {
                        SWITCHER.goBack();
                    } else {
                        SWITCHER.goForward();
                    }
                }
            }
            return;
        }
    }

    @Deprecated
    @Nullable
    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull String title, boolean pinned, VirtualFile @Nullable [] vFiles) {
        if (e == null) {
            Switcher.$$$reportNull$$$0(2);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(3);
        }
        return Switcher.createAndShowSwitcher(e, title, "RecentFiles", pinned, vFiles != null);
    }

    public static SwitcherPanel createAndShowSwitcher(@NotNull AnActionEvent e, @NotNull String title, @NonNls @NotNull String actionId, boolean onlyEdited, boolean pinned) {
        boolean moveBack;
        if (e == null) {
            Switcher.$$$reportNull$$$0(4);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(5);
        }
        if (actionId == null) {
            Switcher.$$$reportNull$$$0(6);
        }
        if (SWITCHER != null && Objects.equals(Switcher.SWITCHER.myTitle, title)) {
            return null;
        }
        Project project = e.getProject();
        boolean bl = moveBack = e.getInputEvent() != null && e.getInputEvent().isShiftDown();
        return project == null ? null : Switcher.createAndShowSwitcher(project, title, actionId, onlyEdited, pinned, !moveBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SwitcherPanel createAndShowSwitcher(@NotNull Project project, @NotNull String title, @NotNull String actionId, boolean onlyEdited, boolean pinned, boolean moveForward) {
        if (project == null) {
            Switcher.$$$reportNull$$$0(7);
        }
        if (title == null) {
            Switcher.$$$reportNull$$$0(8);
        }
        if (actionId == null) {
            Switcher.$$$reportNull$$$0(9);
        }
        Class<Switcher> clazz = Switcher.class;
        synchronized (Switcher.class) {
            if (SWITCHER != null) {
                Switcher.SWITCHER.cancel();
            }
            SWITCHER = new SwitcherPanel(project, title, actionId, onlyEdited, pinned, moveForward);
            project.putUserData(SWITCHER_KEY, (Object)SWITCHER);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return SWITCHER;
        }
    }

    static {
        char ch;
        SWITCHER_KEY = Key.create((String)"SWITCHER_KEY");
        SWITCHER = null;
        SEPARATOR_COLOR = JBColor.namedColor((String)"Popup.separatorColor", (Color)new JBColor((Color)Gray.xC0, (Color)Gray.x4B));
        MINIMUM_HEIGHT = JBUIScale.scale((int)400);
        MINIMUM_WIDTH = JBUIScale.scale((int)500);
        ON_MOUSE_OVER_BG_COLOR = new JBColor(new Color(231, 242, 249), new Color(77, 80, 84));
        CHECKER = () -> {
            Class<Switcher> clazz = Switcher.class;
            synchronized (Switcher.class) {
                if (SWITCHER != null) {
                    SWITCHER.navigate(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        };
        Shortcut recentFiles = (Shortcut)ArrayUtil.getFirstElement((Object[])KeymapUtil.getActiveKeymapShortcuts((String)"RecentFiles").getShortcuts());
        ArrayList<Shortcut> shortcuts = new ArrayList<Shortcut>();
        for (ch = '0'; ch <= '9'; ch = (char)(ch + '\u0001')) {
            shortcuts.add(CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0]);
        }
        for (ch = 'A'; ch <= 'Z'; ch = (char)(ch + '\u0001')) {
            Shortcut shortcut = CustomShortcutSet.fromString((String[])new String[]{"control " + ch}).getShortcuts()[0];
            if (shortcut.equals(recentFiles)) continue;
            shortcuts.add(shortcut);
        }
        TW_SHORTCUT = new CustomShortcutSet(shortcuts.toArray(Shortcut.EMPTY_ARRAY));
        IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

            @Override
            public boolean dispatch(@NotNull AWTEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (SWITCHER != null && event instanceof KeyEvent && !SWITCHER.isPinnedMode()) {
                    ToolWindow tw;
                    KeyEvent keyEvent = (KeyEvent)event;
                    if (event.getID() == 402 && keyEvent.getKeyCode() == CTRL_KEY) {
                        ApplicationManager.getApplication().invokeLater(CHECKER, ModalityState.current());
                    } else if (event.getID() == 401 && event != INIT_EVENT && (tw = SWITCHER.twShortcuts.get(String.valueOf((char)keyEvent.getKeyCode()))) != null) {
                        SWITCHER.myPopup.closeOk(null);
                        tw.activate(null, true, true);
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ide/actions/Switcher$1", "dispatch"));
            }
        }, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/Switcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createAndShowSwitcher";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class FileInfo
    extends Pair<VirtualFile, EditorWindow> {
        private final Project myProject;
        private String myNameForRendering;

        FileInfo(VirtualFile first, EditorWindow second, Project project) {
            super((Object)first, (Object)second);
            this.myProject = project;
        }

        String getNameForRendering() {
            if (this.myNameForRendering == null) {
                this.myNameForRendering = EditorTabPresentationUtil.getUniqueEditorTabTitle(this.myProject, (VirtualFile)this.first, (EditorWindow)this.second);
            }
            return this.myNameForRendering;
        }
    }

    private static class VirtualFilesRenderer
    extends ColoredListCellRenderer<FileInfo> {
        private final SwitcherPanel mySwitcherPanel;
        boolean open;

        VirtualFilesRenderer(@NotNull SwitcherPanel switcherPanel) {
            if (switcherPanel == null) {
                VirtualFilesRenderer.$$$reportNull$$$0(0);
            }
            this.mySwitcherPanel = switcherPanel;
        }

        protected void customizeCellRenderer(@NotNull JList<? extends FileInfo> list2, FileInfo value2, int index, boolean selected2, boolean hasFocus) {
            if (list2 == null) {
                VirtualFilesRenderer.$$$reportNull$$$0(1);
            }
            Project project = this.mySwitcherPanel.project;
            VirtualFile virtualFile = (VirtualFile)value2.getFirst();
            String renderedName = value2.getNameForRendering();
            this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)project));
            FileStatus fileStatus = FileStatusManager.getInstance((Project)project).getStatus(virtualFile);
            this.open = FileEditorManager.getInstance((Project)project).isFileOpen(virtualFile);
            boolean hasProblem = WolfTheProblemSolver.getInstance((Project)project).isProblemFile(virtualFile);
            TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, (Color)(hasProblem ? JBColor.red : null), EffectType.WAVE_UNDERSCORE, 0);
            this.append(renderedName, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
            Color color = EditorTabPresentationUtil.getFileBackgroundColor(project, virtualFile);
            if (!selected2 && color != null) {
                this.setBackground(color);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)this.mySwitcherPanel, (SimpleColoredComponent)this, (boolean)false, (boolean)selected2);
            if (Registry.is((String)"show.last.visited.timestamps")) {
                IdeDocumentHistoryImpl.appendTimestamp(project, (SimpleColoredComponent)this, virtualFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switcherPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/actions/Switcher$VirtualFilesRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customizeCellRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyCheckBox
    extends JBCheckBox {
        private MyCheckBox(@NotNull String actionId, boolean selected2) {
            if (actionId == null) {
                MyCheckBox.$$$reportNull$$$0(0);
            }
            super(MyCheckBox.layoutText(actionId), selected2);
            this.setOpaque(false);
            this.setFocusable(false);
        }

        private static String layoutText(@NotNull String actionId) {
            if (actionId == null) {
                MyCheckBox.$$$reportNull$$$0(1);
            }
            ShortcutSet shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)actionId);
            return "<html>" + IdeBundle.message((String)"recent.files.checkbox.label", (Object[])new Object[0]) + " <font color=\"" + RecentLocationsAction.Holder.SHORTCUT_HEX_COLOR + "\">" + KeymapUtil.getShortcutsText((Shortcut[])shortcuts.getShortcuts()) + "</font></html>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "actionId";
            objectArray2[1] = "com/intellij/ide/actions/Switcher$MyCheckBox";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "layoutText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class SwitcherPanel
    extends JPanel
    implements KeyListener,
    MouseListener,
    MouseMotionListener,
    DataProvider,
    QuickSearchComponent,
    Disposable {
        static final int SWITCHER_ELEMENTS_LIMIT = 30;
        static final Object RECENT_LOCATIONS = new Object();
        final JBPopup myPopup;
        final JBList<Object> toolWindows;
        final JBList<FileInfo> files;
        final ToolWindowManager toolWindowManager;
        JBCheckBox myShowOnlyEditedFilesCheckBox;
        final JLabel pathLabel;
        final JPanel myTopPanel;
        final JPanel descriptions;
        final Project project;
        private final boolean myPinned;
        final Map<String, ToolWindow> twShortcuts;
        final Alarm myAlarm;
        final SwitcherSpeedSearch mySpeedSearch;
        final String myTitle;
        private JBPopup myHint;
        final ClickListener myClickListener;
        KeyEvent lastEvent;
        private boolean mouseMovedFirstTime;
        private JList mouseMoveSrc;
        private int mouseMoveListIndex;

        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            List list2;
            if (dataId == null) {
                SwitcherPanel.$$$reportNull$$$0(0);
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.project;
            }
            if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
                List list3 = this.getSelectedList().getSelectedValuesList();
                Object o = ContainerUtil.getOnlyItem((Collection)list3);
                return o instanceof FileInfo ? ((FileInfo)((Object)o)).first : null;
            }
            if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId) && !(list2 = this.getSelectedList().getSelectedValuesList()).isEmpty()) {
                ArrayList<VirtualFile> vFiles = new ArrayList<VirtualFile>();
                for (Object o : list2) {
                    if (!(o instanceof FileInfo)) continue;
                    vFiles.add((VirtualFile)((FileInfo)((Object)o)).first);
                }
                return vFiles.isEmpty() ? null : vFiles.toArray(VirtualFile.EMPTY_ARRAY);
            }
            return null;
        }

        private static void exchangeSelectionState(JBList toClear, JBList toSelect2) {
            if (toSelect2.getModel().getSize() > 0) {
                int index = Math.min(toClear.getSelectedIndex(), toSelect2.getModel().getSize() - 1);
                toSelect2.setSelectedIndex(index);
                toSelect2.ensureIndexIsVisible(index);
                toClear.clearSelection();
            }
        }

        SwitcherPanel(@NotNull Project project, @NotNull String title, @NotNull String actionId, boolean onlyEdited, boolean pinned, boolean moveForward) {
            Window window;
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(1);
            }
            if (title == null) {
                SwitcherPanel.$$$reportNull$$$0(2);
            }
            if (actionId == null) {
                SwitcherPanel.$$$reportNull$$$0(3);
            }
            this.pathLabel = new JLabel(" ");
            this.myClickListener = new ClickListener(){

                public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myPinned && (e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
                        return false;
                    }
                    Object source = e.getSource();
                    if (source instanceof JList) {
                        JList jList = (JList)source;
                        if (jList.getSelectedIndex() == -1 && jList.getAnchorSelectionIndex() != -1) {
                            jList.setSelectedIndex(jList.getAnchorSelectionIndex());
                        }
                        if (jList.getSelectedIndex() != -1) {
                            this.navigate(e);
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$1", "onClick"));
                }
            };
            this.mouseMovedFirstTime = true;
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.setLayout(new BorderLayout());
            this.project = project;
            this.myTitle = title;
            this.myPinned = pinned;
            this.mySpeedSearch = pinned ? new SwitcherSpeedSearch(this) : null;
            this.setBorder((Border)JBUI.Borders.empty());
            this.setBackground(JBColor.background());
            this.pathLabel.setHorizontalAlignment(2);
            Font font = this.pathLabel.getFont();
            this.pathLabel.setFont(font.deriveFont(Math.max(10.0f, (float)font.getSize() - 4.0f)));
            this.descriptions = new JPanel(new BorderLayout());
            this.pathLabel.setBorder(JBUI.CurrentTheme.Advertiser.border());
            this.pathLabel.setForeground(JBUI.CurrentTheme.Advertiser.foreground());
            this.pathLabel.setBackground(JBUI.CurrentTheme.Advertiser.background());
            this.pathLabel.setOpaque(true);
            this.descriptions.setBorder((Border)new CustomLineBorder(JBUI.CurrentTheme.Advertiser.borderColor(), (Insets)JBUI.insetsTop((int)1)));
            this.descriptions.add((Component)this.pathLabel, "Center");
            this.toolWindowManager = ToolWindowManager.getInstance((Project)project);
            CollectionListModel twModel = new CollectionListModel(new Object[0]);
            List<ActivateToolWindowAction> actions = ToolWindowsGroup.getToolWindowActions(project, true);
            ArrayList<ToolWindow> windows = new ArrayList<ToolWindow>();
            for (Object action2 : actions) {
                ToolWindow tw = this.toolWindowManager.getToolWindow(action2.getToolWindowId());
                if (!tw.isAvailable()) continue;
                windows.add(tw);
            }
            this.twShortcuts = SwitcherPanel.createShortcuts(windows);
            Map map2 = ContainerUtil.reverseMap(this.twShortcuts);
            windows.sort((o1, o2) -> StringUtil.compare((String)((String)map2.get(o1)), (String)((String)map2.get(o2)), (boolean)false));
            for (ToolWindow window2 : windows) {
                twModel.add((Object)window2);
            }
            twModel.add(RECENT_LOCATIONS);
            this.toolWindows = SwitcherPanel.createList(twModel, this.getNamer(), this.mySpeedSearch, pinned);
            this.toolWindows.addFocusListener((FocusListener)new MyToolWindowsListFocusListener());
            this.toolWindows.setPreferredSize(new Dimension(JBUI.scale((int)200), this.toolWindows.getPreferredSize().height));
            this.toolWindows.setBorder((Border)JBUI.Borders.empty((int)5, (int)5, (int)5, (int)20));
            this.toolWindows.setSelectionMode(pinned ? 2 : 0);
            this.toolWindows.setCellRenderer((ListCellRenderer)((Object)new SwitcherToolWindowsListRenderer(this.mySpeedSearch, map2, this.myPinned, this.showEdited()){

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    JComponent renderer = (JComponent)super.getListCellRendererComponent(list2, value2, index, selected2, selected2);
                    if (selected2) {
                        JComponent jComponent = renderer;
                        if (jComponent == null) {
                            2.$$$reportNull$$$0(1);
                        }
                        return jComponent;
                    }
                    Color bgColor = list2 == mouseMoveSrc && index == mouseMoveListIndex ? ON_MOUSE_OVER_BG_COLOR : list2.getBackground();
                    UIUtil.changeBackGround((Component)renderer, (Color)bgColor);
                    JComponent jComponent = renderer;
                    if (jComponent == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return jComponent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: 
                        case 2: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$2";
                            break;
                        }
                        case 1: 
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: 
                        case 2: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: 
                        case 2: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            }));
            this.toolWindows.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions(this.toolWindows);
            this.toolWindows.addMouseListener((MouseListener)this);
            this.toolWindows.addMouseMotionListener((MouseMotionListener)this);
            ScrollingUtil.ensureSelectionExists(this.toolWindows);
            this.myClickListener.installOn(this.toolWindows);
            this.toolWindows.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (!toolWindows.isSelectionEmpty() && !files.isSelectionEmpty()) {
                        files.clearSelection();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$3", "valueChanged"));
                }
            });
            List<FileInfo> filesToShow = SwitcherPanel.getFilesToShow(project, SwitcherPanel.collectFiles(project, onlyEdited), this.toolWindows.getModel().getSize(), pinned);
            CollectionListModel filesModel = new CollectionListModel((Object[])new FileInfo[0]);
            for (FileInfo editor : filesToShow) {
                filesModel.add((Object)editor);
            }
            VirtualFilesRenderer filesRenderer = new VirtualFilesRenderer(this){
                final JPanel myPanel;
                {
                    super(switcherPanel);
                    this.myPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
                    this.myPanel.setBackground(UIUtil.getListBackground());
                }

                @NotNull
                public Component getListCellRendererComponent(@NotNull JList<? extends FileInfo> list2, FileInfo value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Component c = super.getListCellRendererComponent(list2, (Object)value2, index, selected2, selected2);
                    this.myPanel.removeAll();
                    this.myPanel.add(c, "Center");
                    this.myPanel.getAccessibleContext().setAccessibleName(c.getAccessibleContext().getAccessibleName());
                    VirtualFile file2 = (VirtualFile)value2.first;
                    String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                    String location = FileUtil.getLocationRelativeToUserHome((String)presentableUrl);
                    this.myPanel.getAccessibleContext().setAccessibleDescription(location);
                    if (!selected2 && list2 == mouseMoveSrc && index == mouseMoveListIndex) {
                        this.setBackground(ON_MOUSE_OVER_BG_COLOR);
                    }
                    JPanel jPanel2 = this.myPanel;
                    if (jPanel2 == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return jPanel2;
                }

                @Override
                protected void customizeCellRenderer(@NotNull JList<? extends FileInfo> list2, FileInfo value2, int index, boolean selected2, boolean hasFocus) {
                    if (list2 == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    this.setPaintFocusBorder(false);
                    super.customizeCellRenderer(list2, value2, index, selected2, hasFocus);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "list";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$4";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$4";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getListCellRendererComponent";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getListCellRendererComponent";
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            objectArray = objectArray;
                            objectArray[2] = "customizeCellRenderer";
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            ListSelectionListener filesSelectionListener = new ListSelectionListener(){

                @Nullable
                private String getTitle2Text(@Nullable String fullText) {
                    int labelWidth = pathLabel.getWidth();
                    if (fullText == null || fullText.length() == 0) {
                        return " ";
                    }
                    while (pathLabel.getFontMetrics(pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                        int sep = fullText.indexOf(File.separatorChar, 4);
                        if (sep < 0) {
                            return fullText;
                        }
                        fullText = "..." + fullText.substring(sep);
                    }
                    return fullText;
                }

                @Override
                public void valueChanged(@NotNull ListSelectionEvent e) {
                    PopupUpdateProcessorBase popupUpdater;
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    this.updatePathLabel();
                    PopupUpdateProcessorBase popupUpdateProcessorBase = popupUpdater = myHint == null || !myHint.isVisible() ? null : (PopupUpdateProcessorBase)myHint.getUserData(PopupUpdateProcessorBase.class);
                    if (popupUpdater != null) {
                        popupUpdater.updatePopup(CommonDataKeys.PSI_ELEMENT.getData(DataManager.getInstance().getDataContext((Component)this)));
                    }
                }

                private void updatePathLabel() {
                    List values2 = files.getSelectedValuesList();
                    if (values2 != null && values2.size() == 1) {
                        VirtualFile file2 = (VirtualFile)((FileInfo)((Object)values2.get((int)0))).first;
                        String presentableUrl = ((VirtualFile)ObjectUtils.notNull((Object)file2.getParent(), (Object)file2)).getPresentableUrl();
                        pathLabel.setText(this.getTitle2Text(FileUtil.getLocationRelativeToUserHome((String)presentableUrl)));
                    } else {
                        pathLabel.setText(" ");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$5", "valueChanged"));
                }
            };
            this.files = SwitcherPanel.createList(filesModel, FileInfo::getNameForRendering, this.mySpeedSearch, pinned);
            this.files.setSelectionMode(pinned ? 2 : 0);
            this.files.getSelectionModel().addListSelectionListener(e -> {
                if (!this.files.isSelectionEmpty() && !this.toolWindows.isSelectionEmpty()) {
                    this.toolWindows.getSelectionModel().clearSelection();
                }
            });
            this.files.getSelectionModel().addListSelectionListener(filesSelectionListener);
            this.files.setCellRenderer((ListCellRenderer)((Object)filesRenderer));
            this.files.setBorder(JBUI.Borders.empty((int)5));
            this.files.addKeyListener((KeyListener)this);
            ScrollingUtil.installActions(this.files);
            this.files.addMouseListener((MouseListener)this);
            this.files.addMouseMotionListener((MouseMotionListener)this);
            this.files.addFocusListener((FocusListener)new MyFilesListFocusListener());
            this.myClickListener.installOn(this.files);
            ScrollingUtil.ensureSelectionExists(this.files);
            this.myShowOnlyEditedFilesCheckBox = new MyCheckBox(ToggleCheckBoxAction.isEnabled() ? Switcher.TOGGLE_CHECK_BOX_ACTION_ID : actionId, onlyEdited);
            this.myTopPanel = SwitcherPanel.createTopPanel(this.myShowOnlyEditedFilesCheckBox, this.isCheckboxMode() ? IdeBundle.message((String)"title.popup.recent.files", (Object[])new Object[0]) : title, pinned);
            if (this.isCheckboxMode()) {
                this.myShowOnlyEditedFilesCheckBox.addActionListener(e -> this.setShowOnlyEditedFiles(this.myShowOnlyEditedFilesCheckBox.isSelected()));
                this.myShowOnlyEditedFilesCheckBox.addActionListener(e -> this.toolWindows.repaint());
            } else {
                this.myShowOnlyEditedFilesCheckBox.setEnabled(false);
                this.myShowOnlyEditedFilesCheckBox.setVisible(false);
            }
            this.add((Component)this.myTopPanel, "North");
            this.add((Component)this.toolWindows, "West");
            if (filesModel.getSize() > 0) {
                this.files.setAlignmentY(1.0f);
                JScrollPane pane2 = ScrollPaneFactory.createScrollPane(this.files, (boolean)true);
                pane2.setPreferredSize(new Dimension(Math.max(this.myTopPanel.getPreferredSize().width - this.toolWindows.getPreferredSize().width, this.files.getPreferredSize().width), 400));
                Border border = JBUI.Borders.merge((Border)JBUI.Borders.emptyLeft((int)9), (Border)new CustomLineBorder(SEPARATOR_COLOR, (Insets)JBUI.insetsLeft((int)1)), (boolean)true);
                pane2.setBorder(border);
                this.add((Component)pane2, "Center");
                int selectionIndex = SwitcherPanel.getFilesSelectedIndex(project, this.files, moveForward);
                if (selectionIndex > -1) {
                    this.files.setSelectedIndex(selectionIndex);
                }
            }
            this.add((Component)this.descriptions, "South");
            ShortcutSet shortcutSet = ActionManager.getInstance().getAction(Switcher.SWITCHER_TITLE).getShortcutSet();
            int modifiers = SwitcherPanel.getModifiers(shortcutSet);
            boolean isAlt = (modifiers & 8) != 0;
            CTRL_KEY = isAlt ? 18 : 17;
            this.files.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            this.toolWindows.addKeyListener((KeyListener)ArrayUtil.getLastElement((Object[])this.getKeyListeners()));
            KeymapUtil.reassignAction(this.toolWindows, (KeyStroke)KeyStroke.getKeyStroke(38, 0), (KeyStroke)KeyStroke.getKeyStroke(38, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction(this.toolWindows, (KeyStroke)KeyStroke.getKeyStroke(40, 0), (KeyStroke)KeyStroke.getKeyStroke(40, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction(this.files, (KeyStroke)KeyStroke.getKeyStroke(38, 0), (KeyStroke)KeyStroke.getKeyStroke(38, 128), (int)0, (boolean)false);
            KeymapUtil.reassignAction(this.files, (KeyStroke)KeyStroke.getKeyStroke(40, 0), (KeyStroke)KeyStroke.getKeyStroke(40, 128), (int)0, (boolean)false);
            this.myPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, filesModel.getSize() > 0 ? this.files : this.toolWindows).setResizable(pinned).setModalContext(false).setFocusable(true).setRequestFocus(true).setCancelOnWindowDeactivation(true).setCancelOnOtherWindowOpen(true).setMovable(pinned).setMinSize(new Dimension(MINIMUM_WIDTH, MINIMUM_HEIGHT)).setDimensionServiceKey((Project)(pinned ? project : null), pinned ? "SwitcherDM" : null, false).setCancelKeyEnabled(false).setCancelCallback(() -> {
                Container popupFocusAncestor = this.getPopupFocusAncestor();
                if (popupFocusAncestor != null) {
                    popupFocusAncestor.setFocusTraversalPolicy(null);
                }
                SWITCHER = null;
                return true;
            }).createPopup();
            Disposer.register((Disposable)this.myPopup, (Disposable)this);
            if (this.isPinnedMode()) {
                new DumbAwareAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            6.$$$reportNull$$$0(0);
                        }
                        if (mySpeedSearch != null && mySpeedSearch.isPopupActive()) {
                            mySpeedSearch.hidePopup();
                            Object[] elements2 = mySpeedSearch.getAllElements();
                            if (elements2 != null && elements2.length > 0) {
                                mySpeedSearch.selectElement(elements2[0], "");
                            }
                        } else {
                            myPopup.cancel();
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$6", "actionPerformed"));
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"ESCAPE"}), (JComponent)this, (Disposable)this.myPopup);
            }
            if (!this.myPinned) {
                new DumbAwareAction(IdeBundle.messagePointer((String)"action.AnActionButton.text.suppress.all.actions.to.activate.a.toolwindow", (Object[])new Object[0])){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            7.$$$reportNull$$$0(0);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/actions/Switcher$SwitcherPanel$7", "actionPerformed"));
                    }
                }.registerCustomShortcutSet((ShortcutSet)TW_SHORTCUT, (JComponent)this, (Disposable)this.myPopup);
            }
            if ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) == null) {
                window = WindowManager.getInstance().getFrame(project);
            }
            this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this.myPopup);
            IdeEventQueue.getInstance().getPopupManager().closeAllPopups(false);
            this.myPopup.showInCenterOf((Component)window);
            Container popupFocusAncestor = this.getPopupFocusAncestor();
            popupFocusAncestor.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 0, "RIGHT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 1, "LEFT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 0, "control RIGHT");
            SwitcherPanel.addFocusTraversalKeys(popupFocusAncestor, 1, "control LEFT");
            SwitcherPanel.fromListToList(this.toolWindows, this.files);
            SwitcherPanel.fromListToList(this.files, this.toolWindows);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            Class<Switcher> clazz = Switcher.class;
            synchronized (Switcher.class) {
                SWITCHER = null;
                this.project.putUserData(SWITCHER_KEY, null);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @NotNull
        private Supplier<Boolean> showEdited() {
            Supplier<Boolean> supplier2 = () -> this.myShowOnlyEditedFilesCheckBox != null && this.myShowOnlyEditedFilesCheckBox.isSelected();
            if (supplier2 == null) {
                SwitcherPanel.$$$reportNull$$$0(4);
            }
            return supplier2;
        }

        @NotNull
        private Function<? super Object, String> getNamer() {
            Function function = value2 -> {
                if (value2 instanceof ToolWindow) {
                    return ((ToolWindow)value2).getStripeTitle();
                }
                if (value2 == RECENT_LOCATIONS) {
                    return SwitcherPanel.getRecentLocationsLabel(this.showEdited());
                }
                throw new IllegalStateException();
            };
            if (function == null) {
                SwitcherPanel.$$$reportNull$$$0(5);
            }
            return function;
        }

        static String getRecentLocationsLabel(@NotNull Supplier<Boolean> showEdited) {
            if (showEdited == null) {
                SwitcherPanel.$$$reportNull$$$0(6);
            }
            return showEdited.get() != false ? IdeBundle.message((String)"recent.locations.changed.locations", (Object[])new Object[0]) : IdeBundle.message((String)"recent.locations.popup.title", (Object[])new Object[0]);
        }

        public void registerHint(@NotNull JBPopup h) {
            if (h == null) {
                SwitcherPanel.$$$reportNull$$$0(7);
            }
            if (this.myHint != null && this.myHint.isVisible() && this.myHint != h) {
                this.myHint.cancel();
            }
            this.myHint = h;
        }

        public void unregisterHint() {
            this.myHint = null;
        }

        @NotNull
        private static <T> JBList<T> createList(CollectionListModel<T> baseModel, Function<? super T, String> namer, SwitcherSpeedSearch speedSearch2, boolean pinned) {
            NameFilteringListModel listModel = pinned ? new NameFilteringListModel(baseModel, namer, s -> !speedSearch2.isPopupActive() || StringUtil.isEmpty((String)speedSearch2.getEnteredPrefix()) || speedSearch2.getComparator().matchingFragments(speedSearch2.getEnteredPrefix(), (String)s) != null, () -> StringUtil.notNullize((String)speedSearch2.getEnteredPrefix())) : baseModel;
            return new JBList(listModel);
        }

        private static void fromListToList(JBList from, final JBList to) {
            AbstractAction action2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    to.requestFocus();
                }
            };
            ActionMap map2 = from.getActionMap();
            map2.put("selectPreviousColumn", action2);
            map2.put("selectNextColumn", action2);
        }

        private Container getPopupFocusAncestor() {
            return this.myPopup.isDisposed() ? null : this.myPopup.getContent().getFocusCycleRootAncestor();
        }

        @NotNull
        static List<VirtualFile> collectFiles(@NotNull Project project, boolean onlyEdited) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(8);
            }
            return onlyEdited ? Arrays.asList(IdeDocumentHistory.getInstance(project).getChangedFiles()) : SwitcherPanel.getRecentFiles(project);
        }

        @NotNull
        static List<FileInfo> getFilesToShow(@NotNull Project project, @NotNull List<VirtualFile> filesForInit, int toolWindowsCount, boolean pinned) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(9);
            }
            if (filesForInit == null) {
                SwitcherPanel.$$$reportNull$$$0(10);
            }
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            ArrayList<FileInfo> filesData = new ArrayList<FileInfo>();
            ArrayList<FileInfo> editors = new ArrayList<FileInfo>();
            LinkedHashSet<VirtualFile> addedFiles = new LinkedHashSet<VirtualFile>();
            if (!pinned) {
                for (Pair pair : editorManager.getSelectionHistory()) {
                    editors.add(new FileInfo((VirtualFile)pair.first, (EditorWindow)pair.second, project));
                }
            }
            if (!pinned) {
                for (FileInfo fileInfo : editors) {
                    addedFiles.add((VirtualFile)fileInfo.first);
                    filesData.add(fileInfo);
                    if (filesData.size() < 30) continue;
                    break;
                }
            }
            List<VirtualFile> selectedFiles = Arrays.asList(editorManager.getSelectedFiles());
            if (filesData.size() <= 1 || pinned) {
                if (!filesForInit.isEmpty()) {
                    int n = (int)editors.stream().map(info -> (VirtualFile)info.first).distinct().count();
                    int maxFiles = Math.max(n, filesForInit.size());
                    int minIndex = pinned ? 0 : filesForInit.size() - Math.min(toolWindowsCount, maxFiles);
                    for (int i2 = filesForInit.size() - 1; i2 >= minIndex; --i2) {
                        if (pinned && UISettings.getInstance().getEditorTabPlacement() != 0 && selectedFiles.contains(filesForInit.get(i2))) continue;
                        FileInfo info2 = new FileInfo(filesForInit.get(i2), null, project);
                        boolean add2 = true;
                        if (pinned) {
                            for (FileInfo fileInfo : filesData) {
                                if (!((VirtualFile)fileInfo.first).equals(info2.first)) continue;
                                add2 = false;
                                break;
                            }
                        }
                        if (!add2 || !addedFiles.add((VirtualFile)info2.first)) continue;
                        filesData.add(info2);
                    }
                }
                if (editors.size() == 1 && (filesData.isEmpty() || !((VirtualFile)((FileInfo)((Object)editors.get(0))).getFirst()).equals(filesData.get(0).getFirst())) && addedFiles.add((VirtualFile)((FileInfo)((Object)editors.get((int)0))).first)) {
                    filesData.add(0, (FileInfo)((Object)editors.get(0)));
                }
            }
            ArrayList<FileInfo> arrayList = filesData;
            if (arrayList == null) {
                SwitcherPanel.$$$reportNull$$$0(11);
            }
            return arrayList;
        }

        static int getFilesSelectedIndex(Project project, JList<FileInfo> filesList, boolean forward) {
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)project);
            EditorWindow currentWindow = editorManager.getCurrentWindow();
            VirtualFile currentFile = currentWindow != null ? currentWindow.getSelectedFile() : null;
            ListModel<FileInfo> model = filesList.getModel();
            if (forward) {
                for (int i2 = 0; i2 < model.getSize(); ++i2) {
                    FileInfo fileInfo = model.getElementAt(i2);
                    if (SwitcherPanel.isTheSameTab(currentWindow, currentFile, fileInfo)) continue;
                    return i2;
                }
            } else {
                for (int i3 = model.getSize() - 1; i3 >= 0; --i3) {
                    FileInfo fileInfo = model.getElementAt(i3);
                    if (SwitcherPanel.isTheSameTab(currentWindow, currentFile, fileInfo)) continue;
                    return i3;
                }
            }
            return -1;
        }

        private static boolean isTheSameTab(EditorWindow currentWindow, VirtualFile currentFile, FileInfo fileInfo) {
            return ((VirtualFile)fileInfo.first).equals(currentFile) && (fileInfo.second == null || ((EditorWindow)fileInfo.second).equals(currentWindow));
        }

        @NotNull
        private static JPanel createTopPanel(@NotNull JBCheckBox showOnlyEditedFilesCheckBox, @NotNull String title, boolean isMovable) {
            if (showOnlyEditedFilesCheckBox == null) {
                SwitcherPanel.$$$reportNull$$$0(12);
            }
            if (title == null) {
                SwitcherPanel.$$$reportNull$$$0(13);
            }
            CaptionPanel topPanel = new CaptionPanel();
            JBLabel titleLabel = new JBLabel(title);
            titleLabel.setFont(titleLabel.getFont().deriveFont(1));
            topPanel.add((Component)titleLabel, "West");
            topPanel.add((Component)showOnlyEditedFilesCheckBox, "East");
            Dimension size = topPanel.getPreferredSize();
            size.height = JBUIScale.scale((int)29);
            size.width = titleLabel.getPreferredSize().width + showOnlyEditedFilesCheckBox.getPreferredSize().width + JBUIScale.scale((int)50);
            topPanel.setPreferredSize(size);
            topPanel.setMinimumSize(size);
            topPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
            if (isMovable) {
                WindowMoveListener moveListener = new WindowMoveListener((Component)topPanel);
                topPanel.addMouseListener(moveListener);
                topPanel.addMouseMotionListener(moveListener);
            }
            CaptionPanel captionPanel = topPanel;
            if (captionPanel == null) {
                SwitcherPanel.$$$reportNull$$$0(14);
            }
            return captionPanel;
        }

        private static void addFocusTraversalKeys(Container focusCycleRoot, int focusTraversalType, String keyStroke) {
            Set<AWTKeyStroke> focusTraversalKeySet = focusCycleRoot.getFocusTraversalKeys(focusTraversalType);
            HashSet<AWTKeyStroke> set = new HashSet<AWTKeyStroke>(focusTraversalKeySet);
            set.add(KeyStroke.getKeyStroke(keyStroke));
            focusCycleRoot.setFocusTraversalKeys(focusTraversalType, set);
        }

        @NotNull
        private static List<VirtualFile> getRecentFiles(@NotNull Project project) {
            if (project == null) {
                SwitcherPanel.$$$reportNull$$$0(15);
            }
            List<VirtualFile> recentFiles = EditorHistoryManager.getInstance(project).getFileList();
            Object[] openFiles = FileEditorManager.getInstance((Project)project).getOpenFiles();
            HashSet<VirtualFile> recentFilesSet = new HashSet<VirtualFile>(recentFiles);
            HashSet openFilesSet = ContainerUtil.newHashSet((Object[])openFiles);
            int index = 0;
            for (int i2 = 0; i2 < recentFiles.size(); ++i2) {
                if (!openFilesSet.contains(recentFiles.get(i2))) continue;
                index = i2;
                break;
            }
            ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(recentFiles);
            result2.addAll(index, ContainerUtil.filter((Object[])openFiles, it -> !recentFilesSet.contains(it)));
            ArrayList<VirtualFile> arrayList = result2;
            if (arrayList == null) {
                SwitcherPanel.$$$reportNull$$$0(16);
            }
            return arrayList;
        }

        @NotNull
        private static Map<String, ToolWindow> createShortcuts(@NotNull List<ToolWindow> windows) {
            if (windows == null) {
                SwitcherPanel.$$$reportNull$$$0(17);
            }
            HashMap<String, ToolWindow> keymap2 = new HashMap<String, ToolWindow>(windows.size());
            ArrayList<ToolWindow> otherTW = new ArrayList<ToolWindow>();
            for (ToolWindow window : windows) {
                int index = ActivateToolWindowAction.getMnemonicForToolWindow(window.getId());
                if (index >= 48 && index <= 57) {
                    keymap2.put(SwitcherPanel.getIndexShortcut(index - 48), window);
                    continue;
                }
                otherTW.add(window);
            }
            int i2 = 0;
            for (ToolWindow window : otherTW) {
                String bestShortcut = SwitcherPanel.getSmartShortcut(window, keymap2);
                if (bestShortcut != null) {
                    keymap2.put(bestShortcut, window);
                    continue;
                }
                while (keymap2.get(SwitcherPanel.getIndexShortcut(i2)) != null) {
                    ++i2;
                }
                keymap2.put(SwitcherPanel.getIndexShortcut(i2), window);
                ++i2;
            }
            HashMap<String, ToolWindow> hashMap = keymap2;
            if (hashMap == null) {
                SwitcherPanel.$$$reportNull$$$0(18);
            }
            return hashMap;
        }

        @Nullable
        private static String getSmartShortcut(ToolWindow window, Map<String, ToolWindow> keymap2) {
            String title = window.getStripeTitle();
            if (StringUtil.isEmpty((String)title)) {
                return null;
            }
            for (int i2 = 0; i2 < title.length(); ++i2) {
                String shortcut;
                char c = title.charAt(i2);
                if (!Character.isUpperCase(c) || keymap2.get(shortcut = String.valueOf(c)) != null) continue;
                return shortcut;
            }
            return null;
        }

        private static String getIndexShortcut(int index) {
            return StringUtil.toUpperCase((String)Integer.toString(index, index + 1));
        }

        private static int getModifiers(@Nullable ShortcutSet shortcutSet) {
            if (shortcutSet == null || shortcutSet.getShortcuts().length == 0 || !(shortcutSet.getShortcuts()[0] instanceof KeyboardShortcut)) {
                return 2;
            }
            return ((KeyboardShortcut)shortcutSet.getShortcuts()[0]).getFirstKeyStroke().getModifiers();
        }

        @Override
        public void keyTyped(@NotNull KeyEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(19);
            }
        }

        @Override
        public void keyReleased(@NotNull KeyEvent e) {
            boolean ctrl;
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(20);
            }
            boolean bl = ctrl = e.getKeyCode() == CTRL_KEY;
            if (ctrl && this.isAutoHide()) {
                this.navigate(e);
            }
        }

        @Override
        public void keyPressed(@NotNull KeyEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(21);
            }
            if (this.mySpeedSearch != null && this.mySpeedSearch.isPopupActive() || this.lastEvent == e) {
                return;
            }
            this.lastEvent = e;
            switch (e.getKeyCode()) {
                case 8: 
                case 81: 
                case 127: {
                    this.closeTabOrToolWindow();
                    break;
                }
                case 27: {
                    this.cancel();
                    break;
                }
                case 10: {
                    if (this.mySpeedSearch != null) break;
                    this.navigate(e);
                }
            }
        }

        private void closeTabOrToolWindow() {
            JBList<?> selectedList = this.getSelectedList();
            int[] selected2 = selectedList.getSelectedIndices();
            Arrays.sort(selected2);
            int selectedIndex = 0;
            for (int i2 = selected2.length - 1; i2 >= 0; --i2) {
                selectedIndex = selected2[i2];
                Object value2 = selectedList.getModel().getElementAt(selectedIndex);
                if (value2 instanceof FileInfo) {
                    FileInfo info = (FileInfo)((Object)value2);
                    VirtualFile virtualFile = (VirtualFile)info.first;
                    FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    JBList<?> jList = this.getSelectedList();
                    EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                    if (wnd == null) {
                        editorManager.closeFile(virtualFile, false, false);
                    } else {
                        editorManager.closeFile(virtualFile, wnd, false);
                    }
                    IdeFocusManager focusManager = IdeFocusManager.getInstance((Project)this.project);
                    this.myAlarm.cancelAllRequests();
                    this.myAlarm.addRequest(() -> {
                        Object focusTarget = selectedList;
                        if (selectedList.getModel().getSize() == 0) {
                            focusTarget = selectedList == this.files ? this.toolWindows : this.files;
                        }
                        focusManager.requestFocus((Component)focusTarget, true);
                    }, 300);
                    if (jList.getModel().getSize() == 1) {
                        SwitcherPanel.removeElementAt(jList, selectedIndex);
                        this.remove((Component)jList);
                        Dimension size = this.toolWindows.getSize();
                        this.myPopup.setSize(new Dimension(size.width, this.myPopup.getSize().height));
                    } else {
                        SwitcherPanel.removeElementAt(jList, selectedIndex);
                        jList.setSize(jList.getPreferredSize());
                    }
                    if (!this.isPinnedMode()) continue;
                    EditorHistoryManager.getInstance(this.project).removeFile(virtualFile);
                    continue;
                }
                if (!(value2 instanceof ToolWindow)) continue;
                ToolWindow toolWindow = (ToolWindow)value2;
                if (this.toolWindowManager instanceof ToolWindowManagerImpl) {
                    ((ToolWindowManagerImpl)this.toolWindowManager).hideToolWindow(toolWindow.getId(), false, false);
                    continue;
                }
                toolWindow.hide(null);
            }
            this.pack();
            this.myPopup.getContent().revalidate();
            this.myPopup.getContent().repaint();
            if (this.getSelectedList().getModel().getSize() > selectedIndex) {
                this.getSelectedList().setSelectedIndex(selectedIndex);
                this.getSelectedList().ensureIndexIsVisible(selectedIndex);
            }
        }

        private static void removeElementAt(@NotNull JList<?> jList, int index) {
            if (jList == null) {
                SwitcherPanel.$$$reportNull$$$0(22);
            }
            ListUtil.removeItem(jList.getModel(), (int)index);
        }

        private void pack() {
            this.setSize(this.getPreferredSize());
            JRootPane rootPane = SwingUtilities.getRootPane(this);
            Container container2 = this;
            do {
                container2 = container2.getParent();
                container2.setSize(container2.getPreferredSize());
            } while (container2 != rootPane);
            container2.getParent().setSize(container2.getPreferredSize());
        }

        private boolean isFilesSelected() {
            return this.getSelectedList() == this.files;
        }

        private boolean isFilesVisible() {
            return this.files.getModel().getSize() > 0;
        }

        private void cancel() {
            this.myPopup.cancel();
        }

        public void go(boolean forward) {
            JBList<?> selected2;
            Object list2 = selected2 = this.getSelectedList();
            int index = list2.getSelectedIndex();
            index = forward ? ++index : --index;
            if (forward && index >= list2.getModel().getSize() || !forward && index < 0) {
                if (this.isFilesVisible()) {
                    list2 = this.isFilesSelected() ? this.toolWindows : this.files;
                }
                index = forward ? 0 : list2.getModel().getSize() - 1;
            }
            list2.setSelectedIndex(index);
            list2.ensureIndexIsVisible(index);
            if (selected2 != list2) {
                IdeFocusManager.findInstanceByComponent(list2).requestFocus(list2, true);
            }
        }

        public void goForward() {
            this.go(true);
        }

        public void goBack() {
            this.go(false);
        }

        public JBList<?> getSelectedList() {
            return this.getSelectedList(this.files);
        }

        @Nullable
        JBList getSelectedList(@Nullable JBList preferable) {
            return this.files.hasFocus() ? this.files : (this.toolWindows.hasFocus() ? this.toolWindows : preferable);
        }

        boolean isCheckboxMode() {
            return this.isPinnedMode() && Experiments.getInstance().isFeatureEnabled("recent.and.edited.files.together");
        }

        void toggleShowEditedFiles() {
            this.myShowOnlyEditedFilesCheckBox.doClick();
        }

        void setShowOnlyEditedFiles(boolean onlyEdited) {
            if (this.myShowOnlyEditedFilesCheckBox.isSelected() != onlyEdited) {
                this.myShowOnlyEditedFilesCheckBox.setSelected(onlyEdited);
            }
            boolean listWasSelected = this.files.getSelectedIndex() != -1;
            List<FileInfo> filesToShow = SwitcherPanel.getFilesToShow(this.project, SwitcherPanel.collectFiles(this.project, onlyEdited), this.toolWindows.getModel().getSize(), this.isPinnedMode());
            ListModel model = this.files.getModel();
            ListUtil.removeAllItems((ListModel)model);
            ListUtil.addAllItems((ListModel)model, filesToShow);
            int selectionIndex = SwitcherPanel.getFilesSelectedIndex(this.project, this.files, true);
            if (selectionIndex > -1 && listWasSelected) {
                this.files.setSelectedIndex(selectionIndex);
            }
            this.files.revalidate();
            this.files.repaint();
        }

        void navigate(InputEvent e) {
            boolean openInNewWindow = e != null && e.isShiftDown() && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 10;
            List values2 = this.getSelectedList().getSelectedValuesList();
            String searchQuery = this.mySpeedSearch != null ? this.mySpeedSearch.getEnteredPrefix() : null;
            this.myPopup.cancel(null);
            if (values2.isEmpty()) {
                this.tryToOpenFileSearch(e, searchQuery);
            } else if (values2.get(0) == RECENT_LOCATIONS) {
                RecentLocationsAction.showPopup(this.project, this.myShowOnlyEditedFilesCheckBox.isSelected());
            } else if (values2.get(0) instanceof ToolWindow) {
                ToolWindow toolWindow = (ToolWindow)values2.get(0);
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> toolWindow.activate(null, true, true), ModalityState.current());
            } else {
                IdeFocusManager.getInstance((Project)this.project).doWhenFocusSettlesDown(() -> {
                    FileEditorManagerImpl manager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)this.project);
                    for (Object value2 : values2) {
                        if (!(value2 instanceof FileInfo)) continue;
                        FileInfo info = (FileInfo)((Object)((Object)value2));
                        VirtualFile file2 = (VirtualFile)info.first;
                        if (openInNewWindow) {
                            manager.openFileInNewWindow(file2);
                            continue;
                        }
                        if (info.second != null) {
                            EditorWindow wnd = SwitcherPanel.findAppropriateWindow(info);
                            if (wnd == null) continue;
                            manager.openFileImpl2(wnd, file2, true);
                            manager.addSelectionRecord(file2, wnd);
                            continue;
                        }
                        UISettingsState settings = UISettings.getInstance().getState();
                        boolean oldValue = settings.getReuseNotModifiedTabs();
                        settings.setReuseNotModifiedTabs(false);
                        manager.openFile(file2, true, true);
                        if (LightEdit.owns((Project)this.project)) {
                            LightEditFeatureUsagesUtil.logFileOpen(LightEditFeatureUsagesUtil.OpenPlace.RecentFiles);
                        }
                        if (!oldValue) continue;
                        CommandProcessor.getInstance().executeCommand(this.project, () -> settings.setReuseNotModifiedTabs(true), "", null);
                    }
                }, ModalityState.current());
            }
        }

        private void tryToOpenFileSearch(InputEvent e, String fileName) {
            AnAction gotoFile = ActionManager.getInstance().getAction("GotoFile");
            if (gotoFile != null && !StringUtil.isEmpty((String)fileName)) {
                this.myPopup.cancel();
                AnAction action2 = gotoFile;
                ApplicationManager.getApplication().invokeLater(() -> DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> {
                    DataContext dataContext = dataId -> {
                        if (PlatformDataKeys.PREDEFINED_TEXT.is(dataId)) {
                            return fileName;
                        }
                        return context.getData(dataId);
                    };
                    AnActionEvent event = new AnActionEvent(e, dataContext, "EditorPopup", new PresentationFactory().getPresentation(action2), ActionManager.getInstance(), 0);
                    action2.actionPerformed(event);
                }), ModalityState.current());
            }
        }

        @Nullable
        private static EditorWindow findAppropriateWindow(@NotNull FileInfo info) {
            if (info == null) {
                SwitcherPanel.$$$reportNull$$$0(23);
            }
            if (info.second == null) {
                return null;
            }
            if (UISettings.getInstance().getEditorTabPlacement() == 0) {
                return ((EditorWindow)info.second).getOwner().getCurrentWindow();
            }
            Object[] windows = ((EditorWindow)info.second).getOwner().getWindows();
            return ArrayUtil.contains((Object)((EditorWindow)info.second), (Object[])windows) ? (EditorWindow)info.second : (windows.length > 0 ? windows[0] : null);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(24);
            }
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            JList list2;
            int index;
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(25);
            }
            if (this.mouseMovedFirstTime) {
                this.mouseMovedFirstTime = false;
                return;
            }
            Object source = e.getSource();
            boolean changed2 = false;
            if (source instanceof JList && 0 <= (index = (list2 = (JList)source).locationToIndex(e.getPoint())) && index < list2.getModel().getSize()) {
                this.mouseMoveSrc = list2;
                this.mouseMoveListIndex = index;
                changed2 = true;
            }
            if (!changed2) {
                this.mouseMoveSrc = null;
                this.mouseMoveListIndex = -1;
            }
            this.repaintLists();
        }

        private void repaintLists() {
            this.toolWindows.repaint();
            this.files.repaint();
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(26);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(27);
            }
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(28);
            }
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(29);
            }
            this.mouseMoveSrc = null;
            this.mouseMoveListIndex = -1;
            this.repaintLists();
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            if (e == null) {
                SwitcherPanel.$$$reportNull$$$0(30);
            }
        }

        public boolean isAutoHide() {
            return !this.myPinned;
        }

        public boolean isPinnedMode() {
            return this.myPinned;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 14: 
                case 16: 
                case 18: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 14: 
                case 16: 
                case 18: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
                case 1: 
                case 8: 
                case 9: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 14: 
                case 16: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showEdited";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "h";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filesForInit";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showOnlyEditedFilesCheckBox";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windows";
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jList";
                    break;
                }
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showEdited";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamer";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilesToShow";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createTopPanel";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecentFiles";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createShortcuts";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 14: 
                case 16: 
                case 18: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecentLocationsLabel";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "registerHint";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "collectFiles";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesToShow";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "createTopPanel";
                    break;
                }
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "getRecentFiles";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "createShortcuts";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "keyTyped";
                    break;
                }
                case 20: {
                    objectArray = objectArray;
                    objectArray[2] = "keyReleased";
                    break;
                }
                case 21: {
                    objectArray = objectArray;
                    objectArray[2] = "keyPressed";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "removeElementAt";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "findAppropriateWindow";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseClicked";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseMoved";
                    break;
                }
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "mousePressed";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseReleased";
                    break;
                }
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseEntered";
                    break;
                }
                case 29: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseExited";
                    break;
                }
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "mouseDragged";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 14: 
                case 16: 
                case 18: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private static class SwitcherSpeedSearch
        extends SpeedSearchBase<SwitcherPanel>
        implements PropertyChangeListener {
            SwitcherSpeedSearch(@NotNull SwitcherPanel switcher) {
                if (switcher == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(0);
                }
                super(switcher);
                this.addChangeListener(this);
                this.setComparator(new SpeedSearchComparator(false, true));
            }

            @Override
            protected void processKeyEvent(@NotNull KeyEvent e) {
                int keyCode;
                if (e == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(1);
                }
                if ((keyCode = e.getKeyCode()) == 10) {
                    SWITCHER.navigate(e);
                    e.consume();
                    return;
                }
                if (keyCode == 37 || keyCode == 39) {
                    return;
                }
                super.processKeyEvent(e);
            }

            @Override
            protected int getSelectedIndex() {
                return ((SwitcherPanel)this.myComponent).isFilesSelected() ? ((SwitcherPanel)this.myComponent).files.getSelectedIndex() : ((SwitcherPanel)this.myComponent).files.getModel().getSize() + ((SwitcherPanel)this.myComponent).toolWindows.getSelectedIndex();
            }

            @Override
            protected Object @NotNull [] getAllElements() {
                ListModel filesModel = ((SwitcherPanel)this.myComponent).files.getModel();
                Object[] files2 = new Object[filesModel.getSize()];
                for (int i2 = 0; i2 < files2.length; ++i2) {
                    files2[i2] = filesModel.getElementAt(i2);
                }
                ListModel twModel = ((SwitcherPanel)this.myComponent).toolWindows.getModel();
                Object[] toolWindows = new Object[twModel.getSize()];
                for (int i3 = 0; i3 < toolWindows.length; ++i3) {
                    toolWindows[i3] = twModel.getElementAt(i3);
                }
                Object[] elements2 = new Object[files2.length + toolWindows.length];
                System.arraycopy(files2, 0, elements2, 0, files2.length);
                System.arraycopy(toolWindows, 0, elements2, files2.length, toolWindows.length);
                if (elements2 == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(2);
                }
                return elements2;
            }

            @Override
            protected String getElementText(Object element2) {
                if (element2 instanceof ToolWindow) {
                    return ((ToolWindow)element2).getStripeTitle();
                }
                if (element2 instanceof FileInfo) {
                    return ((FileInfo)((Object)element2)).getNameForRendering();
                }
                return "";
            }

            @Override
            protected void selectElement(Object element2, String selectedText) {
                if (element2 instanceof FileInfo) {
                    if (!((SwitcherPanel)this.myComponent).toolWindows.isSelectionEmpty()) {
                        ((SwitcherPanel)this.myComponent).toolWindows.clearSelection();
                    }
                    ((SwitcherPanel)this.myComponent).files.clearSelection();
                    ((SwitcherPanel)this.myComponent).files.setSelectedValue(element2, true);
                    ((SwitcherPanel)this.myComponent).files.requestFocusInWindow();
                } else {
                    if (!((SwitcherPanel)this.myComponent).files.isSelectionEmpty()) {
                        ((SwitcherPanel)this.myComponent).files.clearSelection();
                    }
                    ((SwitcherPanel)this.myComponent).toolWindows.clearSelection();
                    ((SwitcherPanel)this.myComponent).toolWindows.setSelectedValue(element2, true);
                    ((SwitcherPanel)this.myComponent).toolWindows.requestFocusInWindow();
                }
            }

            @Override
            @Nullable
            protected Object findElement(@NotNull String s) {
                List<SpeedSearchObjectWithWeight> elements2;
                if (s == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(3);
                }
                return (elements2 = SpeedSearchObjectWithWeight.findElement(s, this)).isEmpty() ? null : elements2.get((int)0).node;
            }

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                if (evt == null) {
                    SwitcherSpeedSearch.$$$reportNull$$$0(4);
                }
                if (((SwitcherPanel)this.myComponent).project.isDisposed()) {
                    ((SwitcherPanel)this.myComponent).myPopup.cancel();
                    return;
                }
                ((NameFilteringListModel)((SwitcherPanel)this.myComponent).files.getModel()).refilter();
                ((NameFilteringListModel)((SwitcherPanel)this.myComponent).toolWindows.getModel()).refilter();
                if (((SwitcherPanel)this.myComponent).files.getModel().getSize() + ((SwitcherPanel)this.myComponent).toolWindows.getModel().getSize() == 0) {
                    ((SwitcherPanel)this.myComponent).toolWindows.getEmptyText().setText("");
                    ((SwitcherPanel)this.myComponent).files.getEmptyText().setText(IdeBundle.message((String)"empty.text.press.enter.to.search.in.project", (Object[])new Object[0]));
                } else {
                    ((SwitcherPanel)this.myComponent).files.getEmptyText().setText(StatusText.getDefaultEmptyText());
                    ((SwitcherPanel)this.myComponent).toolWindows.getEmptyText().setText(StatusText.getDefaultEmptyText());
                }
                this.refreshSelection();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = Switcher.SWITCHER_FEATURE_ID;
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "s";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "evt";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ide/actions/Switcher$SwitcherPanel$SwitcherSpeedSearch";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAllElements";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "processKeyEvent";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "findElement";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "propertyChange";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        private class MyFilesListFocusListener
        extends FocusAdapter {
            private MyFilesListFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                SwitcherPanel.exchangeSelectionState(SwitcherPanel.this.toolWindows, SwitcherPanel.this.files);
            }
        }

        private class MyToolWindowsListFocusListener
        extends FocusAdapter {
            private MyToolWindowsListFocusListener() {
            }

            @Override
            public void focusGained(FocusEvent e) {
                SwitcherPanel.exchangeSelectionState(SwitcherPanel.this.files, SwitcherPanel.this.toolWindows);
            }
        }

        private class MyFocusTraversalPolicy
        extends FocusTraversalPolicy {
            private MyFocusTraversalPolicy() {
            }

            @Override
            public Component getComponentAfter(Container aContainer, Component aComponent) {
                return aComponent == SwitcherPanel.this.toolWindows ? SwitcherPanel.this.files : SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getComponentBefore(Container aContainer, Component aComponent) {
                return aComponent == SwitcherPanel.this.toolWindows ? SwitcherPanel.this.files : SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getFirstComponent(Container aContainer) {
                return SwitcherPanel.this.toolWindows;
            }

            @Override
            public Component getLastComponent(Container aContainer) {
                return SwitcherPanel.this.files;
            }

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return SwitcherPanel.this.files;
            }
        }
    }

    public static class IterateItemsAction
    extends DumbAwareAction
    implements DumbAware {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            SwitcherPanel switcherPanel;
            if (e == null) {
                IterateItemsAction.$$$reportNull$$$0(0);
            }
            if ((switcherPanel = (SwitcherPanel)SWITCHER_KEY.get((UserDataHolder)(project = e.getProject()))) != null) {
                switcherPanel.goForward();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                IterateItemsAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(SWITCHER_KEY.get((UserDataHolder)project) != null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/Switcher$IterateItemsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ToggleCheckBoxAction
    extends DumbAwareAction
    implements DumbAware,
    LightEditCompatible {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            SwitcherPanel switcherPanel;
            if (e == null) {
                ToggleCheckBoxAction.$$$reportNull$$$0(0);
            }
            if ((switcherPanel = (SwitcherPanel)SWITCHER_KEY.get((UserDataHolder)(project = e.getProject()))) != null) {
                switcherPanel.toggleShowEditedFiles();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleCheckBoxAction.$$$reportNull$$$0(1);
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(SWITCHER_KEY.get((UserDataHolder)project) != null);
        }

        static boolean isEnabled() {
            return KeymapUtil.getActiveKeymapShortcuts((String)Switcher.TOGGLE_CHECK_BOX_ACTION_ID).getShortcuts().length > 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ide/actions/Switcher$ToggleCheckBoxAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

