/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.lightEdit.actions.associate.linux;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PlatformUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class MimeTypeDescription
implements Comparable<MimeTypeDescription> {
    private static final String TYPE_PREFIX = "application/x-" + PlatformUtils.getPlatformPrefix() + "-";
    private static final Map<String, String> OS_MIME_TYPES = new HashMap<String, String>();
    private final List<String> myGlobPatterns;
    private final String myComment;
    private final String myType;
    private boolean myIsStandard;

    MimeTypeDescription(@NotNull FileType fileType) {
        if (fileType == null) {
            MimeTypeDescription.$$$reportNull$$$0(0);
        }
        this.myGlobPatterns = new ArrayList<String>();
        this.myComment = fileType.getDescription();
        this.myType = this.getMimeType(fileType);
        for (FileNameMatcher matcher : FileTypeManager.getInstance().getAssociations(fileType)) {
            this.myGlobPatterns.add(matcher.getPresentableString());
        }
    }

    private String getMimeType(@NotNull FileType fileType) {
        String[] mimeTypes;
        if (fileType == null) {
            MimeTypeDescription.$$$reportNull$$$0(1);
        }
        if (fileType instanceof LanguageFileType && (mimeTypes = ((LanguageFileType)fileType).getLanguage().getMimeTypes()).length > 0) {
            return mimeTypes[0];
        }
        String typeName = fileType.getName();
        if (OS_MIME_TYPES.containsKey(typeName)) {
            this.myIsStandard = true;
            return OS_MIME_TYPES.get(typeName);
        }
        String fromName = StringUtil.toLowerCase((String)typeName);
        fromName = TYPE_PREFIX + fromName.replace(" ", "-");
        return fromName;
    }

    List<String> getGlobPatterns() {
        return this.myGlobPatterns;
    }

    String getComment() {
        return this.myComment;
    }

    String getType() {
        return this.myType;
    }

    @Override
    public int compareTo(@NotNull MimeTypeDescription o) {
        if (o == null) {
            MimeTypeDescription.$$$reportNull$$$0(2);
        }
        return this.myType.compareTo(o.myType);
    }

    boolean isStandard() {
        return this.myIsStandard;
    }

    static {
        OS_MIME_TYPES.put("ASP", "application/x-asp");
        OS_MIME_TYPES.put("CMakeLists.txt", "text/x-cmake");
        OS_MIME_TYPES.put("CSS", "text/css");
        OS_MIME_TYPES.put("Cucumber", "text/x-gherkin");
        OS_MIME_TYPES.put("DTD", "application/xml-dtd");
        OS_MIME_TYPES.put("Go", "text/x-go");
        OS_MIME_TYPES.put("Groovy", "text/x-groovy");
        OS_MIME_TYPES.put("HTML", "text/html");
        OS_MIME_TYPES.put("JAVA", "text/x-java");
        OS_MIME_TYPES.put("JSON", "application/json");
        OS_MIME_TYPES.put("JavaScript", "application/javascript");
        OS_MIME_TYPES.put("Jupyter", "application/x-ipynb+json");
        OS_MIME_TYPES.put("Log", "text/x-log");
        OS_MIME_TYPES.put("Markdown", "text/markdown");
        OS_MIME_TYPES.put("ObjectiveC", "text/x-c++src");
        OS_MIME_TYPES.put("PHP", "application/x-php");
        OS_MIME_TYPES.put("PLAIN_TEXT", "text/plain");
        OS_MIME_TYPES.put("Python", "text/x-python");
        OS_MIME_TYPES.put("QT UI file", "application/x-designer");
        OS_MIME_TYPES.put("RNG Compact", "application/relax-ng-compact-syntax");
        OS_MIME_TYPES.put("ReST", "text/x-rst");
        OS_MIME_TYPES.put("Ruby", "application/x-ruby");
        OS_MIME_TYPES.put("SCSS", "text/x-scss");
        OS_MIME_TYPES.put("SVG", "image/svg+xml");
        OS_MIME_TYPES.put("Sass", "text/x-sass");
        OS_MIME_TYPES.put("XHTML", "text/xhtml+xml");
        OS_MIME_TYPES.put("XML", "application/xml");
        OS_MIME_TYPES.put("YAML", "application/x-yaml");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/lightEdit/actions/associate/linux/MimeTypeDescription";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getMimeType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

