/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.DockableEditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileEditor.impl.text.FileDropHandler;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FloatingDecorator;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.openapi.wm.impl.FrameTitleBuilder;
import com.intellij.openapi.wm.impl.IdeBackgroundUtil;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdePanePanel;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.docking.DockContainer;
import com.intellij.ui.docking.DockManager;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ArrayListSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public class EditorsSplitters
extends IdePanePanel
implements UISettingsListener {
    private static final Key<Activity> OPEN_FILES_ACTIVITY = Key.create((String)"open.files.activity");
    private static final Logger LOG = Logger.getInstance(EditorsSplitters.class);
    private static final String PINNED = "pinned";
    private static final String CURRENT_IN_TAB = "current-in-tab";
    private static final Key<Object> DUMMY_KEY = Key.create((String)"EditorsSplitters.dummy.key");
    private static final Key<Boolean> OPENED_IN_BULK = Key.create((String)"EditorSplitters.opened.in.bulk");
    private EditorWindow myCurrentWindow;
    private final Set<EditorWindow> myWindows;
    private final FileEditorManagerImpl myManager;
    private Element mySplittersElement;
    int myInsideChange;
    private final MyFocusWatcher myFocusWatcher;
    private final Alarm myIconUpdaterAlarm;
    final Disposable parentDisposable;
    private final UIBuilder myUIBuilder;
    private final Set<VirtualFile> myFilesToUpdateIconsFor;

    EditorsSplitters(@NotNull FileEditorManagerImpl manager, boolean createOwnDockableContainer, @NotNull Disposable parentDisposable) {
        if (manager == null) {
            EditorsSplitters.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EditorsSplitters.$$$reportNull$$$0(1);
        }
        super(new BorderLayout());
        this.myWindows = new CopyOnWriteArraySet<EditorWindow>();
        this.myUIBuilder = new UIBuilder();
        this.myFilesToUpdateIconsFor = new HashSet<VirtualFile>();
        this.myIconUpdaterAlarm = new Alarm(parentDisposable);
        this.parentDisposable = parentDisposable;
        this.setBackground((Color)JBColor.namedColor((String)"Editor.background", (Color)IdeBackgroundUtil.getIdeBackgroundColor()));
        PropertyChangeListener l = e -> {
            String propName = e.getPropertyName();
            if ("Editor.background".equals(propName) || "Editor.foreground".equals(propName) || "Editor.shortcutForeground".equals(propName)) {
                this.repaint();
            }
        };
        UIManager.getDefaults().addPropertyChangeListener(l);
        Disposer.register((Disposable)parentDisposable, () -> UIManager.getDefaults().removePropertyChangeListener(l));
        this.myManager = manager;
        this.myFocusWatcher = new MyFocusWatcher();
        Disposer.register((Disposable)parentDisposable, () -> this.myFocusWatcher.deinstall((Component)((Object)this)));
        this.setFocusTraversalPolicy(new MyFocusTraversalPolicy());
        this.setTransferHandler(new MyTransferHandler());
        this.clear();
        if (createOwnDockableContainer) {
            DockableEditorTabbedContainer dockable = new DockableEditorTabbedContainer(this.myManager.getProject(), this, false);
            DockManager.getInstance((Project)manager.getProject()).register((DockContainer)dockable, parentDisposable);
        }
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(@Nullable Keymap keymap2) {
                EditorsSplitters.this.invalidate();
                EditorsSplitters.this.repaint();
            }
        });
    }

    @NotNull
    public FileEditorManagerImpl getManager() {
        FileEditorManagerImpl fileEditorManagerImpl = this.myManager;
        if (fileEditorManagerImpl == null) {
            EditorsSplitters.$$$reportNull$$$0(2);
        }
        return fileEditorManagerImpl;
    }

    public void clear() {
        for (EditorWindow window : this.myWindows) {
            window.dispose();
        }
        this.removeAll();
        this.myWindows.clear();
        this.setCurrentWindow(null);
        this.repaint();
    }

    void startListeningFocus() {
        this.myFocusWatcher.install((Component)((Object)this));
    }

    @Nullable
    public VirtualFile getCurrentFile() {
        if (this.myCurrentWindow != null) {
            return this.myCurrentWindow.getSelectedFile();
        }
        return null;
    }

    private boolean showEmptyText() {
        return this.myCurrentWindow == null || this.myCurrentWindow.getFiles().length == 0;
    }

    protected void paintComponent(Graphics g) {
        if (this.showEmptyText()) {
            Graphics2D gg = IdeBackgroundUtil.withFrameBackground(g, (JComponent)((Object)this));
            super.paintComponent((Graphics)gg);
            g.setColor(StartupUiUtil.isUnderDarcula() ? JBColor.border() : new Color(0, 0, 0, 50));
            g.drawLine(0, 0, this.getWidth(), 0);
        }
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            EditorsSplitters.$$$reportNull$$$0(3);
        }
        if (this.getComponentCount() == 0) {
            return;
        }
        JPanel panel2 = (JPanel)this.getComponent(0);
        if (panel2.getComponentCount() != 0) {
            try {
                element2.addContent(this.writePanel(panel2.getComponent(0)));
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @NotNull
    private Element writePanel(@NotNull Component comp) {
        if (comp == null) {
            EditorsSplitters.$$$reportNull$$$0(4);
        }
        if (comp instanceof Splitter) {
            Splitter splitter = (Splitter)comp;
            Element res2 = new Element("splitter");
            res2.setAttribute("split-orientation", splitter.getOrientation() ? "vertical" : "horizontal");
            res2.setAttribute("split-proportion", Float.toString(splitter.getProportion()));
            Element first = new Element("split-first");
            first.addContent(this.writePanel(splitter.getFirstComponent().getComponent(0)));
            Element second = new Element("split-second");
            second.addContent(this.writePanel(splitter.getSecondComponent().getComponent(0)));
            res2.addContent(first);
            res2.addContent(second);
            Element element2 = res2;
            if (element2 == null) {
                EditorsSplitters.$$$reportNull$$$0(5);
            }
            return element2;
        }
        if (comp instanceof JBTabs) {
            EditorWindow window;
            Element result2 = new Element("leaf");
            Integer limit = (Integer)ComponentUtil.getClientProperty((JComponent)((JBTabs)comp).getComponent(), (Key)JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY);
            if (limit != null) {
                result2.setAttribute(JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY.toString(), String.valueOf(limit));
            }
            if ((window = this.findWindowWith(comp)) != null) {
                this.writeWindow(result2, window);
            }
            Element element3 = result2;
            if (element3 == null) {
                EditorsSplitters.$$$reportNull$$$0(6);
            }
            return element3;
        }
        throw new IllegalArgumentException(comp.getClass().getName());
    }

    private void writeWindow(@NotNull Element result2, @NotNull EditorWindow window) {
        if (result2 == null) {
            EditorsSplitters.$$$reportNull$$$0(7);
        }
        if (window == null) {
            EditorsSplitters.$$$reportNull$$$0(8);
        }
        EditorWithProviderComposite[] composites = window.getEditors();
        for (int i2 = 0; i2 < composites.length; ++i2) {
            VirtualFile file2 = window.getFileAt(i2);
            result2.addContent(this.writeComposite(composites[i2], window.isFilePinned(file2), window.getSelectedEditor()));
        }
    }

    @NotNull
    private Element writeComposite(@NotNull EditorWithProviderComposite composite, boolean pinned, @Nullable EditorWithProviderComposite selectedEditor) {
        if (composite == null) {
            EditorsSplitters.$$$reportNull$$$0(9);
        }
        Element fileElement = new Element("file");
        composite.currentStateAsHistoryEntry().writeExternal(fileElement, this.getManager().getProject());
        fileElement.setAttribute(PINNED, Boolean.toString(pinned));
        fileElement.setAttribute(CURRENT_IN_TAB, Boolean.toString(composite.equals(selectedEditor)));
        Element element2 = fileElement;
        if (element2 == null) {
            EditorsSplitters.$$$reportNull$$$0(10);
        }
        return element2;
    }

    @Nullable
    Ref<JPanel> restoreEditors() {
        Element element2 = this.mySplittersElement;
        if (element2 == null) {
            return null;
        }
        this.myManager.getProject().putUserData(OPEN_FILES_ACTIVITY, (Object)StartUpMeasurer.startActivity((String)"editor restoring till paint"));
        Activity restoringEditors = StartUpMeasurer.startMainActivity((String)"editor restoring");
        JPanel component2 = this.myUIBuilder.process(element2, this.getTopPanel());
        if (component2 != null) {
            component2.setFocusable(false);
        }
        restoringEditors.end();
        return new Ref((Object)component2);
    }

    void addSelectedEditorsTo(@NotNull Collection<? super FileEditor> result2) {
        FileEditor editor;
        EditorWithProviderComposite composite;
        if (result2 == null) {
            EditorsSplitters.$$$reportNull$$$0(11);
        }
        for (EditorWindow window : this.myWindows) {
            FileEditor editor2;
            EditorWithProviderComposite composite2 = window.getSelectedEditor();
            if (composite2 == null || result2.contains(editor2 = composite2.getSelectedEditor())) continue;
            result2.add((FileEditor)editor2);
        }
        EditorWindow currentWindow = this.getCurrentWindow();
        if (currentWindow != null && !this.myWindows.contains(currentWindow) && (composite = currentWindow.getSelectedEditor()) != null && !result2.contains(editor = composite.getSelectedEditor())) {
            result2.add((FileEditor)editor);
        }
    }

    public static void stopOpenFilesActivity(@NotNull Project project) {
        Activity activity;
        if (project == null) {
            EditorsSplitters.$$$reportNull$$$0(12);
        }
        if ((activity = (Activity)project.getUserData(OPEN_FILES_ACTIVITY)) != null) {
            activity.end();
            project.putUserData(OPEN_FILES_ACTIVITY, null);
        }
    }

    public void openFiles() {
        Ref<JPanel> componentRef = this.restoreEditors();
        if (componentRef == null) {
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> this.doOpenFiles((JPanel)componentRef.get()), ModalityState.any());
    }

    void doOpenFiles(@Nullable JPanel component2) {
        if (component2 != null) {
            this.removeAll();
            this.add(component2, "Center");
            this.mySplittersElement = null;
        }
        for (EditorWindow window : this.getWindows()) {
            if (window.getTabCount() != 0) continue;
            window.removeFromSplitter();
        }
    }

    public void readExternal(@NotNull Element element2) {
        if (element2 == null) {
            EditorsSplitters.$$$reportNull$$$0(13);
        }
        this.mySplittersElement = element2;
    }

    @NotNull
    List<VirtualFile> getOpenFileList() {
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (EditorWindow myWindow : this.myWindows) {
            for (EditorWithProviderComposite editor : myWindow.getEditors()) {
                VirtualFile file2 = editor.getFile();
                if (files2.contains(file2)) continue;
                files2.add(file2);
            }
        }
        ArrayList<VirtualFile> arrayList = files2;
        if (arrayList == null) {
            EditorsSplitters.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public @NotNull VirtualFile @NotNull [] getOpenFiles() {
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.getOpenFileList());
        if (virtualFileArray == null) {
            EditorsSplitters.$$$reportNull$$$0(15);
        }
        return virtualFileArray;
    }

    public VirtualFile @NotNull [] getSelectedFiles() {
        ArrayListSet files2 = new ArrayListSet();
        for (EditorWindow window : this.myWindows) {
            VirtualFile file2 = window.getSelectedFile();
            if (file2 == null) continue;
            files2.add(file2);
        }
        VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)files2);
        VirtualFile currentFile = this.getCurrentFile();
        if (currentFile != null) {
            for (int i2 = 0; i2 != virtualFiles.length; ++i2) {
                if (!Comparing.equal((Object)virtualFiles[i2], (Object)currentFile)) continue;
                virtualFiles[i2] = virtualFiles[0];
                virtualFiles[0] = currentFile;
                break;
            }
        }
        if (virtualFiles == null) {
            EditorsSplitters.$$$reportNull$$$0(16);
        }
        return virtualFiles;
    }

    public FileEditor @NotNull [] getSelectedEditors() {
        THashSet windows = new THashSet(this.myWindows);
        EditorWindow currentWindow = this.getCurrentWindow();
        if (currentWindow != null) {
            windows.add(currentWindow);
        }
        ArrayList<FileEditor> editors = new ArrayList<FileEditor>();
        for (EditorWindow window : windows) {
            EditorWithProviderComposite composite = window.getSelectedEditor();
            if (composite == null) continue;
            editors.add(composite.getSelectedEditor());
        }
        FileEditor[] fileEditorArray = editors.toArray(FileEditor.EMPTY_ARRAY);
        if (fileEditorArray == null) {
            EditorsSplitters.$$$reportNull$$$0(17);
        }
        return fileEditorArray;
    }

    public void updateFileIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(18);
        }
        this.updateFileIconLater(file2);
    }

    void updateFileIconImmediately(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(19);
        }
        List<EditorWindow> windows = this.findWindows(file2);
        for (EditorWindow window : windows) {
            window.updateFileIcon(file2);
        }
    }

    private void updateFileIconLater(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(20);
        }
        this.myFilesToUpdateIconsFor.add(file2);
        this.myIconUpdaterAlarm.cancelAllRequests();
        this.myIconUpdaterAlarm.addRequest(() -> {
            if (this.myManager.getProject().isDisposed()) {
                return;
            }
            for (VirtualFile file1 : this.myFilesToUpdateIconsFor) {
                this.updateFileIconImmediately(file1);
            }
            this.myFilesToUpdateIconsFor.clear();
        }, 200, ModalityState.stateForComponent((Component)((Object)this)));
    }

    void updateFileColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(21);
        }
        List<EditorWindow> windows = this.findWindows(file2);
        for (EditorWindow window : windows) {
            int index = window.findEditorIndex(window.findFileComposite(file2));
            LOG.assertTrue(index != -1);
            window.setForegroundAt(index, this.getManager().getFileColor(file2));
            window.setWaveColor(index, (Color)(this.getManager().isProblem(file2) ? JBColor.red : null));
        }
    }

    public void trimToSize() {
        for (EditorWindow window : this.myWindows) {
            window.trimToSize(window.getSelectedFile(), true);
        }
    }

    void updateTabsLayout(@NotNull TabsLayoutInfo newTabsLayoutInfo) {
        if (newTabsLayoutInfo == null) {
            EditorsSplitters.$$$reportNull$$$0(22);
        }
        EditorWindow[] windows = this.getWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            windows[i2].updateTabsLayout(newTabsLayoutInfo);
        }
    }

    public void setTabsPlacement(int tabPlacement) {
        EditorWindow[] windows = this.getWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            windows[i2].setTabsPlacement(tabPlacement);
        }
    }

    void setTabLayoutPolicy(int scrollTabLayout) {
        EditorWindow[] windows = this.getWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            windows[i2].setTabLayoutPolicy(scrollTabLayout);
        }
    }

    void updateFileName(@Nullable VirtualFile updatedFile) {
        for (EditorWindow window : this.getWindows()) {
            for (VirtualFile file2 : window.getFiles()) {
                if (updatedFile != null && !file2.getName().equals(updatedFile.getName())) continue;
                window.updateFileName(file2);
            }
        }
        Project project = this.myManager.getProject();
        IdeFrameEx frame = this.getFrame(project);
        if (frame != null) {
            String fileTitle = null;
            Path ioFile = null;
            VirtualFile file3 = this.getCurrentFile();
            if (file3 != null) {
                try {
                    ioFile = file3 instanceof LightVirtualFileBase ? null : Paths.get(file3.getPresentableUrl(), new String[0]);
                }
                catch (InvalidPathException error) {
                    LOG.info(String.format("Presentable URL %s of file %s can't be mapped on the local filesystem.", file3.getPresentableUrl(), file3), (Throwable)error);
                }
                fileTitle = FrameTitleBuilder.getInstance().getFileTitle(project, file3);
            }
            frame.setFileTitle(fileTitle, ioFile);
        }
    }

    @Nullable
    protected IdeFrameEx getFrame(@NotNull Project project) {
        if (project == null) {
            EditorsSplitters.$$$reportNull$$$0(23);
        }
        ProjectFrameHelper frame = WindowManagerEx.getInstanceEx().getFrameHelper(project);
        LOG.assertTrue(ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment() || frame != null);
        return frame;
    }

    boolean isInsideChange() {
        return this.myInsideChange > 0;
    }

    private void setCurrentWindow(@Nullable EditorWindow currentWindow) {
        if (currentWindow != null && !this.myWindows.contains(currentWindow)) {
            throw new IllegalArgumentException(currentWindow + " is not a member of this container");
        }
        this.myCurrentWindow = currentWindow;
    }

    void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(24);
        }
        EditorWindow[] windows = this.getWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            windows[i2].updateFileBackgroundColor(file2);
        }
    }

    int getSplitCount() {
        if (this.getComponentCount() > 0) {
            JPanel panel2 = (JPanel)this.getComponent(0);
            return EditorsSplitters.getSplitCount(panel2);
        }
        return 0;
    }

    private static int getSplitCount(@NotNull JComponent component2) {
        if (component2 == null) {
            EditorsSplitters.$$$reportNull$$$0(25);
        }
        if (component2.getComponentCount() > 0) {
            JComponent firstChild = (JComponent)component2.getComponent(0);
            if (firstChild instanceof Splitter) {
                Splitter splitter = (Splitter)firstChild;
                return EditorsSplitters.getSplitCount(splitter.getFirstComponent()) + EditorsSplitters.getSplitCount(splitter.getSecondComponent());
            }
            return 1;
        }
        return 0;
    }

    protected void afterFileClosed(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(26);
        }
    }

    protected void afterFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(27);
        }
    }

    @Nullable
    JBTabs getTabsAt(@NotNull RelativePoint point) {
        if (point == null) {
            EditorsSplitters.$$$reportNull$$$0(28);
        }
        Point thisPoint = point.getPoint((Component)((Object)this));
        for (Component c = SwingUtilities.getDeepestComponentAt((Component)((Object)this), thisPoint.x, thisPoint.y); c != null; c = c.getParent()) {
            if (!(c instanceof JBTabs)) continue;
            return (JBTabs)c;
        }
        return null;
    }

    boolean isEmptyVisible() {
        EditorWindow[] windows;
        for (EditorWindow each : windows = this.getWindows()) {
            if (each.isEmptyVisible()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private VirtualFile findNextFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(29);
        }
        EditorWindow[] windows = this.getWindows();
        for (int i2 = 0; i2 != windows.length; ++i2) {
            VirtualFile[] files2;
            for (VirtualFile fileAt : files2 = windows[i2].getFiles()) {
                if (Comparing.equal((Object)fileAt, (Object)file2)) continue;
                return fileAt;
            }
        }
        return null;
    }

    void closeFile(@NotNull VirtualFile file2, boolean moveFocus) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(30);
        }
        List<EditorWindow> windows = this.findWindows(file2);
        boolean isProjectOpen = this.myManager.getProject().isOpen();
        if (windows.isEmpty()) {
            return;
        }
        VirtualFile nextFile = this.findNextFile(file2);
        for (EditorWindow window : windows) {
            LOG.assertTrue(window.getSelectedEditor() != null);
            window.closeFile(file2, false, moveFocus);
            if (window.getTabCount() != 0 || nextFile == null || !isProjectOpen) continue;
            EditorWithProviderComposite newComposite = this.myManager.newEditorComposite(nextFile);
            window.setEditor(newComposite, moveFocus);
        }
        for (EditorWindow window : windows) {
            if (!isProjectOpen || window.isDisposed() || window.getTabCount() != 0) continue;
            window.unsplit(false);
        }
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            EditorsSplitters.$$$reportNull$$$0(31);
        }
        for (EditorWindow window : this.myWindows) {
            window.updateTabsVisibility(uiSettings);
        }
        if (!this.myManager.getProject().isOpen()) {
            return;
        }
        for (VirtualFile file2 : this.getOpenFileList()) {
            this.updateFileBackgroundColor(file2);
            this.updateFileIcon(file2);
            this.updateFileColor(file2);
        }
    }

    @Nullable
    public JPanel getTopPanel() {
        return this.getComponentCount() > 0 ? (JPanel)this.getComponent(0) : null;
    }

    public EditorWindow getCurrentWindow() {
        return this.myCurrentWindow;
    }

    @NotNull
    public EditorWindow getOrCreateCurrentWindow(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(32);
        }
        List<EditorWindow> windows = this.findWindows(file2);
        if (this.getCurrentWindow() == null) {
            Iterator<EditorWindow> iterator2 = this.myWindows.iterator();
            if (!windows.isEmpty()) {
                this.setCurrentWindow(windows.get(0), false);
            } else if (iterator2.hasNext()) {
                this.setCurrentWindow(iterator2.next(), false);
            } else {
                this.createCurrentWindow();
            }
        } else if (!windows.isEmpty() && !windows.contains(this.getCurrentWindow())) {
            this.setCurrentWindow(windows.get(0), false);
        }
        EditorWindow editorWindow = this.getCurrentWindow();
        if (editorWindow == null) {
            EditorsSplitters.$$$reportNull$$$0(33);
        }
        return editorWindow;
    }

    void createCurrentWindow() {
        LOG.assertTrue(this.myCurrentWindow == null);
        this.setCurrentWindow(this.createEditorWindow());
        this.add(this.myCurrentWindow.myPanel, "Center");
    }

    @NotNull
    private EditorWindow createEditorWindow() {
        return new EditorWindow(this, this.parentDisposable);
    }

    void setCurrentWindow(@Nullable EditorWindow window, boolean requestFocus) {
        EditorWithProviderComposite newEditor = window == null ? null : window.getSelectedEditor();
        Runnable fireRunnable = () -> this.getManager().fireSelectionChanged(newEditor);
        this.setCurrentWindow(window);
        this.getManager().updateFileName(window == null ? null : window.getSelectedFile());
        if (window != null) {
            EditorWithProviderComposite selectedEditor = window.getSelectedEditor();
            if (selectedEditor != null) {
                fireRunnable.run();
            }
            if (requestFocus) {
                window.requestFocus(true);
            }
        } else {
            fireRunnable.run();
        }
    }

    void addWindow(@NotNull EditorWindow window) {
        if (window == null) {
            EditorsSplitters.$$$reportNull$$$0(34);
        }
        this.myWindows.add(window);
    }

    void removeWindow(@NotNull EditorWindow window) {
        if (window == null) {
            EditorsSplitters.$$$reportNull$$$0(35);
        }
        this.myWindows.remove(window);
        if (this.myCurrentWindow == window) {
            this.myCurrentWindow = null;
        }
    }

    boolean containsWindow(@NotNull EditorWindow window) {
        if (window == null) {
            EditorsSplitters.$$$reportNull$$$0(36);
        }
        return this.myWindows.contains(window);
    }

    @Deprecated
    public EditorWithProviderComposite @NotNull [] getEditorsComposites() {
        EditorWithProviderComposite[] editorWithProviderCompositeArray = this.getEditorComposites().toArray(new EditorWithProviderComposite[0]);
        if (editorWithProviderCompositeArray == null) {
            EditorsSplitters.$$$reportNull$$$0(37);
        }
        return editorWithProviderCompositeArray;
    }

    @NotNull
    public List<EditorWithProviderComposite> getEditorComposites() {
        ArrayList<EditorWithProviderComposite> result2 = new ArrayList<EditorWithProviderComposite>();
        for (EditorWindow myWindow : this.myWindows) {
            ContainerUtil.addAll(result2, (Object[])myWindow.getEditors());
        }
        ArrayList<EditorWithProviderComposite> arrayList = result2;
        if (arrayList == null) {
            EditorsSplitters.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    public List<EditorWithProviderComposite> findEditorComposites(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(39);
        }
        ArrayList<EditorWithProviderComposite> res2 = new ArrayList<EditorWithProviderComposite>();
        for (EditorWindow window : this.myWindows) {
            EditorWithProviderComposite fileComposite = window.findFileComposite(file2);
            if (fileComposite == null) continue;
            res2.add(fileComposite);
        }
        ArrayList<EditorWithProviderComposite> arrayList = res2;
        if (arrayList == null) {
            EditorsSplitters.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    @NotNull
    private List<EditorWindow> findWindows(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(41);
        }
        ArrayList<EditorWindow> res2 = new ArrayList<EditorWindow>();
        for (EditorWindow window : this.myWindows) {
            if (window.findFileComposite(file2) == null) continue;
            res2.add(window);
        }
        ArrayList<EditorWindow> arrayList = res2;
        if (arrayList == null) {
            EditorsSplitters.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    public EditorWindow @NotNull [] getWindows() {
        EditorWindow[] editorWindowArray = this.myWindows.toArray(new EditorWindow[0]);
        if (editorWindowArray == null) {
            EditorsSplitters.$$$reportNull$$$0(43);
        }
        return editorWindowArray;
    }

    @NotNull
    List<EditorWindow> getOrderedWindows() {
        final ArrayList<EditorWindow> result2 = new ArrayList<EditorWindow>();
        if (this.getComponentCount() != 0) {
            Component comp = this.getComponent(0);
            LOG.assertTrue(comp instanceof JPanel);
            JPanel panel2 = (JPanel)comp;
            if (panel2.getComponentCount() != 0) {
                class WindowCollector {
                    WindowCollector() {
                    }

                    private void collect(@NotNull JPanel panel2) {
                        EditorWindow window;
                        Component comp;
                        if (panel2 == null) {
                            WindowCollector.$$$reportNull$$$0(0);
                        }
                        if ((comp = panel2.getComponent(0)) instanceof Splitter) {
                            Splitter splitter = (Splitter)comp;
                            this.collect((JPanel)splitter.getFirstComponent());
                            this.collect((JPanel)splitter.getSecondComponent());
                        } else if ((comp instanceof JPanel || comp instanceof JBTabs) && (window = EditorsSplitters.this.findWindowWith(comp)) != null) {
                            result2.add(window);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$1WindowCollector", "collect"));
                    }
                }
                new WindowCollector().collect(panel2);
            }
        }
        LOG.assertTrue(result2.size() == this.myWindows.size());
        ArrayList<EditorWindow> arrayList = result2;
        if (arrayList == null) {
            EditorsSplitters.$$$reportNull$$$0(44);
        }
        return arrayList;
    }

    @Nullable
    private EditorWindow findWindowWith(@NotNull Component component2) {
        if (component2 == null) {
            EditorsSplitters.$$$reportNull$$$0(45);
        }
        for (EditorWindow window : this.myWindows) {
            if (!SwingUtilities.isDescendingFrom(component2, window.myPanel)) continue;
            return window;
        }
        return null;
    }

    public boolean isFloating() {
        return false;
    }

    public static boolean isOpenedInBulk(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorsSplitters.$$$reportNull$$$0(46);
        }
        return file2.getUserData(OPENED_IN_BULK) != null;
    }

    @Nullable
    private static EditorsSplitters getSplittersToFocus(@Nullable Project project) {
        Window activeWindow = WindowManagerEx.getInstanceEx().getMostRecentFocusedWindow();
        if (activeWindow instanceof FloatingDecorator) {
            FileEditorManagerEx fileEditorManager;
            IdeFrame lastFocusedFrame = IdeFocusManager.findInstanceByComponent((Component)activeWindow).getLastFocusedFrame();
            JComponent frameComponent = lastFocusedFrame != null ? lastFocusedFrame.getComponent() : null;
            Window lastFocusedWindow = frameComponent == null ? null : SwingUtilities.getWindowAncestor(frameComponent);
            activeWindow = (Window)ObjectUtils.notNull((Object)lastFocusedWindow, (Object)activeWindow);
            if (project == null) {
                project = lastFocusedFrame == null ? null : lastFocusedFrame.getProject();
            }
            FileEditorManagerEx fileEditorManagerEx = fileEditorManager = project == null || project.isDisposed() ? null : FileEditorManagerEx.getInstanceEx(project);
            if (fileEditorManager == null) {
                return null;
            }
            EditorsSplitters splitters = fileEditorManager.getSplittersFor(activeWindow);
            return splitters != null ? splitters : fileEditorManager.getSplitters();
        }
        if (activeWindow instanceof IdeFrame.Child) {
            if (project == null) {
                project = ((IdeFrame.Child)activeWindow).getProject();
            }
            return EditorsSplitters.getSplittersForProject(WindowManager.getInstance().getFrame(project), project);
        }
        IdeFrame frame = FocusManagerImpl.getInstance().getLastFocusedFrame();
        if (frame instanceof IdeFrameImpl && ((IdeFrameImpl)frame).isActive()) {
            return EditorsSplitters.getSplittersForProject(activeWindow, frame.getProject());
        }
        return null;
    }

    @Nullable
    private static EditorsSplitters getSplittersForProject(@Nullable Window activeWindow, @Nullable Project project) {
        FileEditorManagerEx fileEditorManager;
        FileEditorManagerEx fileEditorManagerEx = fileEditorManager = project == null || project.isDisposed() ? null : FileEditorManagerEx.getInstanceEx(project);
        if (fileEditorManager == null) {
            return null;
        }
        EditorsSplitters splitters = activeWindow == null ? null : fileEditorManager.getSplittersFor(activeWindow);
        return splitters == null ? fileEditorManager.getSplitters() : splitters;
    }

    @Nullable
    public static JComponent findDefaultComponentInSplitters(@Nullable Project project) {
        EditorWithProviderComposite editor;
        EditorsSplitters splittersToFocus = EditorsSplitters.getSplittersToFocus(project);
        if (splittersToFocus == null) {
            return null;
        }
        EditorWindow window = splittersToFocus.getCurrentWindow();
        EditorWithProviderComposite editorWithProviderComposite = editor = window == null ? null : window.getSelectedEditor();
        if (editor != null) {
            return editor.getPreferredFocusedComponent();
        }
        return null;
    }

    public static boolean focusDefaultComponentInSplittersIfPresent(@NotNull Project project) {
        JComponent defaultFocusedComponentInEditor;
        if (project == null) {
            EditorsSplitters.$$$reportNull$$$0(47);
        }
        if ((defaultFocusedComponentInEditor = EditorsSplitters.findDefaultComponentInSplitters(project)) != null) {
            defaultFocusedComponentInEditor.requestFocus();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorsSplitters";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comp";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: 
            case 34: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 12: 
            case 23: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 39: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTabsLayoutInfo";
                break;
            }
            case 25: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorsSplitters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "writePanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "writeComposite";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFileList";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenFiles";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedEditors";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateCurrentWindow";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorsComposites";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorComposites";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "findEditorComposites";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "findWindows";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindows";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderedWindows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "writePanel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeWindow";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeComposite";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSelectedEditorsTo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "stopOpenFilesActivity";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIcon";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIconImmediately";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIconLater";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateFileColor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsLayout";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getFrame";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getSplitCount";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "afterFileClosed";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "afterFileOpen";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTabsAt";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findNextFile";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateCurrentWindow";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addWindow";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "removeWindow";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "containsWindow";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "findEditorComposites";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "findWindows";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findWindowWith";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isOpenedInBulk";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "focusDefaultComponentInSplittersIfPresent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 33: 
            case 37: 
            case 38: 
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class UIBuilder
    extends ConfigTreeReader<JPanel> {
        private UIBuilder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected JPanel processFiles(@NotNull List<? extends Element> fileElements, int tabSizeLimit, JPanel context) {
            if (fileElements == null) {
                UIBuilder.$$$reportNull$$$0(0);
            }
            Ref windowRef = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                EditorWindow editorWindow = context == null ? EditorsSplitters.this.createEditorWindow() : EditorsSplitters.this.findWindowWith(context);
                windowRef.set((Object)editorWindow);
                if (editorWindow != null && tabSizeLimit != 1) {
                    ComponentUtil.putClientProperty((JComponent)editorWindow.getTabbedPane().getComponent(), (Key)JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY, (Object)tabSizeLimit);
                }
            });
            EditorWindow window = (EditorWindow)windowRef.get();
            LOG.assertTrue(window != null);
            VirtualFile focusedFile = null;
            FileEditorManagerImpl fileEditorManager = EditorsSplitters.this.getManager();
            for (int i2 = 0; i2 < fileElements.size(); ++i2) {
                Element file2 = fileElements.get(i2);
                Element historyElement = file2.getChild("entry");
                String fileName = historyElement.getAttributeValue("file");
                Activity activity = StartUpMeasurer.startActivity((String)PathUtil.getFileName((String)fileName), (ActivityCategory)ActivityCategory.REOPENING_EDITOR);
                HistoryEntry entry = HistoryEntry.createLight(fileEditorManager.getProject(), historyElement);
                VirtualFile virtualFile = entry.getFile();
                if (virtualFile == null) {
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        LOG.error((Throwable)new InvalidDataException("No file exists: " + entry.getFilePointer().getUrl()));
                    }
                } else {
                    FileEditorOpenOptions openOptions = new FileEditorOpenOptions().withPin(Boolean.valueOf(file2.getAttributeValue(EditorsSplitters.PINNED))).withIndex(i2).withReopeningEditorsOnStartup();
                    try {
                        virtualFile.putUserData(OPENED_IN_BULK, (Object)Boolean.TRUE);
                        Document document = (Document)ReadAction.compute(() -> virtualFile.isValid() ? FileDocumentManager.getInstance().getDocument(virtualFile) : null);
                        boolean isCurrentTab = Boolean.parseBoolean(file2.getAttributeValue(EditorsSplitters.CURRENT_IN_TAB));
                        fileEditorManager.openFileImpl4(window, virtualFile, entry, openOptions);
                        if (document != null) {
                            document.putUserData(DUMMY_KEY, null);
                        }
                        if (isCurrentTab) {
                            focusedFile = virtualFile;
                        }
                    }
                    catch (InvalidDataException e) {
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            LOG.error((Throwable)e);
                        }
                    }
                    finally {
                        virtualFile.putUserData(OPENED_IN_BULK, null);
                    }
                }
                activity.end();
            }
            if (focusedFile == null) {
                ToolWindowManager manager = ToolWindowManager.getInstance((Project)EditorsSplitters.this.getManager().getProject());
                manager.invokeLater(() -> {
                    ToolWindow toolWindow;
                    if (manager.getActiveToolWindowId() == null && (toolWindow = manager.getToolWindow("Project")) != null) {
                        toolWindow.activate(null);
                    }
                });
            } else {
                fileEditorManager.addSelectionRecord(focusedFile, window);
                VirtualFile finalFocusedFile = focusedFile;
                UIUtil.invokeLaterIfNeeded(() -> {
                    EditorWithProviderComposite editor = window.findFileComposite(finalFocusedFile);
                    if (editor != null) {
                        window.setEditor(editor, true, true);
                    }
                });
            }
            return window.myPanel;
        }

        @Override
        protected JPanel processSplitter(@NotNull Element splitterElement, Element firstChild, Element secondChild, JPanel context) {
            if (splitterElement == null) {
                UIBuilder.$$$reportNull$$$0(1);
            }
            if (context == null) {
                boolean orientation = "vertical".equals(splitterElement.getAttributeValue("split-orientation"));
                float proportion = Float.parseFloat(splitterElement.getAttributeValue("split-proportion"));
                JPanel firstComponent = this.process(firstChild, null);
                JPanel secondComponent = this.process(secondChild, null);
                Ref panelRef = new Ref();
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.setOpaque(false);
                    OnePixelSplitter splitter = new OnePixelSplitter(orientation, proportion, 0.1f, 0.9f);
                    panel2.add((Component)splitter, "Center");
                    splitter.setFirstComponent((JComponent)firstComponent);
                    splitter.setSecondComponent((JComponent)secondComponent);
                    panelRef.set((Object)panel2);
                });
                return (JPanel)panelRef.get();
            }
            Ref firstComponent = new Ref();
            Ref secondComponent = new Ref();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (context.getComponent(0) instanceof Splitter) {
                    Splitter splitter = (Splitter)context.getComponent(0);
                    firstComponent.set((Object)((JPanel)splitter.getFirstComponent()));
                    secondComponent.set((Object)((JPanel)splitter.getSecondComponent()));
                } else {
                    firstComponent.set((Object)context);
                    secondComponent.set((Object)context);
                }
            });
            this.process(firstChild, (JPanel)firstComponent.get());
            this.process(secondChild, (JPanel)secondComponent.get());
            return context;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "splitterElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorsSplitters$UIBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFiles";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processSplitter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class ConfigTreeReader<T> {
        private ConfigTreeReader() {
        }

        @Nullable
        public final T process(@NotNull Element element2, @Nullable T context) {
            List children2;
            Element splitterElement;
            if (element2 == null) {
                ConfigTreeReader.$$$reportNull$$$0(0);
            }
            if ((splitterElement = element2.getChild("splitter")) != null) {
                Element first = splitterElement.getChild("split-first");
                Element second = splitterElement.getChild("split-second");
                return this.processSplitter(splitterElement, first, second, context);
            }
            Element leaf = element2.getChild("leaf");
            if (leaf == null) {
                return null;
            }
            List fileElements = leaf.getChildren("file");
            if (fileElements.isEmpty()) {
                children2 = Collections.emptyList();
            } else {
                children2 = new ArrayList(fileElements.size());
                int toRemove2 = fileElements.size() - EditorWindow.getTabLimit();
                for (Element fileElement : fileElements) {
                    if (toRemove2 <= 0 || Boolean.parseBoolean(fileElement.getAttributeValue(EditorsSplitters.PINNED))) {
                        children2.add(fileElement);
                        continue;
                    }
                    --toRemove2;
                }
            }
            return this.processFiles(children2, StringUtil.parseInt((String)leaf.getAttributeValue(JBTabsImpl.SIDE_TABS_SIZE_LIMIT_KEY.toString()), (int)-1), context);
        }

        @Nullable
        abstract T processFiles(@NotNull List<? extends Element> var1, int var2, @Nullable T var3);

        @Nullable
        abstract T processSplitter(@NotNull Element var1, @Nullable Element var2, @Nullable Element var3, @Nullable T var4);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$ConfigTreeReader", "process"));
        }
    }

    private final class MyTransferHandler
    extends TransferHandler {
        private final FileDropHandler myFileDropHandler = new FileDropHandler(null);

        private MyTransferHandler() {
        }

        @Override
        public boolean importData(JComponent comp, Transferable t) {
            if (this.myFileDropHandler.canHandleDrop(t.getTransferDataFlavors())) {
                this.myFileDropHandler.handleDrop(t, EditorsSplitters.this.myManager.getProject(), EditorsSplitters.this.myCurrentWindow);
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            return this.myFileDropHandler.canHandleDrop(transferFlavors);
        }
    }

    private final class MyFocusWatcher
    extends FocusWatcher {
        private MyFocusWatcher() {
        }

        protected void focusedComponentChanged(Component component2, AWTEvent cause) {
            EditorWindow newWindow = null;
            if (component2 != null) {
                newWindow = EditorsSplitters.this.findWindowWith(component2);
            } else if (cause instanceof ContainerEvent && cause.getID() == 301) {
                return;
            }
            EditorsSplitters.this.setCurrentWindow(newWindow);
            EditorsSplitters.this.setCurrentWindow(newWindow, false);
        }
    }

    private final class MyFocusTraversalPolicy
    extends IdeFocusTraversalPolicy {
        private MyFocusTraversalPolicy() {
        }

        @Override
        public final Component getDefaultComponent(Container focusCycleRoot) {
            EditorWithProviderComposite selectedEditor;
            if (EditorsSplitters.this.myCurrentWindow != null && (selectedEditor = EditorsSplitters.this.myCurrentWindow.getSelectedEditor()) != null) {
                return IdeFocusTraversalPolicy.getPreferredFocusedComponent(selectedEditor.getFocusComponent(), this);
            }
            return IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)((Object)EditorsSplitters.this), this);
        }

        @Override
        @NotNull
        protected Project getProject() {
            Project project = EditorsSplitters.this.myManager.getProject();
            if (project == null) {
                MyFocusTraversalPolicy.$$$reportNull$$$0(0);
            }
            return project;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/EditorsSplitters$MyFocusTraversalPolicy", "getProject"));
        }
    }
}

