/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ex.ConfigurableCardPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class TabbedConfigurable
extends CompositeConfigurable<Configurable>
implements Configurable.NoScroll,
Configurable.NoMargin {
    protected TabbedPaneWrapper myTabbedPane;
    private final Disposable myDisposable = Disposer.newDisposable();

    public JComponent createComponent() {
        this.myTabbedPane = new TabbedPaneWrapper(this.myDisposable);
        this.createConfigurableTabs();
        JComponent component2 = this.myTabbedPane.getComponent();
        component2.setBorder((Border)JBUI.Borders.emptyTop((int)5));
        component2.setPreferredSize((Dimension)JBUI.size((int)500, (int)400));
        return component2;
    }

    protected void createConfigurableTabs() {
        for (Configurable configurable2 : this.getConfigurables()) {
            this.myTabbedPane.addTab(configurable2.getDisplayName(), ConfigurableCardPanel.createConfigurableComponent(configurable2));
        }
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        Disposer.dispose((Disposable)this.myDisposable);
        this.myTabbedPane = null;
    }
}

