/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.LibraryOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryTableImplUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.projectModel.ProjectModelBundle;
import com.intellij.util.PathUtil;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class ModuleLibraryOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements LibraryOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    private static final Logger LOG = Logger.getInstance(LibraryOrderEntryImpl.class);
    @NotNull
    private final Library myLibrary;
    @NonNls
    public static final String ENTRY_TYPE = "module-library";
    private boolean myExported;
    @NonNls
    private static final String EXPORTED_ATTR = "exported";

    private ModuleLibraryOrderEntryImpl(@NotNull Library library, @NotNull RootModelImpl rootModel, boolean isExported, @NotNull DependencyScope scope) {
        if (library == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(2);
        }
        super(rootModel, ProjectRootManagerImpl.getInstanceImpl(rootModel.getProject()));
        this.myLibrary = ((LibraryImpl)library).cloneLibrary(this.getRootModel());
        this.doinit();
        this.myExported = isExported;
        this.myScope = scope;
    }

    ModuleLibraryOrderEntryImpl(String name, PersistentLibraryKind kind, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, ProjectModelExternalSource externalSource) {
        if (rootModel == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(3);
        }
        if (projectRootManager == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(4);
        }
        super(rootModel, projectRootManager);
        this.myLibrary = LibraryTableImplUtil.createModuleLevelLibrary(name, kind, this.getRootModel(), externalSource);
        this.doinit();
    }

    ModuleLibraryOrderEntryImpl(@NotNull Element element2, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        if (element2 == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(5);
        }
        if (rootModel == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(6);
        }
        if (projectRootManager == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(7);
        }
        super(rootModel, projectRootManager);
        LOG.assertTrue(ENTRY_TYPE.equals(element2.getAttributeValue("type")));
        this.myExported = element2.getAttributeValue(EXPORTED_ATTR) != null;
        this.myScope = DependencyScope.readExternal((Element)element2);
        this.myLibrary = LibraryTableImplUtil.loadLibrary(element2, this.getRootModel());
        this.doinit();
    }

    private void doinit() {
        Disposer.register((Disposable)this, (Disposable)this.myLibrary);
        this.init();
    }

    @Override
    protected RootProvider getRootProvider() {
        return this.myLibrary.getRootProvider();
    }

    @NotNull
    public Library getLibrary() {
        Library library = this.myLibrary;
        if (library == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(8);
        }
        return library;
    }

    public boolean isModuleLevel() {
        return true;
    }

    public String getLibraryName() {
        return this.myLibrary.getName();
    }

    public String getLibraryLevel() {
        return "module";
    }

    @NotNull
    public String getPresentableName() {
        String name = this.myLibrary.getName();
        if (name != null) {
            String string = name;
            if (string == null) {
                ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (this.myLibrary instanceof LibraryEx && ((LibraryEx)this.myLibrary).isDisposed()) {
            return "<unknown>";
        }
        String[] urls = this.myLibrary.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            String url = urls[0];
            String string = PathUtil.toPresentableUrl((String)url);
            if (string == null) {
                ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = ProjectModelBundle.message((String)"library.empty.library.item", (Object[])new Object[0]);
        if (string == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isValid() {
        return !this.isDisposed();
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(12);
        }
        return (R)policy.visitLibraryOrderEntry((LibraryOrderEntry)this, initialValue);
    }

    public boolean isSynthetic() {
        return true;
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull ModifiableRootModel rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(13);
        }
        if (projectRootManager == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(14);
        }
        if (filePointerManager == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(15);
        }
        return new ModuleLibraryOrderEntryImpl(this.myLibrary, (RootModelImpl)rootModel, this.myExported, this.myScope);
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        if (rootElement == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(16);
        }
        Element element2 = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        if (this.myExported) {
            element2.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element2);
        this.myLibrary.writeExternal(element2);
        rootElement.addContent(element2);
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean value2) {
        this.getRootModel().assertWritable();
        this.myExported = value2;
    }

    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(17);
        }
        return dependencyScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            ModuleLibraryOrderEntryImpl.$$$reportNull$$$0(18);
        }
        this.getRootModel().assertWritable();
        this.myScope = scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleLibraryOrderEntryImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibrary";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

