/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.ide.ApplicationInitializedListener;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.UnknownLibraryKind;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

final class LibraryKindLoader
implements ApplicationInitializedListener {
    LibraryKindLoader() {
    }

    public void componentsInitialized() {
        LibraryType.EP_NAME.getExtensionList();
        LibraryType.EP_NAME.addExtensionPointListener(new ExtensionPointListener<LibraryType<?>>(){

            public void extensionAdded(@NotNull LibraryType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                WriteAction.run(() -> {
                    LibraryKind.registerKind(extension.getKind());
                    LibraryKindLoader.processAllLibraries(library -> LibraryKindLoader.rememberKind(extension.getKind(), library));
                });
            }

            public void extensionRemoved(@NotNull LibraryType<?> extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                LibraryKind.unregisterKind(extension.getKind());
                LibraryKindLoader.processAllLibraries(library -> LibraryKindLoader.forgetKind(extension.getKind(), library));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryKindLoader$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, null);
    }

    private static void processAllLibraries(@NotNull Consumer<Library> processor2) {
        if (processor2 == null) {
            LibraryKindLoader.$$$reportNull$$$0(0);
        }
        LibraryKindLoader.processLibraries(LibraryTablesRegistrar.getInstance().getLibraryTable(), processor2);
        for (LibraryTable table : LibraryTablesRegistrar.getInstance().getCustomLibraryTables()) {
            LibraryKindLoader.processLibraries(table, processor2);
        }
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            LibraryKindLoader.processLibraries(LibraryTablesRegistrar.getInstance().getLibraryTable(project), processor2);
            for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                for (Library library : OrderEntryUtil.getModuleLibraries((ModuleRootModel)ModuleRootManager.getInstance((Module)module))) {
                    processor2.accept(library);
                }
            }
        }
    }

    private static void processLibraries(@NotNull LibraryTable table, Consumer<Library> processor2) {
        if (table == null) {
            LibraryKindLoader.$$$reportNull$$$0(1);
        }
        for (Library library : table.getLibraries()) {
            processor2.accept(library);
        }
    }

    private static void forgetKind(@NotNull PersistentLibraryKind<?> kind, @NotNull Library library) {
        if (kind == null) {
            LibraryKindLoader.$$$reportNull$$$0(2);
        }
        if (library == null) {
            LibraryKindLoader.$$$reportNull$$$0(3);
        }
        if (kind.equals((Object)((LibraryEx)library).getKind())) {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            model.forgetKind();
            model.commit();
        }
    }

    private static void rememberKind(@NotNull PersistentLibraryKind<?> kind, @NotNull Library library) {
        PersistentLibraryKind libraryKind;
        if (kind == null) {
            LibraryKindLoader.$$$reportNull$$$0(4);
        }
        if (library == null) {
            LibraryKindLoader.$$$reportNull$$$0(5);
        }
        if ((libraryKind = ((LibraryEx)library).getKind()) instanceof UnknownLibraryKind && libraryKind.getKindId().equals(kind.getKindId())) {
            LibraryEx.ModifiableModelEx model = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
            model.restoreKind();
            model.commit();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryKindLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processAllLibraries";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processLibraries";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "forgetKind";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rememberKind";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

