/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.lookup.impl.PrefixChangeListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.stats.completion.CompletionFactorsInitializer;
import com.intellij.stats.completion.CompletionTrackerInitializer;
import com.intellij.stats.completion.LookupCompletedTracker;
import com.intellij.stats.completion.LookupSelectionTracker;
import com.intellij.stats.completion.LookupStartedTracker;
import com.intellij.stats.completion.LookupTracker;
import com.intellij.stats.completion.TimeBetweenTypingTracker;
import com.intellij.stats.personalization.UserFactorDescriptions;
import com.intellij.stats.personalization.UserFactorStorage;
import com.intellij.stats.personalization.UserFactorsManager;
import com.intellij.stats.personalization.session.SessionFactorsUtils;
import com.intellij.stats.personalization.session.SessionPrefixTracker;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u000e\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/intellij/stats/completion/CompletionFactorsInitializer;", "Lcom/intellij/stats/completion/LookupTracker;", "()V", "lookupCreated", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "storage", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "processSessionFactors", "lookupStorage", "processUserFactors", "shouldUseSessionFactors", "", "shouldUseUserFactors", "intellij.statsCollector"})
public final class CompletionFactorsInitializer
extends LookupTracker {
    @Override
    protected void lookupCreated(@NotNull LookupImpl lookup, @NotNull MutableLookupStorage storage) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull((Object)storage, (String)"storage");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode() && !CompletionTrackerInitializer.Companion.isEnabledInTests()) {
            return;
        }
        this.processUserFactors(lookup);
        this.processSessionFactors(lookup, storage);
    }

    private final boolean shouldUseUserFactors() {
        return UserFactorsManager.Companion.getENABLE_USER_FACTORS();
    }

    private final boolean shouldUseSessionFactors() {
        return SessionFactorsUtils.INSTANCE.shouldUseSessionFactors();
    }

    private final void processUserFactors(LookupImpl lookup) {
        if (!this.shouldUseUserFactors()) {
            return;
        }
        Project project = lookup.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"lookup.project");
        UserFactorStorage.Companion.applyOnBoth(project, UserFactorDescriptions.INSTANCE.getCOMPLETION_USAGE(), processUserFactors.1.INSTANCE);
        Project project2 = lookup.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"lookup.project");
        lookup.setPrefixChangeListener((PrefixChangeListener)new TimeBetweenTypingTracker(project2));
        lookup.addLookupListener((LookupListener)new LookupCompletedTracker());
        lookup.addLookupListener((LookupListener)new LookupStartedTracker());
    }

    private final void processSessionFactors(LookupImpl lookup, MutableLookupStorage lookupStorage) {
        if (!this.shouldUseSessionFactors()) {
            return;
        }
        lookup.setPrefixChangeListener((PrefixChangeListener)new SessionPrefixTracker(lookupStorage.getSessionFactors()));
        lookup.addLookupListener((LookupListener)new LookupSelectionTracker(lookupStorage));
    }
}

