/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.config;

import com.google.gson.GsonBuilder;
import com.intellij.internal.statistic.config.EventLogConfigParserException;
import com.intellij.internal.statistic.config.EventLogExternalSendSettings;
import com.intellij.internal.statistic.config.bean.EventLogBucketRange;
import com.intellij.internal.statistic.config.bean.EventLogConfigVersions;
import com.intellij.internal.statistic.config.bean.EventLogSendConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogBuildType;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventLogExternalSettings {
    public static final EventLogExternalSendSettings EMPTY = new EventLogExternalSendSettings(Collections.emptyMap(), Collections.emptyMap());
    public String productCode;
    public List<EventLogConfigVersions> versions;

    @NotNull
    public static EventLogExternalSendSettings parseSendSettings(@NotNull Reader reader, @NotNull String version) throws EventLogConfigParserException {
        if (reader == null) {
            EventLogExternalSettings.$$$reportNull$$$0(0);
        }
        if (version == null) {
            EventLogExternalSettings.$$$reportNull$$$0(1);
        }
        try {
            EventLogExternalSettings parsed = (EventLogExternalSettings)new GsonBuilder().create().fromJson(reader, EventLogExternalSettings.class);
            if (parsed != null) {
                return parsed.toSendSettings(version);
            }
        }
        catch (Exception e) {
            throw new EventLogConfigParserException(e);
        }
        EventLogExternalSendSettings eventLogExternalSendSettings = EMPTY;
        if (eventLogExternalSendSettings == null) {
            EventLogExternalSettings.$$$reportNull$$$0(2);
        }
        return eventLogExternalSendSettings;
    }

    @NotNull
    private EventLogExternalSendSettings toSendSettings(@NotNull String productVersion) {
        EventLogConfigVersions version;
        if (productVersion == null) {
            EventLogExternalSettings.$$$reportNull$$$0(3);
        }
        if ((version = this.findMajorVersion(productVersion)) == null) {
            EventLogExternalSendSettings eventLogExternalSendSettings = EMPTY;
            if (eventLogExternalSendSettings == null) {
                EventLogExternalSettings.$$$reportNull$$$0(4);
            }
            return eventLogExternalSendSettings;
        }
        EnumMap<EventLogBuildType, EventLogSendConfiguration> configurations = new EnumMap<EventLogBuildType, EventLogSendConfiguration>(EventLogBuildType.class);
        for (EventLogConfigVersions.EventLogConfigFilterCondition filter : version.getFilters()) {
            EventLogBuildType[] types;
            for (EventLogBuildType type : types = EventLogBuildType.getTypesByString(filter.releaseType)) {
                EventLogBucketRange range = filter.getBucketRange();
                if (range == null) continue;
                if (!configurations.containsKey((Object)type)) {
                    configurations.put(type, new EventLogSendConfiguration(new ArrayList<EventLogBucketRange>()));
                }
                ((EventLogSendConfiguration)configurations.get((Object)type)).addBucketRange(range);
            }
        }
        return new EventLogExternalSendSettings(version.getEndpoints(), configurations);
    }

    @Nullable
    private EventLogConfigVersions findMajorVersion(@NotNull String productVersion) {
        if (productVersion == null) {
            EventLogExternalSettings.$$$reportNull$$$0(5);
        }
        if (this.versions == null || this.versions.isEmpty()) {
            return null;
        }
        return this.versions.stream().filter(v -> v.majorBuildVersionBorders != null && v.majorBuildVersionBorders.accept(productVersion)).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/statistic/config/EventLogExternalSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "productVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/statistic/config/EventLogExternalSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSendSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toSendSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseSendSettings";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toSendSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMajorVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

